/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters a system instance search. Multiple filters function as OR criteria in the search. For example
 * a search that includes a GREENGRASS_GROUP_NAME and a STATUS filter searches for system instances in the specified
 * Greengrass group that have the specified status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemInstanceFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemInstanceFilter.Builder, SystemInstanceFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SystemInstanceFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("value")
            .getter(getter(SystemInstanceFilter::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> value;

    private SystemInstanceFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the search filter field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SystemInstanceFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the search filter field.
     * @see SystemInstanceFilterName
     */
    public final SystemInstanceFilterName name() {
        return SystemInstanceFilterName.fromValue(name);
    }

    /**
     * <p>
     * The name of the search filter field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SystemInstanceFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the search filter field.
     * @see SystemInstanceFilterName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Value property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasValue() {
        return value != null && !(value instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of string values for the search filter field. Multiple values function as AND criteria in the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValue} method.
     * </p>
     * 
     * @return An array of string values for the search filter field. Multiple values function as AND criteria in the
     *         search.
     */
    public final List<String> value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValue() ? value() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInstanceFilter)) {
            return false;
        }
        SystemInstanceFilter other = (SystemInstanceFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && hasValue() == other.hasValue()
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemInstanceFilter").add("Name", nameAsString()).add("Value", hasValue() ? value() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SystemInstanceFilter, T> g) {
        return obj -> g.apply((SystemInstanceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemInstanceFilter> {
        /**
         * <p>
         * The name of the search filter field.
         * </p>
         * 
         * @param name
         *        The name of the search filter field.
         * @see SystemInstanceFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemInstanceFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the search filter field.
         * </p>
         * 
         * @param name
         *        The name of the search filter field.
         * @see SystemInstanceFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemInstanceFilterName
         */
        Builder name(SystemInstanceFilterName name);

        /**
         * <p>
         * An array of string values for the search filter field. Multiple values function as AND criteria in the
         * search.
         * </p>
         * 
         * @param value
         *        An array of string values for the search filter field. Multiple values function as AND criteria in the
         *        search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Collection<String> value);

        /**
         * <p>
         * An array of string values for the search filter field. Multiple values function as AND criteria in the
         * search.
         * </p>
         * 
         * @param value
         *        An array of string values for the search filter field. Multiple values function as AND criteria in the
         *        search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String... value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> value = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SystemInstanceFilter model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SystemInstanceFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Collection<String> getValue() {
            if (value instanceof SdkAutoConstructList) {
                return null;
            }
            return value;
        }

        public final void setValue(Collection<String> value) {
            this.value = SystemInstanceFilterValuesCopier.copy(value);
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = SystemInstanceFilterValuesCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String... value) {
            value(Arrays.asList(value));
            return this;
        }

        @Override
        public SystemInstanceFilter build() {
            return new SystemInstanceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
