/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphServiceClientConfiguration;
import software.amazon.awssdk.services.iotthingsgraph.internal.IoTThingsGraphServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.InternalFailureException;
import software.amazon.awssdk.services.iotthingsgraph.model.InvalidRequestException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphException;
import software.amazon.awssdk.services.iotthingsgraph.model.LimitExceededException;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceInUseException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ThrottlingException;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.transform.AssociateEntityToThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DissociateEntityFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetNamespaceDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetUploadStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListFlowExecutionMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemInstancesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchThingsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UndeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UploadEntityDefinitionsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultIoTThingsGraphAsyncClient
implements IoTThingsGraphAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIoTThingsGraphAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTThingsGraphAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"IoTThingsGraph#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateEntityToThingResponse> associateEntityToThing(AssociateEntityToThingRequest associateEntityToThingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateEntityToThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, associateEntityToThingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateEntityToThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateEntityToThingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateEntityToThing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateEntityToThingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateEntityToThingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$associateEntityToThing$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$associateEntityToThing$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFlowTemplateResponse> createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFlowTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, createFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlowTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlowTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFlowTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$createFlowTemplate$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$createFlowTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSystemInstanceResponse> createSystemInstance(CreateSystemInstanceRequest createSystemInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSystemInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, createSystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSystemInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSystemInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSystemInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSystemInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$createSystemInstance$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$createSystemInstance$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSystemTemplateResponse> createSystemTemplate(CreateSystemTemplateRequest createSystemTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSystemTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, createSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSystemTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSystemTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSystemTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSystemTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$createSystemTemplate$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$createSystemTemplate$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFlowTemplateResponse> deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFlowTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlowTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlowTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFlowTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deleteFlowTemplate$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deleteFlowTemplate$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deleteNamespace$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deleteNamespace$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSystemInstanceResponse> deleteSystemInstance(DeleteSystemInstanceRequest deleteSystemInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSystemInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSystemInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSystemInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSystemInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSystemInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deleteSystemInstance$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deleteSystemInstance$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSystemTemplateResponse> deleteSystemTemplate(DeleteSystemTemplateRequest deleteSystemTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSystemTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSystemTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSystemTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSystemTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSystemTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deleteSystemTemplate$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deleteSystemTemplate$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeploySystemInstanceResponse> deploySystemInstance(DeploySystemInstanceRequest deploySystemInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deploySystemInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deploySystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeploySystemInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeploySystemInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeploySystemInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeploySystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deploySystemInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deploySystemInstance$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deploySystemInstance$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeprecateFlowTemplateResponse> deprecateFlowTemplate(DeprecateFlowTemplateRequest deprecateFlowTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deprecateFlowTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deprecateFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateFlowTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateFlowTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateFlowTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeprecateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deprecateFlowTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deprecateFlowTemplate$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deprecateFlowTemplate$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeprecateSystemTemplateResponse> deprecateSystemTemplate(DeprecateSystemTemplateRequest deprecateSystemTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deprecateSystemTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, deprecateSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateSystemTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateSystemTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateSystemTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeprecateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deprecateSystemTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$deprecateSystemTemplate$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$deprecateSystemTemplate$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNamespaceResponse> describeNamespace(DescribeNamespaceRequest describeNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, describeNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$describeNamespace$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$describeNamespace$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DissociateEntityFromThingResponse> dissociateEntityFromThing(DissociateEntityFromThingRequest dissociateEntityFromThingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)dissociateEntityFromThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, dissociateEntityFromThingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DissociateEntityFromThing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DissociateEntityFromThingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DissociateEntityFromThing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DissociateEntityFromThingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)dissociateEntityFromThingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$dissociateEntityFromThing$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$dissociateEntityFromThing$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEntitiesResponse> getEntities(GetEntitiesRequest getEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEntitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getEntities$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getEntities$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFlowTemplateResponse> getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFlowTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFlowTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFlowTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFlowTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFlowTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getFlowTemplate$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getFlowTemplate$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFlowTemplateRevisionsResponse> getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFlowTemplateRevisionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getFlowTemplateRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFlowTemplateRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFlowTemplateRevisionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFlowTemplateRevisions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetFlowTemplateRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFlowTemplateRevisionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getFlowTemplateRevisions$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getFlowTemplateRevisions$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetNamespaceDeletionStatusResponse> getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNamespaceDeletionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getNamespaceDeletionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamespaceDeletionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamespaceDeletionStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamespaceDeletionStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetNamespaceDeletionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getNamespaceDeletionStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getNamespaceDeletionStatus$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getNamespaceDeletionStatus$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSystemInstanceResponse> getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSystemInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getSystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSystemInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSystemInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getSystemInstance$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getSystemInstance$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSystemTemplateResponse> getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSystemTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSystemTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSystemTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getSystemTemplate$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getSystemTemplate$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSystemTemplateRevisionsResponse> getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSystemTemplateRevisionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getSystemTemplateRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSystemTemplateRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemTemplateRevisionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemTemplateRevisions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSystemTemplateRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSystemTemplateRevisionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getSystemTemplateRevisions$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getSystemTemplateRevisions$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUploadStatusResponse> getUploadStatus(GetUploadStatusRequest getUploadStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUploadStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, getUploadStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUploadStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUploadStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUploadStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetUploadStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUploadStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$getUploadStatus$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$getUploadStatus$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFlowExecutionMessagesResponse> listFlowExecutionMessages(ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlowExecutionMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, listFlowExecutionMessagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlowExecutionMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowExecutionMessagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlowExecutionMessages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFlowExecutionMessagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFlowExecutionMessagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$listFlowExecutionMessages$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$listFlowExecutionMessages$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$listTagsForResource$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$listTagsForResource$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchEntitiesResponse> searchEntities(SearchEntitiesRequest searchEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, searchEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchEntitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$searchEntities$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$searchEntities$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchFlowExecutionsResponse> searchFlowExecutions(SearchFlowExecutionsRequest searchFlowExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchFlowExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, searchFlowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchFlowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFlowExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFlowExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchFlowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchFlowExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$searchFlowExecutions$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$searchFlowExecutions$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchFlowTemplatesResponse> searchFlowTemplates(SearchFlowTemplatesRequest searchFlowTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchFlowTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, searchFlowTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchFlowTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFlowTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFlowTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchFlowTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchFlowTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$searchFlowTemplates$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$searchFlowTemplates$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchSystemInstancesResponse> searchSystemInstances(SearchSystemInstancesRequest searchSystemInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchSystemInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, searchSystemInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchSystemInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSystemInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSystemInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchSystemInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchSystemInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$searchSystemInstances$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$searchSystemInstances$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchSystemTemplatesResponse> searchSystemTemplates(SearchSystemTemplatesRequest searchSystemTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchSystemTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, searchSystemTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchSystemTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSystemTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSystemTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchSystemTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchSystemTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$searchSystemTemplates$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$searchSystemTemplates$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchThingsResponse> searchThings(SearchThingsRequest searchThingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchThingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, searchThingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchThings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchThingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchThings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchThingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchThingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$searchThings$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$searchThings$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$tagResource$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$tagResource$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UndeploySystemInstanceResponse> undeploySystemInstance(UndeploySystemInstanceRequest undeploySystemInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)undeploySystemInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, undeploySystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UndeploySystemInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeploySystemInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeploySystemInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UndeploySystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)undeploySystemInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$undeploySystemInstance$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$undeploySystemInstance$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$untagResource$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$untagResource$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlowTemplateResponse> updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlowTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$updateFlowTemplate$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$updateFlowTemplate$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSystemTemplateResponse> updateSystemTemplate(UpdateSystemTemplateRequest updateSystemTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSystemTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, updateSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSystemTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSystemTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSystemTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSystemTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$updateSystemTemplate$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$updateSystemTemplate$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UploadEntityDefinitionsResponse> uploadEntityDefinitions(UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)uploadEntityDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphAsyncClient.resolveMetricPublishers(clientConfiguration, uploadEntityDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UploadEntityDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadEntityDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadEntityDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UploadEntityDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)uploadEntityDefinitionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIoTThingsGraphAsyncClient.lambda$uploadEntityDefinitions$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphAsyncClient.lambda$uploadEntityDefinitions$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final IoTThingsGraphServiceClientConfiguration serviceClientConfiguration() {
        return new IoTThingsGraphServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "iotthingsgraph";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IoTThingsGraphException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        IoTThingsGraphServiceClientConfigurationBuilder serviceConfigBuilder = new IoTThingsGraphServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$uploadEntityDefinitions$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$uploadEntityDefinitions$138(List metricPublishers, MetricCollector apiCallMetricCollector, UploadEntityDefinitionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSystemTemplate$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSystemTemplate$134(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSystemTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFlowTemplate$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowTemplate$130(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlowTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$126(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$undeploySystemInstance$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$undeploySystemInstance$122(List metricPublishers, MetricCollector apiCallMetricCollector, UndeploySystemInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$118(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchThings$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchThings$114(List metricPublishers, MetricCollector apiCallMetricCollector, SearchThingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchSystemTemplates$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchSystemTemplates$110(List metricPublishers, MetricCollector apiCallMetricCollector, SearchSystemTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchSystemInstances$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchSystemInstances$106(List metricPublishers, MetricCollector apiCallMetricCollector, SearchSystemInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchFlowTemplates$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchFlowTemplates$102(List metricPublishers, MetricCollector apiCallMetricCollector, SearchFlowTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchFlowExecutions$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchFlowExecutions$98(List metricPublishers, MetricCollector apiCallMetricCollector, SearchFlowExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchEntities$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchEntities$94(List metricPublishers, MetricCollector apiCallMetricCollector, SearchEntitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFlowExecutionMessages$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlowExecutionMessages$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListFlowExecutionMessagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUploadStatus$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUploadStatus$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetUploadStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSystemTemplateRevisions$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSystemTemplateRevisions$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetSystemTemplateRevisionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSystemTemplate$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSystemTemplate$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetSystemTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSystemInstance$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSystemInstance$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetSystemInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getNamespaceDeletionStatus$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNamespaceDeletionStatus$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetNamespaceDeletionStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFlowTemplateRevisions$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFlowTemplateRevisions$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetFlowTemplateRevisionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFlowTemplate$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFlowTemplate$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetFlowTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEntities$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEntities$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetEntitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$dissociateEntityFromThing$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$dissociateEntityFromThing$50(List metricPublishers, MetricCollector apiCallMetricCollector, DissociateEntityFromThingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeNamespace$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNamespace$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deprecateSystemTemplate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateSystemTemplate$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeprecateSystemTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deprecateFlowTemplate$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateFlowTemplate$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeprecateFlowTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deploySystemInstance$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deploySystemInstance$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeploySystemInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSystemTemplate$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSystemTemplate$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSystemTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSystemInstance$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSystemInstance$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSystemInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteNamespace$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNamespace$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFlowTemplate$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlowTemplate$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFlowTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSystemTemplate$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSystemTemplate$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSystemTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSystemInstance$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSystemInstance$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSystemInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFlowTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlowTemplate$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFlowTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateEntityToThing$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateEntityToThing$2(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateEntityToThingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

