/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect
 * metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricsConfiguration.Builder, MetricsConfiguration> {
    private static final SdkField<Boolean> CLOUD_METRIC_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MetricsConfiguration::cloudMetricEnabled)).setter(setter(Builder::cloudMetricEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudMetricEnabled").build())
            .build();

    private static final SdkField<String> METRIC_RULE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricsConfiguration::metricRuleRoleArn)).setter(setter(Builder::metricRuleRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricRuleRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_METRIC_ENABLED_FIELD,
            METRIC_RULE_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean cloudMetricEnabled;

    private final String metricRuleRoleArn;

    private MetricsConfiguration(BuilderImpl builder) {
        this.cloudMetricEnabled = builder.cloudMetricEnabled;
        this.metricRuleRoleArn = builder.metricRuleRoleArn;
    }

    /**
     * <p>
     * A Boolean that specifies whether cloud metrics are collected.
     * </p>
     * 
     * @return A Boolean that specifies whether cloud metrics are collected.
     */
    public Boolean cloudMetricEnabled() {
        return cloudMetricEnabled;
    }

    /**
     * <p>
     * The ARN of the role that is used to collect cloud metrics.
     * </p>
     * 
     * @return The ARN of the role that is used to collect cloud metrics.
     */
    public String metricRuleRoleArn() {
        return metricRuleRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudMetricEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(metricRuleRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfiguration)) {
            return false;
        }
        MetricsConfiguration other = (MetricsConfiguration) obj;
        return Objects.equals(cloudMetricEnabled(), other.cloudMetricEnabled())
                && Objects.equals(metricRuleRoleArn(), other.metricRuleRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MetricsConfiguration").add("CloudMetricEnabled", cloudMetricEnabled())
                .add("MetricRuleRoleArn", metricRuleRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudMetricEnabled":
            return Optional.ofNullable(clazz.cast(cloudMetricEnabled()));
        case "metricRuleRoleArn":
            return Optional.ofNullable(clazz.cast(metricRuleRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsConfiguration, T> g) {
        return obj -> g.apply((MetricsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsConfiguration> {
        /**
         * <p>
         * A Boolean that specifies whether cloud metrics are collected.
         * </p>
         * 
         * @param cloudMetricEnabled
         *        A Boolean that specifies whether cloud metrics are collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudMetricEnabled(Boolean cloudMetricEnabled);

        /**
         * <p>
         * The ARN of the role that is used to collect cloud metrics.
         * </p>
         * 
         * @param metricRuleRoleArn
         *        The ARN of the role that is used to collect cloud metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricRuleRoleArn(String metricRuleRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean cloudMetricEnabled;

        private String metricRuleRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfiguration model) {
            cloudMetricEnabled(model.cloudMetricEnabled);
            metricRuleRoleArn(model.metricRuleRoleArn);
        }

        public final Boolean getCloudMetricEnabled() {
            return cloudMetricEnabled;
        }

        @Override
        public final Builder cloudMetricEnabled(Boolean cloudMetricEnabled) {
            this.cloudMetricEnabled = cloudMetricEnabled;
            return this;
        }

        public final void setCloudMetricEnabled(Boolean cloudMetricEnabled) {
            this.cloudMetricEnabled = cloudMetricEnabled;
        }

        public final String getMetricRuleRoleArn() {
            return metricRuleRoleArn;
        }

        @Override
        public final Builder metricRuleRoleArn(String metricRuleRoleArn) {
            this.metricRuleRoleArn = metricRuleRoleArn;
            return this;
        }

        public final void setMetricRuleRoleArn(String metricRuleRoleArn) {
            this.metricRuleRoleArn = metricRuleRoleArn;
        }

        @Override
        public MetricsConfiguration build() {
            return new MetricsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
