/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFlowExecutionsResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<SearchFlowExecutionsResponse.Builder, SearchFlowExecutionsResponse> {
    private static final SdkField<List<FlowExecutionSummary>> SUMMARIES_FIELD = SdkField
            .<List<FlowExecutionSummary>> builder(MarshallingType.LIST)
            .getter(getter(SearchFlowExecutionsResponse::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchFlowExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FlowExecutionSummary> summaries;

    private final String nextToken;

    private SearchFlowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of objects that contain summary information about each workflow execution in the result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects that contain summary information about each workflow execution in the result set.
     */
    public List<FlowExecutionSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * The string to specify as <code>nextToken</code> when you request the next page of results.
     * </p>
     * 
     * @return The string to specify as <code>nextToken</code> when you request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFlowExecutionsResponse)) {
            return false;
        }
        SearchFlowExecutionsResponse other = (SearchFlowExecutionsResponse) obj;
        return Objects.equals(summaries(), other.summaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchFlowExecutionsResponse").add("Summaries", summaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFlowExecutionsResponse, T> g) {
        return obj -> g.apply((SearchFlowExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchFlowExecutionsResponse> {
        /**
         * <p>
         * An array of objects that contain summary information about each workflow execution in the result set.
         * </p>
         * 
         * @param summaries
         *        An array of objects that contain summary information about each workflow execution in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<FlowExecutionSummary> summaries);

        /**
         * <p>
         * An array of objects that contain summary information about each workflow execution in the result set.
         * </p>
         * 
         * @param summaries
         *        An array of objects that contain summary information about each workflow execution in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(FlowExecutionSummary... summaries);

        /**
         * <p>
         * An array of objects that contain summary information about each workflow execution in the result set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FlowExecutionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<FlowExecutionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FlowExecutionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #summaries(List<FlowExecutionSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<FlowExecutionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<FlowExecutionSummary>)
         */
        Builder summaries(Consumer<FlowExecutionSummary.Builder>... summaries);

        /**
         * <p>
         * The string to specify as <code>nextToken</code> when you request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string to specify as <code>nextToken</code> when you request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private List<FlowExecutionSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFlowExecutionsResponse model) {
            super(model);
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final Collection<FlowExecutionSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(FlowExecutionSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder summaries(Collection<FlowExecutionSummary> summaries) {
            this.summaries = FlowExecutionSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(FlowExecutionSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<FlowExecutionSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> FlowExecutionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<FlowExecutionSummary.BuilderImpl> summaries) {
            this.summaries = FlowExecutionSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchFlowExecutionsResponse build() {
            return new SearchFlowExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
