/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error returned by the <code>BatchPutProperty</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutPropertyError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPutPropertyError.Builder, BatchPutPropertyError> {
    private static final SdkField<PropertyValueEntry> ENTRY_FIELD = SdkField
            .<PropertyValueEntry> builder(MarshallingType.SDK_POJO).memberName("entry")
            .getter(getter(BatchPutPropertyError::entry)).setter(setter(Builder::entry)).constructor(PropertyValueEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entry").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchPutPropertyError::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchPutPropertyError::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_FIELD, ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PropertyValueEntry entry;

    private final String errorCode;

    private final String errorMessage;

    private BatchPutPropertyError(BuilderImpl builder) {
        this.entry = builder.entry;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * An object that contains information about errors returned by the <code>BatchPutProperty</code> action.
     * </p>
     * 
     * @return An object that contains information about errors returned by the <code>BatchPutProperty</code> action.
     */
    public final PropertyValueEntry entry() {
        return entry;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message.
     * </p>
     * 
     * @return The error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entry());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutPropertyError)) {
            return false;
        }
        BatchPutPropertyError other = (BatchPutPropertyError) obj;
        return Objects.equals(entry(), other.entry()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutPropertyError").add("Entry", entry()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entry":
            return Optional.ofNullable(clazz.cast(entry()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutPropertyError, T> g) {
        return obj -> g.apply((BatchPutPropertyError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPutPropertyError> {
        /**
         * <p>
         * An object that contains information about errors returned by the <code>BatchPutProperty</code> action.
         * </p>
         * 
         * @param entry
         *        An object that contains information about errors returned by the <code>BatchPutProperty</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entry(PropertyValueEntry entry);

        /**
         * <p>
         * An object that contains information about errors returned by the <code>BatchPutProperty</code> action.
         * </p>
         * This is a convenience that creates an instance of the {@link PropertyValueEntry.Builder} avoiding the need to
         * create one manually via {@link PropertyValueEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link PropertyValueEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #entry(PropertyValueEntry)}.
         * 
         * @param entry
         *        a consumer that will call methods on {@link PropertyValueEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entry(PropertyValueEntry)
         */
        default Builder entry(Consumer<PropertyValueEntry.Builder> entry) {
            return entry(PropertyValueEntry.builder().applyMutation(entry).build());
        }

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message.
         * </p>
         * 
         * @param errorMessage
         *        The error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private PropertyValueEntry entry;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutPropertyError model) {
            entry(model.entry);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final PropertyValueEntry.Builder getEntry() {
            return entry != null ? entry.toBuilder() : null;
        }

        public final void setEntry(PropertyValueEntry.BuilderImpl entry) {
            this.entry = entry != null ? entry.build() : null;
        }

        @Override
        @Transient
        public final Builder entry(PropertyValueEntry entry) {
            this.entry = entry;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchPutPropertyError build() {
            return new BatchPutPropertyError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
