/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEntityRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<CreateEntityRequest.Builder, CreateEntityRequest> {
    private static final SdkField<Map<String, ComponentRequest>> COMPONENTS_FIELD = SdkField
            .<Map<String, ComponentRequest>> builder(MarshallingType.MAP)
            .memberName("components")
            .getter(getter(CreateEntityRequest::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEntityRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(CreateEntityRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityName").getter(getter(CreateEntityRequest::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()).build();

    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(CreateEntityRequest::parentEntityId))
            .setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateEntityRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateEntityRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD,
            DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_NAME_FIELD, PARENT_ENTITY_ID_FIELD, TAGS_FIELD, WORKSPACE_ID_FIELD));

    private final Map<String, ComponentRequest> components;

    private final String description;

    private final String entityId;

    private final String entityName;

    private final String parentEntityId;

    private final Map<String, String> tags;

    private final String workspaceId;

    private CreateEntityRequest(BuilderImpl builder) {
        super(builder);
        this.components = builder.components;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.parentEntityId = builder.parentEntityId;
        this.tags = builder.tags;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the components in the entity. Each string in the mapping must be unique to this
     * object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return An object that maps strings to the components in the entity. Each string in the mapping must be unique to
     *         this object.
     */
    public final Map<String, ComponentRequest> components() {
        return components;
    }

    /**
     * <p>
     * The description of the entity.
     * </p>
     * 
     * @return The description of the entity.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the entity.
     * </p>
     * 
     * @return The ID of the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * The ID of the entity's parent entity.
     * </p>
     * 
     * @return The ID of the entity's parent entity.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that you can use to manage the entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that you can use to manage the entity.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the workspace that contains the entity.
     * </p>
     * 
     * @return The ID of the workspace that contains the entity.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEntityRequest)) {
            return false;
        }
        CreateEntityRequest other = (CreateEntityRequest) obj;
        return hasComponents() == other.hasComponents() && Objects.equals(components(), other.components())
                && Objects.equals(description(), other.description()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityName(), other.entityName()) && Objects.equals(parentEntityId(), other.parentEntityId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEntityRequest").add("Components", hasComponents() ? components() : null)
                .add("Description", description()).add("EntityId", entityId()).add("EntityName", entityName())
                .add("ParentEntityId", parentEntityId()).add("Tags", hasTags() ? tags() : null).add("WorkspaceId", workspaceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEntityRequest, T> g) {
        return obj -> g.apply((CreateEntityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEntityRequest> {
        /**
         * <p>
         * An object that maps strings to the components in the entity. Each string in the mapping must be unique to
         * this object.
         * </p>
         * 
         * @param components
         *        An object that maps strings to the components in the entity. Each string in the mapping must be unique
         *        to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Map<String, ComponentRequest> components);

        /**
         * <p>
         * The description of the entity.
         * </p>
         * 
         * @param description
         *        The description of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the entity.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param entityName
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * The ID of the entity's parent entity.
         * </p>
         * 
         * @param parentEntityId
         *        The ID of the entity's parent entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);

        /**
         * <p>
         * Metadata that you can use to manage the entity.
         * </p>
         * 
         * @param tags
         *        Metadata that you can use to manage the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the workspace that contains the entity.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private Map<String, ComponentRequest> components = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private String entityId;

        private String entityName;

        private String parentEntityId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEntityRequest model) {
            super(model);
            components(model.components);
            description(model.description);
            entityId(model.entityId);
            entityName(model.entityName);
            parentEntityId(model.parentEntityId);
            tags(model.tags);
            workspaceId(model.workspaceId);
        }

        public final Map<String, ComponentRequest.Builder> getComponents() {
            Map<String, ComponentRequest.Builder> result = ComponentsMapRequestCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponents(Map<String, ComponentRequest.BuilderImpl> components) {
            this.components = ComponentsMapRequestCopier.copyFromBuilder(components);
        }

        @Override
        @Transient
        public final Builder components(Map<String, ComponentRequest> components) {
            this.components = ComponentsMapRequestCopier.copy(components);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        @Transient
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        @Transient
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEntityRequest build() {
            return new CreateEntityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
