/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class PropertyRequestsCopier {
    static Map<String, PropertyRequest> copy(Map<String, ? extends PropertyRequest> propertyRequestsParam) {
        Map<String, PropertyRequest> map;
        if (propertyRequestsParam == null || propertyRequestsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PropertyRequest> modifiableMap = new LinkedHashMap<>();
            propertyRequestsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PropertyRequest> copyFromBuilder(Map<String, ? extends PropertyRequest.Builder> propertyRequestsParam) {
        Map<String, PropertyRequest> map;
        if (propertyRequestsParam == null || propertyRequestsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PropertyRequest> modifiableMap = new LinkedHashMap<>();
            propertyRequestsParam.forEach((key, value) -> {
                PropertyRequest member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PropertyRequest.Builder> copyToBuilder(Map<String, ? extends PropertyRequest> propertyRequestsParam) {
        Map<String, PropertyRequest.Builder> map;
        if (propertyRequestsParam == null || propertyRequestsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PropertyRequest.Builder> modifiableMap = new LinkedHashMap<>();
            propertyRequestsParam.forEach((key, value) -> {
                PropertyRequest.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
