/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEntityResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetEntityResponse.Builder, GetEntityResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetEntityResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Map<String, ComponentResponse>> COMPONENTS_FIELD = SdkField
            .<Map<String, ComponentResponse>> builder(MarshallingType.MAP)
            .memberName("components")
            .getter(getter(GetEntityResponse::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GetEntityResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetEntityResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(GetEntityResponse::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityName").getter(getter(GetEntityResponse::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()).build();

    private static final SdkField<Boolean> HAS_CHILD_ENTITIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasChildEntities").getter(getter(GetEntityResponse::hasChildEntities))
            .setter(setter(Builder::hasChildEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasChildEntities").build()).build();

    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(GetEntityResponse::parentEntityId))
            .setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final SdkField<Status> STATUS_FIELD = SdkField.<Status> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(GetEntityResponse::status)).setter(setter(Builder::status)).constructor(Status::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(GetEntityResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetEntityResponse::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENTS_FIELD,
            CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_NAME_FIELD, HAS_CHILD_ENTITIES_FIELD,
            PARENT_ENTITY_ID_FIELD, STATUS_FIELD, UPDATE_DATE_TIME_FIELD, WORKSPACE_ID_FIELD));

    private final String arn;

    private final Map<String, ComponentResponse> components;

    private final Instant creationDateTime;

    private final String description;

    private final String entityId;

    private final String entityName;

    private final Boolean hasChildEntities;

    private final String parentEntityId;

    private final Status status;

    private final Instant updateDateTime;

    private final String workspaceId;

    private GetEntityResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.components = builder.components;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.hasChildEntities = builder.hasChildEntities;
        this.parentEntityId = builder.parentEntityId;
        this.status = builder.status;
        this.updateDateTime = builder.updateDateTime;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The ARN of the entity.
     * </p>
     * 
     * @return The ARN of the entity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the components in the entity. Each string in the mapping must be unique to this
     * object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return An object that maps strings to the components in the entity. Each string in the mapping must be unique to
     *         this object.
     */
    public final Map<String, ComponentResponse> components() {
        return components;
    }

    /**
     * <p>
     * The date and time when the entity was created.
     * </p>
     * 
     * @return The date and time when the entity was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The description of the entity.
     * </p>
     * 
     * @return The description of the entity.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the entity.
     * </p>
     * 
     * @return The ID of the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the entity has associated child entities.
     * </p>
     * 
     * @return A Boolean value that specifies whether the entity has associated child entities.
     */
    public final Boolean hasChildEntities() {
        return hasChildEntities;
    }

    /**
     * <p>
     * The ID of the parent entity for this entity.
     * </p>
     * 
     * @return The ID of the parent entity for this entity.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    /**
     * <p>
     * The current status of the entity.
     * </p>
     * 
     * @return The current status of the entity.
     */
    public final Status status() {
        return status;
    }

    /**
     * <p>
     * The date and time when the entity was last updated.
     * </p>
     * 
     * @return The date and time when the entity was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @return The ID of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildEntities());
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntityResponse)) {
            return false;
        }
        GetEntityResponse other = (GetEntityResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasComponents() == other.hasComponents()
                && Objects.equals(components(), other.components())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(description(), other.description()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityName(), other.entityName())
                && Objects.equals(hasChildEntities(), other.hasChildEntities())
                && Objects.equals(parentEntityId(), other.parentEntityId()) && Objects.equals(status(), other.status())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEntityResponse").add("Arn", arn()).add("Components", hasComponents() ? components() : null)
                .add("CreationDateTime", creationDateTime()).add("Description", description()).add("EntityId", entityId())
                .add("EntityName", entityName()).add("HasChildEntities", hasChildEntities())
                .add("ParentEntityId", parentEntityId()).add("Status", status()).add("UpdateDateTime", updateDateTime())
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "hasChildEntities":
            return Optional.ofNullable(clazz.cast(hasChildEntities()));
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntityResponse, T> g) {
        return obj -> g.apply((GetEntityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEntityResponse> {
        /**
         * <p>
         * The ARN of the entity.
         * </p>
         * 
         * @param arn
         *        The ARN of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An object that maps strings to the components in the entity. Each string in the mapping must be unique to
         * this object.
         * </p>
         * 
         * @param components
         *        An object that maps strings to the components in the entity. Each string in the mapping must be unique
         *        to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Map<String, ComponentResponse> components);

        /**
         * <p>
         * The date and time when the entity was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the entity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The description of the entity.
         * </p>
         * 
         * @param description
         *        The description of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the entity.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param entityName
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * A Boolean value that specifies whether the entity has associated child entities.
         * </p>
         * 
         * @param hasChildEntities
         *        A Boolean value that specifies whether the entity has associated child entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasChildEntities(Boolean hasChildEntities);

        /**
         * <p>
         * The ID of the parent entity for this entity.
         * </p>
         * 
         * @param parentEntityId
         *        The ID of the parent entity for this entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);

        /**
         * <p>
         * The current status of the entity.
         * </p>
         * 
         * @param status
         *        The current status of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Status status);

        /**
         * <p>
         * The current status of the entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link Status.Builder} avoiding the need to
         * create one manually via {@link Status#builder()}.
         *
         * When the {@link Consumer} completes, {@link Status.Builder#build()} is called immediately and its result is
         * passed to {@link #status(Status)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link Status.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(Status)
         */
        default Builder status(Consumer<Status.Builder> status) {
            return status(Status.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The date and time when the entity was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the entity was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The ID of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private Map<String, ComponentResponse> components = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationDateTime;

        private String description;

        private String entityId;

        private String entityName;

        private Boolean hasChildEntities;

        private String parentEntityId;

        private Status status;

        private Instant updateDateTime;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntityResponse model) {
            super(model);
            arn(model.arn);
            components(model.components);
            creationDateTime(model.creationDateTime);
            description(model.description);
            entityId(model.entityId);
            entityName(model.entityName);
            hasChildEntities(model.hasChildEntities);
            parentEntityId(model.parentEntityId);
            status(model.status);
            updateDateTime(model.updateDateTime);
            workspaceId(model.workspaceId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, ComponentResponse.Builder> getComponents() {
            Map<String, ComponentResponse.Builder> result = ComponentsMapCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponents(Map<String, ComponentResponse.BuilderImpl> components) {
            this.components = ComponentsMapCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Map<String, ComponentResponse> components) {
            this.components = ComponentsMapCopier.copy(components);
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final Boolean getHasChildEntities() {
            return hasChildEntities;
        }

        public final void setHasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
        }

        @Override
        public final Builder hasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
            return this;
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final Status.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public GetEntityResponse build() {
            return new GetEntityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
