/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataConnector implements SdkPojo, Serializable, ToCopyableBuilder<DataConnector.Builder, DataConnector> {
    private static final SdkField<Boolean> IS_NATIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isNative").getter(getter(DataConnector::isNative)).setter(setter(Builder::isNative))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNative").build()).build();

    private static final SdkField<LambdaFunction> LAMBDA_FIELD = SdkField.<LambdaFunction> builder(MarshallingType.SDK_POJO)
            .memberName("lambda").getter(getter(DataConnector::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IS_NATIVE_FIELD, LAMBDA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isNative;

    private final LambdaFunction lambda;

    private DataConnector(BuilderImpl builder) {
        this.isNative = builder.isNative;
        this.lambda = builder.lambda;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the data connector is native to IoT TwinMaker.
     * </p>
     * 
     * @return A Boolean value that specifies whether the data connector is native to IoT TwinMaker.
     */
    public final Boolean isNative() {
        return isNative;
    }

    /**
     * <p>
     * The Lambda function associated with this data connector.
     * </p>
     * 
     * @return The Lambda function associated with this data connector.
     */
    public final LambdaFunction lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isNative());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataConnector)) {
            return false;
        }
        DataConnector other = (DataConnector) obj;
        return Objects.equals(isNative(), other.isNative()) && Objects.equals(lambda(), other.lambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataConnector").add("IsNative", isNative()).add("Lambda", lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isNative":
            return Optional.ofNullable(clazz.cast(isNative()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataConnector, T> g) {
        return obj -> g.apply((DataConnector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataConnector> {
        /**
         * <p>
         * A Boolean value that specifies whether the data connector is native to IoT TwinMaker.
         * </p>
         * 
         * @param isNative
         *        A Boolean value that specifies whether the data connector is native to IoT TwinMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNative(Boolean isNative);

        /**
         * <p>
         * The Lambda function associated with this data connector.
         * </p>
         * 
         * @param lambda
         *        The Lambda function associated with this data connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaFunction lambda);

        /**
         * <p>
         * The Lambda function associated with this data connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaFunction.Builder} avoiding the need
         * to create one manually via {@link LambdaFunction#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambda(LambdaFunction)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaFunction)
         */
        default Builder lambda(Consumer<LambdaFunction.Builder> lambda) {
            return lambda(LambdaFunction.builder().applyMutation(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isNative;

        private LambdaFunction lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(DataConnector model) {
            isNative(model.isNative);
            lambda(model.lambda);
        }

        public final Boolean getIsNative() {
            return isNative;
        }

        public final void setIsNative(Boolean isNative) {
            this.isNative = isNative;
        }

        @Override
        public final Builder isNative(Boolean isNative) {
            this.isNative = isNative;
            return this;
        }

        public final LambdaFunction.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaFunction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaFunction lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public DataConnector build() {
            return new DataConnector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
