/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentTypesResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<ListComponentTypesResponse.Builder, ListComponentTypesResponse> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(ListComponentTypesResponse::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final SdkField<List<ComponentTypeSummary>> COMPONENT_TYPE_SUMMARIES_FIELD = SdkField
            .<List<ComponentTypeSummary>> builder(MarshallingType.LIST)
            .memberName("componentTypeSummaries")
            .getter(getter(ListComponentTypesResponse::componentTypeSummaries))
            .setter(setter(Builder::componentTypeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentTypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentTypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComponentTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListComponentTypesResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            COMPONENT_TYPE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String workspaceId;

    private final List<ComponentTypeSummary> componentTypeSummaries;

    private final String nextToken;

    private final Integer maxResults;

    private ListComponentTypesResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.componentTypeSummaries = builder.componentTypeSummaries;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @return The ID of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentTypeSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComponentTypeSummaries() {
        return componentTypeSummaries != null && !(componentTypeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain information about the component types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentTypeSummaries} method.
     * </p>
     * 
     * @return A list of objects that contain information about the component types.
     */
    public final List<ComponentTypeSummary> componentTypeSummaries() {
        return componentTypeSummaries;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of results to display.
     * </p>
     * 
     * @return Specifies the maximum number of results to display.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentTypeSummaries() ? componentTypeSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentTypesResponse)) {
            return false;
        }
        ListComponentTypesResponse other = (ListComponentTypesResponse) obj;
        return Objects.equals(workspaceId(), other.workspaceId())
                && hasComponentTypeSummaries() == other.hasComponentTypeSummaries()
                && Objects.equals(componentTypeSummaries(), other.componentTypeSummaries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentTypesResponse").add("WorkspaceId", workspaceId())
                .add("ComponentTypeSummaries", hasComponentTypeSummaries() ? componentTypeSummaries() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "componentTypeSummaries":
            return Optional.ofNullable(clazz.cast(componentTypeSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentTypesResponse, T> g) {
        return obj -> g.apply((ListComponentTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListComponentTypesResponse> {
        /**
         * <p>
         * The ID of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * A list of objects that contain information about the component types.
         * </p>
         * 
         * @param componentTypeSummaries
         *        A list of objects that contain information about the component types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeSummaries(Collection<ComponentTypeSummary> componentTypeSummaries);

        /**
         * <p>
         * A list of objects that contain information about the component types.
         * </p>
         * 
         * @param componentTypeSummaries
         *        A list of objects that contain information about the component types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeSummaries(ComponentTypeSummary... componentTypeSummaries);

        /**
         * <p>
         * A list of objects that contain information about the component types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #componentTypeSummaries(List<ComponentTypeSummary>)}.
         * 
         * @param componentTypeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentTypeSummaries(java.util.Collection<ComponentTypeSummary>)
         */
        Builder componentTypeSummaries(Consumer<ComponentTypeSummary.Builder>... componentTypeSummaries);

        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of results to display.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of results to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String workspaceId;

        private List<ComponentTypeSummary> componentTypeSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentTypesResponse model) {
            super(model);
            workspaceId(model.workspaceId);
            componentTypeSummaries(model.componentTypeSummaries);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final List<ComponentTypeSummary.Builder> getComponentTypeSummaries() {
            List<ComponentTypeSummary.Builder> result = ComponentTypeSummariesCopier.copyToBuilder(this.componentTypeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentTypeSummaries(Collection<ComponentTypeSummary.BuilderImpl> componentTypeSummaries) {
            this.componentTypeSummaries = ComponentTypeSummariesCopier.copyFromBuilder(componentTypeSummaries);
        }

        @Override
        public final Builder componentTypeSummaries(Collection<ComponentTypeSummary> componentTypeSummaries) {
            this.componentTypeSummaries = ComponentTypeSummariesCopier.copy(componentTypeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentTypeSummaries(ComponentTypeSummary... componentTypeSummaries) {
            componentTypeSummaries(Arrays.asList(componentTypeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentTypeSummaries(Consumer<ComponentTypeSummary.Builder>... componentTypeSummaries) {
            componentTypeSummaries(Stream.of(componentTypeSummaries)
                    .map(c -> ComponentTypeSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public ListComponentTypesResponse build() {
            return new ListComponentTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
