/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iottwinmaker.model.AccessDeniedException;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ConflictException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorFailureException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.InternalServerException;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerException;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.QueryTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iottwinmaker.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ThrottlingException;
import software.amazon.awssdk.services.iottwinmaker.model.TooManyTagsException;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ValidationException;
import software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable;

/**
 * Service client for accessing AWS IoT TwinMaker. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * IoT TwinMaker is a service that enables you to build operational digital twins of physical systems. IoT TwinMaker
 * overlays measurements and analysis from real-world sensors, cameras, and enterprise applications so you can create
 * data visualizations to monitor your physical factory, building, or industrial plant. You can use this real-world data
 * to monitor operations and diagnose and repair errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTTwinMakerClient extends SdkClient {
    String SERVICE_NAME = "iottwinmaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iottwinmaker";

    /**
     * <p>
     * Sets values for multiple time series properties.
     * </p>
     *
     * @param batchPutPropertyValuesRequest
     * @return Result of the BatchPutPropertyValues operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.BatchPutPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutPropertyValuesResponse batchPutPropertyValues(BatchPutPropertyValuesRequest batchPutPropertyValuesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets values for multiple time series properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutPropertyValuesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchPutPropertyValuesRequest#builder()}
     * </p>
     *
     * @param batchPutPropertyValuesRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutPropertyValuesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchPutPropertyValues operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.BatchPutPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutPropertyValuesResponse batchPutPropertyValues(
            Consumer<BatchPutPropertyValuesRequest.Builder> batchPutPropertyValuesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return batchPutPropertyValues(BatchPutPropertyValuesRequest.builder().applyMutation(batchPutPropertyValuesRequest)
                .build());
    }

    /**
     * <p>
     * Creates a component type.
     * </p>
     *
     * @param createComponentTypeRequest
     * @return Result of the CreateComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentTypeResponse createComponentType(CreateComponentTypeRequest createComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentTypeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateComponentTypeRequest#builder()}
     * </p>
     *
     * @param createComponentTypeRequest
     *        A {@link Consumer} that will call methods on {@link CreateComponentTypeRequest.Builder} to create a
     *        request.
     * @return Result of the CreateComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentTypeResponse createComponentType(
            Consumer<CreateComponentTypeRequest.Builder> createComponentTypeRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        return createComponentType(CreateComponentTypeRequest.builder().applyMutation(createComponentTypeRequest).build());
    }

    /**
     * <p>
     * Creates an entity.
     * </p>
     *
     * @param createEntityRequest
     * @return Result of the CreateEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEntityResponse createEntity(CreateEntityRequest createEntityRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEntityRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEntityRequest#builder()}
     * </p>
     *
     * @param createEntityRequest
     *        A {@link Consumer} that will call methods on {@link CreateEntityRequest.Builder} to create a request.
     * @return Result of the CreateEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEntityResponse createEntity(Consumer<CreateEntityRequest.Builder> createEntityRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return createEntity(CreateEntityRequest.builder().applyMutation(createEntityRequest).build());
    }

    /**
     * <p>
     * Creates a scene.
     * </p>
     *
     * @param createSceneRequest
     * @return Result of the CreateScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSceneResponse createScene(CreateSceneRequest createSceneRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSceneRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSceneRequest#builder()}
     * </p>
     *
     * @param createSceneRequest
     *        A {@link Consumer} that will call methods on {@link CreateSceneRequest.Builder} to create a request.
     * @return Result of the CreateScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSceneResponse createScene(Consumer<CreateSceneRequest.Builder> createSceneRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return createScene(CreateSceneRequest.builder().applyMutation(createSceneRequest).build());
    }

    /**
     * <p>
     * This action creates a SyncJob.
     * </p>
     *
     * @param createSyncJobRequest
     * @return Result of the CreateSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSyncJobResponse createSyncJob(CreateSyncJobRequest createSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action creates a SyncJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSyncJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSyncJobRequest#builder()}
     * </p>
     *
     * @param createSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateSyncJobRequest.Builder} to create a request.
     * @return Result of the CreateSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSyncJobResponse createSyncJob(Consumer<CreateSyncJobRequest.Builder> createSyncJobRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return createSyncJob(CreateSyncJobRequest.builder().applyMutation(createSyncJobRequest).build());
    }

    /**
     * <p>
     * Creates a workplace.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return Result of the CreateWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest createWorkspaceRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspaceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkspaceRequest.Builder} to create a request.
     * @return Result of the CreateWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorkspaceResponse createWorkspace(Consumer<CreateWorkspaceRequest.Builder> createWorkspaceRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return createWorkspace(CreateWorkspaceRequest.builder().applyMutation(createWorkspaceRequest).build());
    }

    /**
     * <p>
     * Deletes a component type.
     * </p>
     *
     * @param deleteComponentTypeRequest
     * @return Result of the DeleteComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentTypeResponse deleteComponentType(DeleteComponentTypeRequest deleteComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteComponentTypeRequest#builder()}
     * </p>
     *
     * @param deleteComponentTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteComponentTypeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentTypeResponse deleteComponentType(
            Consumer<DeleteComponentTypeRequest.Builder> deleteComponentTypeRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return deleteComponentType(DeleteComponentTypeRequest.builder().applyMutation(deleteComponentTypeRequest).build());
    }

    /**
     * <p>
     * Deletes an entity.
     * </p>
     *
     * @param deleteEntityRequest
     * @return Result of the DeleteEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEntityResponse deleteEntity(DeleteEntityRequest deleteEntityRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEntityRequest#builder()}
     * </p>
     *
     * @param deleteEntityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEntityRequest.Builder} to create a request.
     * @return Result of the DeleteEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEntityResponse deleteEntity(Consumer<DeleteEntityRequest.Builder> deleteEntityRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return deleteEntity(DeleteEntityRequest.builder().applyMutation(deleteEntityRequest).build());
    }

    /**
     * <p>
     * Deletes a scene.
     * </p>
     *
     * @param deleteSceneRequest
     * @return Result of the DeleteScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSceneResponse deleteScene(DeleteSceneRequest deleteSceneRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSceneRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSceneRequest#builder()}
     * </p>
     *
     * @param deleteSceneRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSceneRequest.Builder} to create a request.
     * @return Result of the DeleteScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSceneResponse deleteScene(Consumer<DeleteSceneRequest.Builder> deleteSceneRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return deleteScene(DeleteSceneRequest.builder().applyMutation(deleteSceneRequest).build());
    }

    /**
     * <p>
     * Delete the SyncJob.
     * </p>
     *
     * @param deleteSyncJobRequest
     * @return Result of the DeleteSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSyncJobResponse deleteSyncJob(DeleteSyncJobRequest deleteSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the SyncJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSyncJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSyncJobRequest#builder()}
     * </p>
     *
     * @param deleteSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSyncJobRequest.Builder} to create a request.
     * @return Result of the DeleteSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSyncJobResponse deleteSyncJob(Consumer<DeleteSyncJobRequest.Builder> deleteSyncJobRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return deleteSyncJob(DeleteSyncJobRequest.builder().applyMutation(deleteSyncJobRequest).build());
    }

    /**
     * <p>
     * Deletes a workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return Result of the DeleteWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWorkspaceResponse deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkspaceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkspaceRequest.Builder} to create a request.
     * @return Result of the DeleteWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWorkspaceResponse deleteWorkspace(Consumer<DeleteWorkspaceRequest.Builder> deleteWorkspaceRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return deleteWorkspace(DeleteWorkspaceRequest.builder().applyMutation(deleteWorkspaceRequest).build());
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     *
     * @param executeQueryRequest
     * @return Result of the ExecuteQuery operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws QueryTimeoutException
     *         The query timeout exception.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryResponse executeQuery(ExecuteQueryRequest executeQueryRequest) throws InternalServerException,
            AccessDeniedException, QueryTimeoutException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteQueryRequest.Builder} to create a request.
     * @return Result of the ExecuteQuery operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws QueryTimeoutException
     *         The query timeout exception.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryResponse executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest)
            throws InternalServerException, AccessDeniedException, QueryTimeoutException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return executeQuery(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable responses = client.executeQueryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable responses = client
     *             .executeQueryPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable responses = client.executeQueryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation.</b>
     * </p>
     *
     * @param executeQueryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws QueryTimeoutException
     *         The query timeout exception.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryIterable executeQueryPaginator(ExecuteQueryRequest executeQueryRequest) throws InternalServerException,
            AccessDeniedException, QueryTimeoutException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable responses = client.executeQueryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable responses = client
     *             .executeQueryPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable responses = client.executeQueryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteQueryRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws QueryTimeoutException
     *         The query timeout exception.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryIterable executeQueryPaginator(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest)
            throws InternalServerException, AccessDeniedException, QueryTimeoutException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return executeQueryPaginator(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a component type.
     * </p>
     *
     * @param getComponentTypeRequest
     * @return Result of the GetComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComponentTypeResponse getComponentType(GetComponentTypeRequest getComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentTypeRequest.Builder} avoiding the need
     * to create one manually via {@link GetComponentTypeRequest#builder()}
     * </p>
     *
     * @param getComponentTypeRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentTypeRequest.Builder} to create a request.
     * @return Result of the GetComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComponentTypeResponse getComponentType(Consumer<GetComponentTypeRequest.Builder> getComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return getComponentType(GetComponentTypeRequest.builder().applyMutation(getComponentTypeRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an entity.
     * </p>
     *
     * @param getEntityRequest
     * @return Result of the GetEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEntityResponse getEntity(GetEntityRequest getEntityRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntityRequest#builder()}
     * </p>
     *
     * @param getEntityRequest
     *        A {@link Consumer} that will call methods on {@link GetEntityRequest.Builder} to create a request.
     * @return Result of the GetEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEntityResponse getEntity(Consumer<GetEntityRequest.Builder> getEntityRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        return getEntity(GetEntityRequest.builder().applyMutation(getEntityRequest).build());
    }

    /**
     * <p>
     * Gets the pricing plan.
     * </p>
     *
     * @param getPricingPlanRequest
     * @return Result of the GetPricingPlan operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPricingPlanResponse getPricingPlan(GetPricingPlanRequest getPricingPlanRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPricingPlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetPricingPlanRequest#builder()}
     * </p>
     *
     * @param getPricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link GetPricingPlanRequest.Builder} to create a request.
     * @return Result of the GetPricingPlan operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPricingPlanResponse getPricingPlan(Consumer<GetPricingPlanRequest.Builder> getPricingPlanRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return getPricingPlan(GetPricingPlanRequest.builder().applyMutation(getPricingPlanRequest).build());
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     *
     * @param getPropertyValueRequest
     * @return Result of the GetPropertyValue operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPropertyValueResponse getPropertyValue(GetPropertyValueRequest getPropertyValueRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueRequest.Builder} avoiding the need
     * to create one manually via {@link GetPropertyValueRequest#builder()}
     * </p>
     *
     * @param getPropertyValueRequest
     *        A {@link Consumer} that will call methods on {@link GetPropertyValueRequest.Builder} to create a request.
     * @return Result of the GetPropertyValue operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPropertyValueResponse getPropertyValue(Consumer<GetPropertyValueRequest.Builder> getPropertyValueRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return getPropertyValue(GetPropertyValueRequest.builder().applyMutation(getPropertyValueRequest).build());
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable responses = client.getPropertyValuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable responses = client
     *             .getPropertyValuePaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable responses = client.getPropertyValuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPropertyValueRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPropertyValueIterable getPropertyValuePaginator(GetPropertyValueRequest getPropertyValueRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable responses = client.getPropertyValuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable responses = client
     *             .getPropertyValuePaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable responses = client.getPropertyValuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueRequest.Builder} avoiding the need
     * to create one manually via {@link GetPropertyValueRequest#builder()}
     * </p>
     *
     * @param getPropertyValueRequest
     *        A {@link Consumer} that will call methods on {@link GetPropertyValueRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPropertyValueIterable getPropertyValuePaginator(Consumer<GetPropertyValueRequest.Builder> getPropertyValueRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return getPropertyValuePaginator(GetPropertyValueRequest.builder().applyMutation(getPropertyValueRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     * @return Result of the GetPropertyValueHistory operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertyValueHistoryResponse getPropertyValueHistory(GetPropertyValueHistoryRequest getPropertyValueHistoryRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetPropertyValueHistoryRequest.Builder} to create a
     *        request.
     * @return Result of the GetPropertyValueHistory operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertyValueHistoryResponse getPropertyValueHistory(
            Consumer<GetPropertyValueHistoryRequest.Builder> getPropertyValueHistoryRequest) throws InternalServerException,
            ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return getPropertyValueHistory(GetPropertyValueHistoryRequest.builder().applyMutation(getPropertyValueHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable responses = client.getPropertyValueHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable responses = client
     *             .getPropertyValueHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable responses = client.getPropertyValueHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertyValueHistoryIterable getPropertyValueHistoryPaginator(
            GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) throws InternalServerException,
            ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable responses = client.getPropertyValueHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable responses = client
     *             .getPropertyValueHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable responses = client.getPropertyValueHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetPropertyValueHistoryRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertyValueHistoryIterable getPropertyValueHistoryPaginator(
            Consumer<GetPropertyValueHistoryRequest.Builder> getPropertyValueHistoryRequest) throws InternalServerException,
            ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return getPropertyValueHistoryPaginator(GetPropertyValueHistoryRequest.builder()
                .applyMutation(getPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a scene.
     * </p>
     *
     * @param getSceneRequest
     * @return Result of the GetScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSceneResponse getScene(GetSceneRequest getSceneRequest) throws InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSceneRequest.Builder} avoiding the need to
     * create one manually via {@link GetSceneRequest#builder()}
     * </p>
     *
     * @param getSceneRequest
     *        A {@link Consumer} that will call methods on {@link GetSceneRequest.Builder} to create a request.
     * @return Result of the GetScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSceneResponse getScene(Consumer<GetSceneRequest.Builder> getSceneRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return getScene(GetSceneRequest.builder().applyMutation(getSceneRequest).build());
    }

    /**
     * <p>
     * Gets the SyncJob.
     * </p>
     *
     * @param getSyncJobRequest
     * @return Result of the GetSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSyncJobResponse getSyncJob(GetSyncJobRequest getSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the SyncJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSyncJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetSyncJobRequest#builder()}
     * </p>
     *
     * @param getSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link GetSyncJobRequest.Builder} to create a request.
     * @return Result of the GetSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSyncJobResponse getSyncJob(Consumer<GetSyncJobRequest.Builder> getSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return getSyncJob(GetSyncJobRequest.builder().applyMutation(getSyncJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a workspace.
     * </p>
     *
     * @param getWorkspaceRequest
     * @return Result of the GetWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkspaceResponse getWorkspace(GetWorkspaceRequest getWorkspaceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkspaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkspaceRequest#builder()}
     * </p>
     *
     * @param getWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkspaceRequest.Builder} to create a request.
     * @return Result of the GetWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkspaceResponse getWorkspace(Consumer<GetWorkspaceRequest.Builder> getWorkspaceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return getWorkspace(GetWorkspaceRequest.builder().applyMutation(getWorkspaceRequest).build());
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     *
     * @param listComponentTypesRequest
     * @return Result of the ListComponentTypes operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentTypesResponse listComponentTypes(ListComponentTypesRequest listComponentTypesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentTypesRequest#builder()}
     * </p>
     *
     * @param listComponentTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentTypesRequest.Builder} to create a
     *        request.
     * @return Result of the ListComponentTypes operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentTypesResponse listComponentTypes(Consumer<ListComponentTypesRequest.Builder> listComponentTypesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return listComponentTypes(ListComponentTypesRequest.builder().applyMutation(listComponentTypesRequest).build());
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable responses = client.listComponentTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable responses = client
     *             .listComponentTypesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable responses = client.listComponentTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentTypesIterable listComponentTypesPaginator(ListComponentTypesRequest listComponentTypesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable responses = client.listComponentTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable responses = client
     *             .listComponentTypesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable responses = client.listComponentTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentTypesRequest#builder()}
     * </p>
     *
     * @param listComponentTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentTypesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentTypesIterable listComponentTypesPaginator(
            Consumer<ListComponentTypesRequest.Builder> listComponentTypesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return listComponentTypesPaginator(ListComponentTypesRequest.builder().applyMutation(listComponentTypesRequest).build());
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     *
     * @param listEntitiesRequest
     * @return Result of the ListEntities operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesResponse listEntities(ListEntitiesRequest listEntitiesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesRequest.Builder} to create a request.
     * @return Result of the ListEntities operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesResponse listEntities(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listEntities(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable responses = client
     *             .listEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation.</b>
     * </p>
     *
     * @param listEntitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesIterable listEntitiesPaginator(ListEntitiesRequest listEntitiesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable responses = client
     *             .listEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable responses = client.listEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesIterable listEntitiesPaginator(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listEntitiesPaginator(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     *
     * @param listScenesRequest
     * @return Result of the ListScenes operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScenesResponse listScenes(ListScenesRequest listScenesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScenesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScenesRequest#builder()}
     * </p>
     *
     * @param listScenesRequest
     *        A {@link Consumer} that will call methods on {@link ListScenesRequest.Builder} to create a request.
     * @return Result of the ListScenes operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScenesResponse listScenes(Consumer<ListScenesRequest.Builder> listScenesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return listScenes(ListScenesRequest.builder().applyMutation(listScenesRequest).build());
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable responses = client.listScenesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable responses = client.listScenesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable responses = client.listScenesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)} operation.</b>
     * </p>
     *
     * @param listScenesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScenesIterable listScenesPaginator(ListScenesRequest listScenesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable responses = client.listScenesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable responses = client.listScenesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable responses = client.listScenesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScenesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScenesRequest#builder()}
     * </p>
     *
     * @param listScenesRequest
     *        A {@link Consumer} that will call methods on {@link ListScenesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScenesIterable listScenesPaginator(Consumer<ListScenesRequest.Builder> listScenesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return listScenesPaginator(ListScenesRequest.builder().applyMutation(listScenesRequest).build());
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     *
     * @param listSyncJobsRequest
     * @return Result of the ListSyncJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSyncJobsResponse listSyncJobs(ListSyncJobsRequest listSyncJobsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSyncJobsRequest#builder()}
     * </p>
     *
     * @param listSyncJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSyncJobsRequest.Builder} to create a request.
     * @return Result of the ListSyncJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSyncJobsResponse listSyncJobs(Consumer<ListSyncJobsRequest.Builder> listSyncJobsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listSyncJobs(ListSyncJobsRequest.builder().applyMutation(listSyncJobsRequest).build());
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable responses = client.listSyncJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable responses = client
     *             .listSyncJobsPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable responses = client.listSyncJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation.</b>
     * </p>
     *
     * @param listSyncJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSyncJobsIterable listSyncJobsPaginator(ListSyncJobsRequest listSyncJobsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable responses = client.listSyncJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable responses = client
     *             .listSyncJobsPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable responses = client.listSyncJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSyncJobsRequest#builder()}
     * </p>
     *
     * @param listSyncJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSyncJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSyncJobsIterable listSyncJobsPaginator(Consumer<ListSyncJobsRequest.Builder> listSyncJobsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listSyncJobsPaginator(ListSyncJobsRequest.builder().applyMutation(listSyncJobsRequest).build());
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     *
     * @param listSyncResourcesRequest
     * @return Result of the ListSyncResources operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncResourcesResponse listSyncResources(ListSyncResourcesRequest listSyncResourcesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListSyncResourcesRequest#builder()}
     * </p>
     *
     * @param listSyncResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListSyncResourcesRequest.Builder} to create a request.
     * @return Result of the ListSyncResources operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncResourcesResponse listSyncResources(Consumer<ListSyncResourcesRequest.Builder> listSyncResourcesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listSyncResources(ListSyncResourcesRequest.builder().applyMutation(listSyncResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable responses = client.listSyncResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable responses = client
     *             .listSyncResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable responses = client.listSyncResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSyncResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncResourcesIterable listSyncResourcesPaginator(ListSyncResourcesRequest listSyncResourcesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable responses = client.listSyncResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable responses = client
     *             .listSyncResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable responses = client.listSyncResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListSyncResourcesRequest#builder()}
     * </p>
     *
     * @param listSyncResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListSyncResourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncResourcesIterable listSyncResourcesPaginator(
            Consumer<ListSyncResourcesRequest.Builder> listSyncResourcesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return listSyncResourcesPaginator(ListSyncResourcesRequest.builder().applyMutation(listSyncResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     *
     * @param listWorkspacesRequest
     * @return Result of the ListWorkspaces operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkspacesResponse listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkspacesRequest.Builder} to create a request.
     * @return Result of the ListWorkspaces operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkspacesResponse listWorkspaces(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listWorkspaces(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable responses = client
     *             .listWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkspacesIterable listWorkspacesPaginator(ListWorkspacesRequest listWorkspacesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable responses = client
     *             .listWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkspacesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkspacesIterable listWorkspacesPaginator(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        return listWorkspacesPaginator(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     *         The number of tags exceeds the limit.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     *         The number of tags exceeds the limit.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws TooManyTagsException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates information in a component type.
     * </p>
     *
     * @param updateComponentTypeRequest
     * @return Result of the UpdateComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentTypeResponse updateComponentType(UpdateComponentTypeRequest updateComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information in a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentTypeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateComponentTypeRequest#builder()}
     * </p>
     *
     * @param updateComponentTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateComponentTypeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentTypeResponse updateComponentType(
            Consumer<UpdateComponentTypeRequest.Builder> updateComponentTypeRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return updateComponentType(UpdateComponentTypeRequest.builder().applyMutation(updateComponentTypeRequest).build());
    }

    /**
     * <p>
     * Updates an entity.
     * </p>
     *
     * @param updateEntityRequest
     * @return Result of the UpdateEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEntityResponse updateEntity(UpdateEntityRequest updateEntityRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEntityRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEntityRequest#builder()}
     * </p>
     *
     * @param updateEntityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEntityRequest.Builder} to create a request.
     * @return Result of the UpdateEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEntityResponse updateEntity(Consumer<UpdateEntityRequest.Builder> updateEntityRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        return updateEntity(UpdateEntityRequest.builder().applyMutation(updateEntityRequest).build());
    }

    /**
     * <p>
     * Update the pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return Result of the UpdatePricingPlan operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePricingPlanResponse updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePricingPlanRequest#builder()}
     * </p>
     *
     * @param updatePricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePricingPlanRequest.Builder} to create a request.
     * @return Result of the UpdatePricingPlan operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePricingPlanResponse updatePricingPlan(Consumer<UpdatePricingPlanRequest.Builder> updatePricingPlanRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        return updatePricingPlan(UpdatePricingPlanRequest.builder().applyMutation(updatePricingPlanRequest).build());
    }

    /**
     * <p>
     * Updates a scene.
     * </p>
     *
     * @param updateSceneRequest
     * @return Result of the UpdateScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSceneResponse updateScene(UpdateSceneRequest updateSceneRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSceneRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSceneRequest#builder()}
     * </p>
     *
     * @param updateSceneRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSceneRequest.Builder} to create a request.
     * @return Result of the UpdateScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSceneResponse updateScene(Consumer<UpdateSceneRequest.Builder> updateSceneRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return updateScene(UpdateSceneRequest.builder().applyMutation(updateSceneRequest).build());
    }

    /**
     * <p>
     * Updates a workspace.
     * </p>
     *
     * @param updateWorkspaceRequest
     * @return Result of the UpdateWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWorkspaceResponse updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkspaceRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkspaceRequest.Builder} to create a request.
     * @return Result of the UpdateWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWorkspaceResponse updateWorkspace(Consumer<UpdateWorkspaceRequest.Builder> updateWorkspaceRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return updateWorkspace(UpdateWorkspaceRequest.builder().applyMutation(updateWorkspaceRequest).build());
    }

    /**
     * Create a {@link IoTTwinMakerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTTwinMakerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTTwinMakerClient}.
     */
    static IoTTwinMakerClientBuilder builder() {
        return new DefaultIoTTwinMakerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
