/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSyncJobResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetSyncJobResponse.Builder, GetSyncJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSyncJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetSyncJobResponse::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSource").getter(getter(GetSyncJobResponse::syncSource)).setter(setter(Builder::syncSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()).build();

    private static final SdkField<String> SYNC_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncRole").getter(getter(GetSyncJobResponse::syncRole)).setter(setter(Builder::syncRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncRole").build()).build();

    private static final SdkField<SyncJobStatus> STATUS_FIELD = SdkField.<SyncJobStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(GetSyncJobResponse::status)).setter(setter(Builder::status))
            .constructor(SyncJobStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GetSyncJobResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(GetSyncJobResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WORKSPACE_ID_FIELD,
            SYNC_SOURCE_FIELD, SYNC_ROLE_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD));

    private final String arn;

    private final String workspaceId;

    private final String syncSource;

    private final String syncRole;

    private final SyncJobStatus status;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private GetSyncJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.workspaceId = builder.workspaceId;
        this.syncSource = builder.syncSource;
        this.syncRole = builder.syncRole;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
    }

    /**
     * <p>
     * The sync job ARN.
     * </p>
     * 
     * @return The sync job ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the workspace that contains the sync job.
     * </p>
     * 
     * @return The ID of the workspace that contains the sync job.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The sync soucre.
     * </p>
     * <note>
     * <p>
     * Currently the only supported syncSoucre is <code>SITEWISE </code>.
     * </p>
     * </note>
     * 
     * @return The sync soucre.</p> <note>
     *         <p>
     *         Currently the only supported syncSoucre is <code>SITEWISE </code>.
     *         </p>
     */
    public final String syncSource() {
        return syncSource;
    }

    /**
     * <p>
     * The sync IAM role.
     * </p>
     * 
     * @return The sync IAM role.
     */
    public final String syncRole() {
        return syncRole;
    }

    /**
     * <p>
     * The SyncJob response status.
     * </p>
     * 
     * @return The SyncJob response status.
     */
    public final SyncJobStatus status() {
        return status;
    }

    /**
     * <p>
     * The creation date and time.
     * </p>
     * 
     * @return The creation date and time.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The update date and time.
     * </p>
     * 
     * @return The update date and time.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(syncRole());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSyncJobResponse)) {
            return false;
        }
        GetSyncJobResponse other = (GetSyncJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(syncSource(), other.syncSource()) && Objects.equals(syncRole(), other.syncRole())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSyncJobResponse").add("Arn", arn()).add("WorkspaceId", workspaceId())
                .add("SyncSource", syncSource()).add("SyncRole", syncRole()).add("Status", status())
                .add("CreationDateTime", creationDateTime()).add("UpdateDateTime", updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "syncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        case "syncRole":
            return Optional.ofNullable(clazz.cast(syncRole()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSyncJobResponse, T> g) {
        return obj -> g.apply((GetSyncJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSyncJobResponse> {
        /**
         * <p>
         * The sync job ARN.
         * </p>
         * 
         * @param arn
         *        The sync job ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the workspace that contains the sync job.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the sync job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The sync soucre.
         * </p>
         * <note>
         * <p>
         * Currently the only supported syncSoucre is <code>SITEWISE </code>.
         * </p>
         * </note>
         * 
         * @param syncSource
         *        The sync soucre.</p> <note>
         *        <p>
         *        Currently the only supported syncSoucre is <code>SITEWISE </code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(String syncSource);

        /**
         * <p>
         * The sync IAM role.
         * </p>
         * 
         * @param syncRole
         *        The sync IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncRole(String syncRole);

        /**
         * <p>
         * The SyncJob response status.
         * </p>
         * 
         * @param status
         *        The SyncJob response status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SyncJobStatus status);

        /**
         * <p>
         * The SyncJob response status.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncJobStatus.Builder} avoiding the need
         * to create one manually via {@link SyncJobStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncJobStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SyncJobStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SyncJobStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SyncJobStatus)
         */
        default Builder status(Consumer<SyncJobStatus.Builder> status) {
            return status(SyncJobStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The creation date and time.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The update date and time.
         * </p>
         * 
         * @param updateDateTime
         *        The update date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String workspaceId;

        private String syncSource;

        private String syncRole;

        private SyncJobStatus status;

        private Instant creationDateTime;

        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSyncJobResponse model) {
            super(model);
            arn(model.arn);
            workspaceId(model.workspaceId);
            syncSource(model.syncSource);
            syncRole(model.syncRole);
            status(model.status);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSyncSource() {
            return syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getSyncRole() {
            return syncRole;
        }

        public final void setSyncRole(String syncRole) {
            this.syncRole = syncRole;
        }

        @Override
        public final Builder syncRole(String syncRole) {
            this.syncRole = syncRole;
            return this;
        }

        public final SyncJobStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SyncJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SyncJobStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public GetSyncJobResponse build() {
            return new GetSyncJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
