/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sync resource summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SyncResourceSummary.Builder, SyncResourceSummary> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(SyncResourceSummary::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(SyncResourceSummary::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(SyncResourceSummary::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<SyncResourceStatus> STATUS_FIELD = SdkField
            .<SyncResourceStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(SyncResourceSummary::status)).setter(setter(Builder::status)).constructor(SyncResourceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(SyncResourceSummary::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            EXTERNAL_ID_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD, UPDATE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String externalId;

    private final String resourceId;

    private final SyncResourceStatus status;

    private final Instant updateDateTime;

    private SyncResourceSummary(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.externalId = builder.externalId;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.updateDateTime = builder.updateDateTime;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link SyncResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see SyncResourceType
     */
    public final SyncResourceType resourceType() {
        return SyncResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link SyncResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see SyncResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The external Id.
     * </p>
     * 
     * @return The external Id.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The resource Id.
     * </p>
     * 
     * @return The resource Id.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The sync resource summary status.
     * </p>
     * 
     * @return The sync resource summary status.
     */
    public final SyncResourceStatus status() {
        return status;
    }

    /**
     * <p>
     * The update date and time.
     * </p>
     * 
     * @return The update date and time.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncResourceSummary)) {
            return false;
        }
        SyncResourceSummary other = (SyncResourceSummary) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(externalId(), other.externalId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(status(), other.status()) && Objects.equals(updateDateTime(), other.updateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncResourceSummary").add("ResourceType", resourceTypeAsString())
                .add("ExternalId", externalId()).add("ResourceId", resourceId()).add("Status", status())
                .add("UpdateDateTime", updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncResourceSummary, T> g) {
        return obj -> g.apply((SyncResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncResourceSummary> {
        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see SyncResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see SyncResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncResourceType
         */
        Builder resourceType(SyncResourceType resourceType);

        /**
         * <p>
         * The external Id.
         * </p>
         * 
         * @param externalId
         *        The external Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The resource Id.
         * </p>
         * 
         * @param resourceId
         *        The resource Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The sync resource summary status.
         * </p>
         * 
         * @param status
         *        The sync resource summary status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SyncResourceStatus status);

        /**
         * <p>
         * The sync resource summary status.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncResourceStatus.Builder} avoiding the
         * need to create one manually via {@link SyncResourceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncResourceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SyncResourceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SyncResourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SyncResourceStatus)
         */
        default Builder status(Consumer<SyncResourceStatus.Builder> status) {
            return status(SyncResourceStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The update date and time.
         * </p>
         * 
         * @param updateDateTime
         *        The update date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String externalId;

        private String resourceId;

        private SyncResourceStatus status;

        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncResourceSummary model) {
            resourceType(model.resourceType);
            externalId(model.externalId);
            resourceId(model.resourceId);
            status(model.status);
            updateDateTime(model.updateDateTime);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(SyncResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SyncResourceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SyncResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SyncResourceStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public SyncResourceSummary build() {
            return new SyncResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
