/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComponentTypeRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<UpdateComponentTypeRequest.Builder, UpdateComponentTypeRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateComponentTypeRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSingleton").getter(getter(UpdateComponentTypeRequest::isSingleton))
            .setter(setter(Builder::isSingleton))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(UpdateComponentTypeRequest::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("componentTypeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateComponentTypeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, PropertyDefinitionRequest>> PROPERTY_DEFINITIONS_FIELD = SdkField
            .<Map<String, PropertyDefinitionRequest>> builder(MarshallingType.MAP)
            .memberName("propertyDefinitions")
            .getter(getter(UpdateComponentTypeRequest::propertyDefinitions))
            .setter(setter(Builder::propertyDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyDefinitionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyDefinitionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("extendsFrom")
            .getter(getter(UpdateComponentTypeRequest::extendsFrom))
            .setter(setter(Builder::extendsFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FunctionRequest>> FUNCTIONS_FIELD = SdkField
            .<Map<String, FunctionRequest>> builder(MarshallingType.MAP)
            .memberName("functions")
            .getter(getter(UpdateComponentTypeRequest::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FunctionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, PropertyGroupRequest>> PROPERTY_GROUPS_FIELD = SdkField
            .<Map<String, PropertyGroupRequest>> builder(MarshallingType.MAP)
            .memberName("propertyGroups")
            .getter(getter(UpdateComponentTypeRequest::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyGroupRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyGroupRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> COMPONENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeName").getter(getter(UpdateComponentTypeRequest::componentTypeName))
            .setter(setter(Builder::componentTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            IS_SINGLETON_FIELD, COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, PROPERTY_DEFINITIONS_FIELD, EXTENDS_FROM_FIELD,
            FUNCTIONS_FIELD, PROPERTY_GROUPS_FIELD, COMPONENT_TYPE_NAME_FIELD));

    private final String workspaceId;

    private final Boolean isSingleton;

    private final String componentTypeId;

    private final String description;

    private final Map<String, PropertyDefinitionRequest> propertyDefinitions;

    private final List<String> extendsFrom;

    private final Map<String, FunctionRequest> functions;

    private final Map<String, PropertyGroupRequest> propertyGroups;

    private final String componentTypeName;

    private UpdateComponentTypeRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.isSingleton = builder.isSingleton;
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.propertyGroups = builder.propertyGroups;
        this.componentTypeName = builder.componentTypeName;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @return The ID of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * A Boolean value that specifies whether an entity can have more than one component of this type.
     * </p>
     * 
     * @return A Boolean value that specifies whether an entity can have more than one component of this type.
     */
    public final Boolean isSingleton() {
        return isSingleton;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyDefinitions() {
        return propertyDefinitions != null && !(propertyDefinitions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the property definitions in the component type. Each string in the mapping must be
     * unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyDefinitions} method.
     * </p>
     * 
     * @return An object that maps strings to the property definitions in the component type. Each string in the mapping
     *         must be unique to this object.
     */
    public final Map<String, PropertyDefinitionRequest> propertyDefinitions() {
        return propertyDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtendsFrom property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtendsFrom() {
        return extendsFrom != null && !(extendsFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the component type that this component type extends.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtendsFrom} method.
     * </p>
     * 
     * @return Specifies the component type that this component type extends.
     */
    public final List<String> extendsFrom() {
        return extendsFrom;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the functions in the component type. Each string in the mapping must be unique to
     * this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return An object that maps strings to the functions in the component type. Each string in the mapping must be
     *         unique to this object.
     */
    public final Map<String, FunctionRequest> functions() {
        return functions;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The property groups
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return The property groups
     */
    public final Map<String, PropertyGroupRequest> propertyGroups() {
        return propertyGroups;
    }

    /**
     * <p>
     * The component type name.
     * </p>
     * 
     * @return The component type name.
     */
    public final String componentTypeName() {
        return componentTypeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyDefinitions() ? propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExtendsFrom() ? extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentTypeRequest)) {
            return false;
        }
        UpdateComponentTypeRequest other = (UpdateComponentTypeRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(isSingleton(), other.isSingleton())
                && Objects.equals(componentTypeId(), other.componentTypeId())
                && Objects.equals(description(), other.description())
                && hasPropertyDefinitions() == other.hasPropertyDefinitions()
                && Objects.equals(propertyDefinitions(), other.propertyDefinitions())
                && hasExtendsFrom() == other.hasExtendsFrom() && Objects.equals(extendsFrom(), other.extendsFrom())
                && hasFunctions() == other.hasFunctions() && Objects.equals(functions(), other.functions())
                && hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(propertyGroups(), other.propertyGroups())
                && Objects.equals(componentTypeName(), other.componentTypeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComponentTypeRequest").add("WorkspaceId", workspaceId()).add("IsSingleton", isSingleton())
                .add("ComponentTypeId", componentTypeId()).add("Description", description())
                .add("PropertyDefinitions", hasPropertyDefinitions() ? propertyDefinitions() : null)
                .add("ExtendsFrom", hasExtendsFrom() ? extendsFrom() : null)
                .add("Functions", hasFunctions() ? functions() : null)
                .add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null)
                .add("ComponentTypeName", componentTypeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "isSingleton":
            return Optional.ofNullable(clazz.cast(isSingleton()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "propertyDefinitions":
            return Optional.ofNullable(clazz.cast(propertyDefinitions()));
        case "extendsFrom":
            return Optional.ofNullable(clazz.cast(extendsFrom()));
        case "functions":
            return Optional.ofNullable(clazz.cast(functions()));
        case "propertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        case "componentTypeName":
            return Optional.ofNullable(clazz.cast(componentTypeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentTypeRequest, T> g) {
        return obj -> g.apply((UpdateComponentTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComponentTypeRequest> {
        /**
         * <p>
         * The ID of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * A Boolean value that specifies whether an entity can have more than one component of this type.
         * </p>
         * 
         * @param isSingleton
         *        A Boolean value that specifies whether an entity can have more than one component of this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSingleton(Boolean isSingleton);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object that maps strings to the property definitions in the component type. Each string in the mapping
         * must be unique to this object.
         * </p>
         * 
         * @param propertyDefinitions
         *        An object that maps strings to the property definitions in the component type. Each string in the
         *        mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> propertyDefinitions);

        /**
         * <p>
         * Specifies the component type that this component type extends.
         * </p>
         * 
         * @param extendsFrom
         *        Specifies the component type that this component type extends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(Collection<String> extendsFrom);

        /**
         * <p>
         * Specifies the component type that this component type extends.
         * </p>
         * 
         * @param extendsFrom
         *        Specifies the component type that this component type extends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(String... extendsFrom);

        /**
         * <p>
         * An object that maps strings to the functions in the component type. Each string in the mapping must be unique
         * to this object.
         * </p>
         * 
         * @param functions
         *        An object that maps strings to the functions in the component type. Each string in the mapping must be
         *        unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Map<String, FunctionRequest> functions);

        /**
         * <p>
         * The property groups
         * </p>
         * 
         * @param propertyGroups
         *        The property groups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Map<String, PropertyGroupRequest> propertyGroups);

        /**
         * <p>
         * The component type name.
         * </p>
         * 
         * @param componentTypeName
         *        The component type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeName(String componentTypeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private Boolean isSingleton;

        private String componentTypeId;

        private String description;

        private Map<String, PropertyDefinitionRequest> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FunctionRequest> functions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, PropertyGroupRequest> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private String componentTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentTypeRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            isSingleton(model.isSingleton);
            componentTypeId(model.componentTypeId);
            description(model.description);
            propertyDefinitions(model.propertyDefinitions);
            extendsFrom(model.extendsFrom);
            functions(model.functions);
            propertyGroups(model.propertyGroups);
            componentTypeName(model.componentTypeName);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Boolean getIsSingleton() {
            return isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyDefinitionRequest.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionRequest.Builder> result = PropertyDefinitionsRequestCopier
                    .copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionRequest.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copy(propertyDefinitions);
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendsFrom(String... extendsFrom) {
            extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionRequest.Builder> getFunctions() {
            Map<String, FunctionRequest.Builder> result = FunctionsRequestCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionRequest.BuilderImpl> functions) {
            this.functions = FunctionsRequestCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Map<String, FunctionRequest> functions) {
            this.functions = FunctionsRequestCopier.copy(functions);
            return this;
        }

        public final Map<String, PropertyGroupRequest.Builder> getPropertyGroups() {
            Map<String, PropertyGroupRequest.Builder> result = PropertyGroupsRequestCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, PropertyGroupRequest.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsRequestCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, PropertyGroupRequest> propertyGroups) {
            this.propertyGroups = PropertyGroupsRequestCopier.copy(propertyGroups);
            return this;
        }

        public final String getComponentTypeName() {
            return componentTypeName;
        }

        public final void setComponentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final Builder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentTypeRequest build() {
            return new UpdateComponentTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
