/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter by asset model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterByAssetModel implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterByAssetModel.Builder, FilterByAssetModel> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(FilterByAssetModel::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelExternalId").getter(getter(FilterByAssetModel::assetModelExternalId))
            .setter(setter(Builder::assetModelExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelExternalId").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_OFFSPRING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeOffspring").getter(getter(FilterByAssetModel::includeOffspring))
            .setter(setter(Builder::includeOffspring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOffspring").build()).build();

    private static final SdkField<Boolean> INCLUDE_ASSETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeAssets").getter(getter(FilterByAssetModel::includeAssets)).setter(setter(Builder::includeAssets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAssets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_EXTERNAL_ID_FIELD, INCLUDE_OFFSPRING_FIELD, INCLUDE_ASSETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetModelId;

    private final String assetModelExternalId;

    private final Boolean includeOffspring;

    private final Boolean includeAssets;

    private FilterByAssetModel(BuilderImpl builder) {
        this.assetModelId = builder.assetModelId;
        this.assetModelExternalId = builder.assetModelExternalId;
        this.includeOffspring = builder.includeOffspring;
        this.includeAssets = builder.includeAssets;
    }

    /**
     * <p>
     * The asset model Id.
     * </p>
     * 
     * @return The asset model Id.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The external-Id property of an asset model.
     * </p>
     * 
     * @return The external-Id property of an asset model.
     */
    public final String assetModelExternalId() {
        return assetModelExternalId;
    }

    /**
     * <p>
     * Include asset offspring. [need desc.]
     * </p>
     * 
     * @return Include asset offspring. [need desc.]
     */
    public final Boolean includeOffspring() {
        return includeOffspring;
    }

    /**
     * <p>
     * Bolean to include assets.
     * </p>
     * 
     * @return Bolean to include assets.
     */
    public final Boolean includeAssets() {
        return includeAssets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(includeOffspring());
        hashCode = 31 * hashCode + Objects.hashCode(includeAssets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterByAssetModel)) {
            return false;
        }
        FilterByAssetModel other = (FilterByAssetModel) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetModelExternalId(), other.assetModelExternalId())
                && Objects.equals(includeOffspring(), other.includeOffspring())
                && Objects.equals(includeAssets(), other.includeAssets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterByAssetModel").add("AssetModelId", assetModelId())
                .add("AssetModelExternalId", assetModelExternalId()).add("IncludeOffspring", includeOffspring())
                .add("IncludeAssets", includeAssets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelExternalId":
            return Optional.ofNullable(clazz.cast(assetModelExternalId()));
        case "includeOffspring":
            return Optional.ofNullable(clazz.cast(includeOffspring()));
        case "includeAssets":
            return Optional.ofNullable(clazz.cast(includeAssets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterByAssetModel, T> g) {
        return obj -> g.apply((FilterByAssetModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterByAssetModel> {
        /**
         * <p>
         * The asset model Id.
         * </p>
         * 
         * @param assetModelId
         *        The asset model Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The external-Id property of an asset model.
         * </p>
         * 
         * @param assetModelExternalId
         *        The external-Id property of an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelExternalId(String assetModelExternalId);

        /**
         * <p>
         * Include asset offspring. [need desc.]
         * </p>
         * 
         * @param includeOffspring
         *        Include asset offspring. [need desc.]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOffspring(Boolean includeOffspring);

        /**
         * <p>
         * Bolean to include assets.
         * </p>
         * 
         * @param includeAssets
         *        Bolean to include assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAssets(Boolean includeAssets);
    }

    static final class BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelExternalId;

        private Boolean includeOffspring;

        private Boolean includeAssets;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterByAssetModel model) {
            assetModelId(model.assetModelId);
            assetModelExternalId(model.assetModelExternalId);
            includeOffspring(model.includeOffspring);
            includeAssets(model.includeAssets);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelExternalId() {
            return assetModelExternalId;
        }

        public final void setAssetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
        }

        @Override
        public final Builder assetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        public final Boolean getIncludeOffspring() {
            return includeOffspring;
        }

        public final void setIncludeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
        }

        @Override
        public final Builder includeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
            return this;
        }

        public final Boolean getIncludeAssets() {
            return includeAssets;
        }

        public final void setIncludeAssets(Boolean includeAssets) {
            this.includeAssets = includeAssets;
        }

        @Override
        public final Builder includeAssets(Boolean includeAssets) {
            this.includeAssets = includeAssets;
            return this;
        }

        @Override
        public FilterByAssetModel build() {
            return new FilterByAssetModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
