/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata transfer job summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataTransferJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataTransferJobSummary.Builder, MetadataTransferJobSummary> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataTransferJobId").getter(getter(MetadataTransferJobSummary::metadataTransferJobId))
            .setter(setter(Builder::metadataTransferJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(MetadataTransferJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(MetadataTransferJobSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(MetadataTransferJobSummary::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<MetadataTransferJobStatus> STATUS_FIELD = SdkField
            .<MetadataTransferJobStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(MetadataTransferJobSummary::status)).setter(setter(Builder::status))
            .constructor(MetadataTransferJobStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<MetadataTransferJobProgress> PROGRESS_FIELD = SdkField
            .<MetadataTransferJobProgress> builder(MarshallingType.SDK_POJO).memberName("progress")
            .getter(getter(MetadataTransferJobSummary::progress)).setter(setter(Builder::progress))
            .constructor(MetadataTransferJobProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METADATA_TRANSFER_JOB_ID_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, STATUS_FIELD,
            PROGRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metadataTransferJobId;

    private final String arn;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private final MetadataTransferJobStatus status;

    private final MetadataTransferJobProgress progress;

    private MetadataTransferJobSummary(BuilderImpl builder) {
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.status = builder.status;
        this.progress = builder.progress;
    }

    /**
     * <p>
     * The metadata transfer job summary Id.
     * </p>
     * 
     * @return The metadata transfer job summary Id.
     */
    public final String metadataTransferJobId() {
        return metadataTransferJobId;
    }

    /**
     * <p>
     * The metadata transfer job summary ARN.
     * </p>
     * 
     * @return The metadata transfer job summary ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The metadata transfer job summary creation DateTime object.
     * </p>
     * 
     * @return The metadata transfer job summary creation DateTime object.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The metadata transfer job summary update DateTime object
     * </p>
     * 
     * @return The metadata transfer job summary update DateTime object
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The metadata transfer job summary status.
     * </p>
     * 
     * @return The metadata transfer job summary status.
     */
    public final MetadataTransferJobStatus status() {
        return status;
    }

    /**
     * <p>
     * The metadata transfer job summary progess.
     * </p>
     * 
     * @return The metadata transfer job summary progess.
     */
    public final MetadataTransferJobProgress progress() {
        return progress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataTransferJobSummary)) {
            return false;
        }
        MetadataTransferJobSummary other = (MetadataTransferJobSummary) obj;
        return Objects.equals(metadataTransferJobId(), other.metadataTransferJobId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(status(), other.status())
                && Objects.equals(progress(), other.progress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataTransferJobSummary").add("MetadataTransferJobId", metadataTransferJobId())
                .add("Arn", arn()).add("CreationDateTime", creationDateTime()).add("UpdateDateTime", updateDateTime())
                .add("Status", status()).add("Progress", progress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataTransferJobId":
            return Optional.ofNullable(clazz.cast(metadataTransferJobId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "progress":
            return Optional.ofNullable(clazz.cast(progress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataTransferJobSummary, T> g) {
        return obj -> g.apply((MetadataTransferJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataTransferJobSummary> {
        /**
         * <p>
         * The metadata transfer job summary Id.
         * </p>
         * 
         * @param metadataTransferJobId
         *        The metadata transfer job summary Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobId(String metadataTransferJobId);

        /**
         * <p>
         * The metadata transfer job summary ARN.
         * </p>
         * 
         * @param arn
         *        The metadata transfer job summary ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The metadata transfer job summary creation DateTime object.
         * </p>
         * 
         * @param creationDateTime
         *        The metadata transfer job summary creation DateTime object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The metadata transfer job summary update DateTime object
         * </p>
         * 
         * @param updateDateTime
         *        The metadata transfer job summary update DateTime object
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The metadata transfer job summary status.
         * </p>
         * 
         * @param status
         *        The metadata transfer job summary status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(MetadataTransferJobStatus status);

        /**
         * <p>
         * The metadata transfer job summary status.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataTransferJobStatus.Builder}
         * avoiding the need to create one manually via {@link MetadataTransferJobStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataTransferJobStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(MetadataTransferJobStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link MetadataTransferJobStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(MetadataTransferJobStatus)
         */
        default Builder status(Consumer<MetadataTransferJobStatus.Builder> status) {
            return status(MetadataTransferJobStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The metadata transfer job summary progess.
         * </p>
         * 
         * @param progress
         *        The metadata transfer job summary progess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(MetadataTransferJobProgress progress);

        /**
         * <p>
         * The metadata transfer job summary progess.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataTransferJobProgress.Builder}
         * avoiding the need to create one manually via {@link MetadataTransferJobProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataTransferJobProgress.Builder#build()} is called
         * immediately and its result is passed to {@link #progress(MetadataTransferJobProgress)}.
         * 
         * @param progress
         *        a consumer that will call methods on {@link MetadataTransferJobProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progress(MetadataTransferJobProgress)
         */
        default Builder progress(Consumer<MetadataTransferJobProgress.Builder> progress) {
            return progress(MetadataTransferJobProgress.builder().applyMutation(progress).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String metadataTransferJobId;

        private String arn;

        private Instant creationDateTime;

        private Instant updateDateTime;

        private MetadataTransferJobStatus status;

        private MetadataTransferJobProgress progress;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataTransferJobSummary model) {
            metadataTransferJobId(model.metadataTransferJobId);
            arn(model.arn);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
            status(model.status);
            progress(model.progress);
        }

        public final String getMetadataTransferJobId() {
            return metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final MetadataTransferJobStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(MetadataTransferJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(MetadataTransferJobStatus status) {
            this.status = status;
            return this;
        }

        public final MetadataTransferJobProgress.Builder getProgress() {
            return progress != null ? progress.toBuilder() : null;
        }

        public final void setProgress(MetadataTransferJobProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(MetadataTransferJobProgress progress) {
            this.progress = progress;
            return this;
        }

        @Override
        public MetadataTransferJobSummary build() {
            return new MetadataTransferJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
