/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMetadataTransferJobResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<CreateMetadataTransferJobResponse.Builder, CreateMetadataTransferJobResponse> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataTransferJobId").getter(getter(CreateMetadataTransferJobResponse::metadataTransferJobId))
            .setter(setter(Builder::metadataTransferJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateMetadataTransferJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateMetadataTransferJobResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<MetadataTransferJobStatus> STATUS_FIELD = SdkField
            .<MetadataTransferJobStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(CreateMetadataTransferJobResponse::status)).setter(setter(Builder::status))
            .constructor(MetadataTransferJobStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METADATA_TRANSFER_JOB_ID_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, STATUS_FIELD));

    private final String metadataTransferJobId;

    private final String arn;

    private final Instant creationDateTime;

    private final MetadataTransferJobStatus status;

    private CreateMetadataTransferJobResponse(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The metadata transfer job Id.
     * </p>
     * 
     * @return The metadata transfer job Id.
     */
    public final String metadataTransferJobId() {
        return metadataTransferJobId;
    }

    /**
     * <p>
     * The metadata transfer job ARN.
     * </p>
     * 
     * @return The metadata transfer job ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The The metadata transfer job creation DateTime property.
     * </p>
     * 
     * @return The The metadata transfer job creation DateTime property.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The metadata transfer job response status.
     * </p>
     * 
     * @return The metadata transfer job response status.
     */
    public final MetadataTransferJobStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetadataTransferJobResponse)) {
            return false;
        }
        CreateMetadataTransferJobResponse other = (CreateMetadataTransferJobResponse) obj;
        return Objects.equals(metadataTransferJobId(), other.metadataTransferJobId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationDateTime(), other.creationDateTime()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMetadataTransferJobResponse").add("MetadataTransferJobId", metadataTransferJobId())
                .add("Arn", arn()).add("CreationDateTime", creationDateTime()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataTransferJobId":
            return Optional.ofNullable(clazz.cast(metadataTransferJobId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMetadataTransferJobResponse, T> g) {
        return obj -> g.apply((CreateMetadataTransferJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMetadataTransferJobResponse> {
        /**
         * <p>
         * The metadata transfer job Id.
         * </p>
         * 
         * @param metadataTransferJobId
         *        The metadata transfer job Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobId(String metadataTransferJobId);

        /**
         * <p>
         * The metadata transfer job ARN.
         * </p>
         * 
         * @param arn
         *        The metadata transfer job ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The The metadata transfer job creation DateTime property.
         * </p>
         * 
         * @param creationDateTime
         *        The The metadata transfer job creation DateTime property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The metadata transfer job response status.
         * </p>
         * 
         * @param status
         *        The metadata transfer job response status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(MetadataTransferJobStatus status);

        /**
         * <p>
         * The metadata transfer job response status.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataTransferJobStatus.Builder}
         * avoiding the need to create one manually via {@link MetadataTransferJobStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataTransferJobStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(MetadataTransferJobStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link MetadataTransferJobStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(MetadataTransferJobStatus)
         */
        default Builder status(Consumer<MetadataTransferJobStatus.Builder> status) {
            return status(MetadataTransferJobStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String metadataTransferJobId;

        private String arn;

        private Instant creationDateTime;

        private MetadataTransferJobStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetadataTransferJobResponse model) {
            super(model);
            metadataTransferJobId(model.metadataTransferJobId);
            arn(model.arn);
            creationDateTime(model.creationDateTime);
            status(model.status);
        }

        public final String getMetadataTransferJobId() {
            return metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final MetadataTransferJobStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(MetadataTransferJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(MetadataTransferJobStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateMetadataTransferJobResponse build() {
            return new CreateMetadataTransferJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
