/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntitySummary implements SdkPojo, Serializable, ToCopyableBuilder<EntitySummary.Builder, EntitySummary> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(EntitySummary::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityName").getter(getter(EntitySummary::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EntitySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(EntitySummary::parentEntityId)).setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final SdkField<Status> STATUS_FIELD = SdkField.<Status> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(EntitySummary::status)).setter(setter(Builder::status)).constructor(Status::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EntitySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> HAS_CHILD_ENTITIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasChildEntities").getter(getter(EntitySummary::hasChildEntities))
            .setter(setter(Builder::hasChildEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasChildEntities").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(EntitySummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(EntitySummary::updateDateTime)).setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            ENTITY_NAME_FIELD, ARN_FIELD, PARENT_ENTITY_ID_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, HAS_CHILD_ENTITIES_FIELD,
            CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityId;

    private final String entityName;

    private final String arn;

    private final String parentEntityId;

    private final Status status;

    private final String description;

    private final Boolean hasChildEntities;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private EntitySummary(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.arn = builder.arn;
        this.parentEntityId = builder.parentEntityId;
        this.status = builder.status;
        this.description = builder.description;
        this.hasChildEntities = builder.hasChildEntities;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
    }

    /**
     * <p>
     * The ID of the entity.
     * </p>
     * 
     * @return The ID of the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * The ARN of the entity.
     * </p>
     * 
     * @return The ARN of the entity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the parent entity.
     * </p>
     * 
     * @return The ID of the parent entity.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    /**
     * <p>
     * The current status of the entity.
     * </p>
     * 
     * @return The current status of the entity.
     */
    public final Status status() {
        return status;
    }

    /**
     * <p>
     * The description of the entity.
     * </p>
     * 
     * @return The description of the entity.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An <b>eventual</b> Boolean value that specifies whether the entity has child entities or not.
     * </p>
     * 
     * @return An <b>eventual</b> Boolean value that specifies whether the entity has child entities or not.
     */
    public final Boolean hasChildEntities() {
        return hasChildEntities;
    }

    /**
     * <p>
     * The date and time when the entity was created.
     * </p>
     * 
     * @return The date and time when the entity was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The last date and time when the entity was updated.
     * </p>
     * 
     * @return The last date and time when the entity was updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildEntities());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitySummary)) {
            return false;
        }
        EntitySummary other = (EntitySummary) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(entityName(), other.entityName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(parentEntityId(), other.parentEntityId())
                && Objects.equals(status(), other.status()) && Objects.equals(description(), other.description())
                && Objects.equals(hasChildEntities(), other.hasChildEntities())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntitySummary").add("EntityId", entityId()).add("EntityName", entityName()).add("Arn", arn())
                .add("ParentEntityId", parentEntityId()).add("Status", status()).add("Description", description())
                .add("HasChildEntities", hasChildEntities()).add("CreationDateTime", creationDateTime())
                .add("UpdateDateTime", updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "hasChildEntities":
            return Optional.ofNullable(clazz.cast(hasChildEntities()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntitySummary, T> g) {
        return obj -> g.apply((EntitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntitySummary> {
        /**
         * <p>
         * The ID of the entity.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param entityName
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * The ARN of the entity.
         * </p>
         * 
         * @param arn
         *        The ARN of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the parent entity.
         * </p>
         * 
         * @param parentEntityId
         *        The ID of the parent entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);

        /**
         * <p>
         * The current status of the entity.
         * </p>
         * 
         * @param status
         *        The current status of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Status status);

        /**
         * <p>
         * The current status of the entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link Status.Builder} avoiding the need to
         * create one manually via {@link Status#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Status.Builder#build()} is called immediately and its result is
         * passed to {@link #status(Status)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link Status.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(Status)
         */
        default Builder status(Consumer<Status.Builder> status) {
            return status(Status.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The description of the entity.
         * </p>
         * 
         * @param description
         *        The description of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An <b>eventual</b> Boolean value that specifies whether the entity has child entities or not.
         * </p>
         * 
         * @param hasChildEntities
         *        An <b>eventual</b> Boolean value that specifies whether the entity has child entities or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasChildEntities(Boolean hasChildEntities);

        /**
         * <p>
         * The date and time when the entity was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the entity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The last date and time when the entity was updated.
         * </p>
         * 
         * @param updateDateTime
         *        The last date and time when the entity was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String entityId;

        private String entityName;

        private String arn;

        private String parentEntityId;

        private Status status;

        private String description;

        private Boolean hasChildEntities;

        private Instant creationDateTime;

        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitySummary model) {
            entityId(model.entityId);
            entityName(model.entityName);
            arn(model.arn);
            parentEntityId(model.parentEntityId);
            status(model.status);
            description(model.description);
            hasChildEntities(model.hasChildEntities);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final Status.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getHasChildEntities() {
            return hasChildEntities;
        }

        public final void setHasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
        }

        @Override
        public final Builder hasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public EntitySummary build() {
            return new EntitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
