/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CancelMetadataTransferJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CancelMetadataTransferJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateMetadataTransferJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateMetadataTransferJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetMetadataTransferJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetMetadataTransferJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValuePublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentsPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListMetadataTransferJobsPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListPropertiesPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesPublisher;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesPublisher;

/**
 * Service client for accessing AWS IoT TwinMaker asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * IoT TwinMaker is a service with which you can build operational digital twins of physical systems. IoT TwinMaker
 * overlays measurements and analysis from real-world sensors, cameras, and enterprise applications so you can create
 * data visualizations to monitor your physical factory, building, or industrial plant. You can use this real-world data
 * to monitor operations and diagnose and repair errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTTwinMakerAsyncClient extends AwsClient {
    String SERVICE_NAME = "iottwinmaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iottwinmaker";

    /**
     * <p>
     * Sets values for multiple time series properties.
     * </p>
     *
     * @param batchPutPropertyValuesRequest
     * @return A Java Future containing the result of the BatchPutPropertyValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.BatchPutPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutPropertyValuesResponse> batchPutPropertyValues(
            BatchPutPropertyValuesRequest batchPutPropertyValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets values for multiple time series properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutPropertyValuesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchPutPropertyValuesRequest#builder()}
     * </p>
     *
     * @param batchPutPropertyValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchPutPropertyValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.BatchPutPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutPropertyValuesResponse> batchPutPropertyValues(
            Consumer<BatchPutPropertyValuesRequest.Builder> batchPutPropertyValuesRequest) {
        return batchPutPropertyValues(BatchPutPropertyValuesRequest.builder().applyMutation(batchPutPropertyValuesRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the metadata transfer job.
     * </p>
     *
     * @param cancelMetadataTransferJobRequest
     * @return A Java Future containing the result of the CancelMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CancelMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CancelMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMetadataTransferJobResponse> cancelMetadataTransferJob(
            CancelMetadataTransferJobRequest cancelMetadataTransferJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the metadata transfer job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMetadataTransferJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMetadataTransferJobRequest#builder()}
     * </p>
     *
     * @param cancelMetadataTransferJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CancelMetadataTransferJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CancelMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CancelMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMetadataTransferJobResponse> cancelMetadataTransferJob(
            Consumer<CancelMetadataTransferJobRequest.Builder> cancelMetadataTransferJobRequest) {
        return cancelMetadataTransferJob(CancelMetadataTransferJobRequest.builder()
                .applyMutation(cancelMetadataTransferJobRequest).build());
    }

    /**
     * <p>
     * Creates a component type.
     * </p>
     *
     * @param createComponentTypeRequest
     * @return A Java Future containing the result of the CreateComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateComponentTypeResponse> createComponentType(
            CreateComponentTypeRequest createComponentTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentTypeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateComponentTypeRequest#builder()}
     * </p>
     *
     * @param createComponentTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateComponentTypeResponse> createComponentType(
            Consumer<CreateComponentTypeRequest.Builder> createComponentTypeRequest) {
        return createComponentType(CreateComponentTypeRequest.builder().applyMutation(createComponentTypeRequest).build());
    }

    /**
     * <p>
     * Creates an entity.
     * </p>
     *
     * @param createEntityRequest
     * @return A Java Future containing the result of the CreateEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEntityResponse> createEntity(CreateEntityRequest createEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEntityRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEntityRequest#builder()}
     * </p>
     *
     * @param createEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEntityResponse> createEntity(Consumer<CreateEntityRequest.Builder> createEntityRequest) {
        return createEntity(CreateEntityRequest.builder().applyMutation(createEntityRequest).build());
    }

    /**
     * <p>
     * Creates a new metadata transfer job.
     * </p>
     *
     * @param createMetadataTransferJobRequest
     * @return A Java Future containing the result of the CreateMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMetadataTransferJobResponse> createMetadataTransferJob(
            CreateMetadataTransferJobRequest createMetadataTransferJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new metadata transfer job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMetadataTransferJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMetadataTransferJobRequest#builder()}
     * </p>
     *
     * @param createMetadataTransferJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CreateMetadataTransferJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMetadataTransferJobResponse> createMetadataTransferJob(
            Consumer<CreateMetadataTransferJobRequest.Builder> createMetadataTransferJobRequest) {
        return createMetadataTransferJob(CreateMetadataTransferJobRequest.builder()
                .applyMutation(createMetadataTransferJobRequest).build());
    }

    /**
     * <p>
     * Creates a scene.
     * </p>
     *
     * @param createSceneRequest
     * @return A Java Future containing the result of the CreateScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSceneResponse> createScene(CreateSceneRequest createSceneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSceneRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSceneRequest#builder()}
     * </p>
     *
     * @param createSceneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSceneResponse> createScene(Consumer<CreateSceneRequest.Builder> createSceneRequest) {
        return createScene(CreateSceneRequest.builder().applyMutation(createSceneRequest).build());
    }

    /**
     * <p>
     * This action creates a SyncJob.
     * </p>
     *
     * @param createSyncJobRequest
     * @return A Java Future containing the result of the CreateSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSyncJobResponse> createSyncJob(CreateSyncJobRequest createSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action creates a SyncJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSyncJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSyncJobRequest#builder()}
     * </p>
     *
     * @param createSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSyncJobResponse> createSyncJob(Consumer<CreateSyncJobRequest.Builder> createSyncJobRequest) {
        return createSyncJob(CreateSyncJobRequest.builder().applyMutation(createSyncJobRequest).build());
    }

    /**
     * <p>
     * Creates a workplace.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspaceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(
            Consumer<CreateWorkspaceRequest.Builder> createWorkspaceRequest) {
        return createWorkspace(CreateWorkspaceRequest.builder().applyMutation(createWorkspaceRequest).build());
    }

    /**
     * <p>
     * Deletes a component type.
     * </p>
     *
     * @param deleteComponentTypeRequest
     * @return A Java Future containing the result of the DeleteComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteComponentTypeResponse> deleteComponentType(
            DeleteComponentTypeRequest deleteComponentTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteComponentTypeRequest#builder()}
     * </p>
     *
     * @param deleteComponentTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteComponentTypeResponse> deleteComponentType(
            Consumer<DeleteComponentTypeRequest.Builder> deleteComponentTypeRequest) {
        return deleteComponentType(DeleteComponentTypeRequest.builder().applyMutation(deleteComponentTypeRequest).build());
    }

    /**
     * <p>
     * Deletes an entity.
     * </p>
     *
     * @param deleteEntityRequest
     * @return A Java Future containing the result of the DeleteEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEntityResponse> deleteEntity(DeleteEntityRequest deleteEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEntityRequest#builder()}
     * </p>
     *
     * @param deleteEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEntityResponse> deleteEntity(Consumer<DeleteEntityRequest.Builder> deleteEntityRequest) {
        return deleteEntity(DeleteEntityRequest.builder().applyMutation(deleteEntityRequest).build());
    }

    /**
     * <p>
     * Deletes a scene.
     * </p>
     *
     * @param deleteSceneRequest
     * @return A Java Future containing the result of the DeleteScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSceneResponse> deleteScene(DeleteSceneRequest deleteSceneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSceneRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSceneRequest#builder()}
     * </p>
     *
     * @param deleteSceneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSceneResponse> deleteScene(Consumer<DeleteSceneRequest.Builder> deleteSceneRequest) {
        return deleteScene(DeleteSceneRequest.builder().applyMutation(deleteSceneRequest).build());
    }

    /**
     * <p>
     * Delete the SyncJob.
     * </p>
     *
     * @param deleteSyncJobRequest
     * @return A Java Future containing the result of the DeleteSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSyncJobResponse> deleteSyncJob(DeleteSyncJobRequest deleteSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the SyncJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSyncJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSyncJobRequest#builder()}
     * </p>
     *
     * @param deleteSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSyncJobResponse> deleteSyncJob(Consumer<DeleteSyncJobRequest.Builder> deleteSyncJobRequest) {
        return deleteSyncJob(DeleteSyncJobRequest.builder().applyMutation(deleteSyncJobRequest).build());
    }

    /**
     * <p>
     * Deletes a workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkspaceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(
            Consumer<DeleteWorkspaceRequest.Builder> deleteWorkspaceRequest) {
        return deleteWorkspace(DeleteWorkspaceRequest.builder().applyMutation(deleteWorkspaceRequest).build());
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     * <note>
     * <p>
     * The ExecuteQuery action only works with <a
     * href="https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/home.html">Amazon Web Services Java
     * SDK2</a>. ExecuteQuery will not work with any Amazon Web Services Java SDK version &lt; 2.x.
     * </p>
     * </note>
     *
     * @param executeQueryRequest
     * @return A Java Future containing the result of the ExecuteQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>QueryTimeoutException The query timeout exception.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteQueryResponse> executeQuery(ExecuteQueryRequest executeQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     * <note>
     * <p>
     * The ExecuteQuery action only works with <a
     * href="https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/home.html">Amazon Web Services Java
     * SDK2</a>. ExecuteQuery will not work with any Amazon Web Services Java SDK version &lt; 2.x.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>QueryTimeoutException The query timeout exception.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteQueryResponse> executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest) {
        return executeQuery(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation.</b>
     * </p>
     *
     * @param executeQueryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>QueryTimeoutException The query timeout exception.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryPublisher executeQueryPaginator(ExecuteQueryRequest executeQueryRequest) {
        return new ExecuteQueryPublisher(this, executeQueryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #executeQuery(software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>QueryTimeoutException The query timeout exception.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryPublisher executeQueryPaginator(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest) {
        return executeQueryPaginator(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a component type.
     * </p>
     *
     * @param getComponentTypeRequest
     * @return A Java Future containing the result of the GetComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetComponentTypeResponse> getComponentType(GetComponentTypeRequest getComponentTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentTypeRequest.Builder} avoiding the need
     * to create one manually via {@link GetComponentTypeRequest#builder()}
     * </p>
     *
     * @param getComponentTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetComponentTypeResponse> getComponentType(
            Consumer<GetComponentTypeRequest.Builder> getComponentTypeRequest) {
        return getComponentType(GetComponentTypeRequest.builder().applyMutation(getComponentTypeRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an entity.
     * </p>
     *
     * @param getEntityRequest
     * @return A Java Future containing the result of the GetEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEntityResponse> getEntity(GetEntityRequest getEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntityRequest#builder()}
     * </p>
     *
     * @param getEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEntityResponse> getEntity(Consumer<GetEntityRequest.Builder> getEntityRequest) {
        return getEntity(GetEntityRequest.builder().applyMutation(getEntityRequest).build());
    }

    /**
     * <p>
     * Gets a nmetadata transfer job.
     * </p>
     *
     * @param getMetadataTransferJobRequest
     * @return A Java Future containing the result of the GetMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMetadataTransferJobResponse> getMetadataTransferJob(
            GetMetadataTransferJobRequest getMetadataTransferJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a nmetadata transfer job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetadataTransferJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMetadataTransferJobRequest#builder()}
     * </p>
     *
     * @param getMetadataTransferJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetMetadataTransferJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMetadataTransferJobResponse> getMetadataTransferJob(
            Consumer<GetMetadataTransferJobRequest.Builder> getMetadataTransferJobRequest) {
        return getMetadataTransferJob(GetMetadataTransferJobRequest.builder().applyMutation(getMetadataTransferJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets the pricing plan.
     * </p>
     *
     * @param getPricingPlanRequest
     * @return A Java Future containing the result of the GetPricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPricingPlanResponse> getPricingPlan(GetPricingPlanRequest getPricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPricingPlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetPricingPlanRequest#builder()}
     * </p>
     *
     * @param getPricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPricingPlanResponse> getPricingPlan(Consumer<GetPricingPlanRequest.Builder> getPricingPlanRequest) {
        return getPricingPlan(GetPricingPlanRequest.builder().applyMutation(getPricingPlanRequest).build());
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     *
     * @param getPropertyValueRequest
     * @return A Java Future containing the result of the GetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPropertyValueResponse> getPropertyValue(GetPropertyValueRequest getPropertyValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueRequest.Builder} avoiding the need
     * to create one manually via {@link GetPropertyValueRequest#builder()}
     * </p>
     *
     * @param getPropertyValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPropertyValueResponse> getPropertyValue(
            Consumer<GetPropertyValueRequest.Builder> getPropertyValueRequest) {
        return getPropertyValue(GetPropertyValueRequest.builder().applyMutation(getPropertyValueRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     * @return A Java Future containing the result of the GetPropertyValueHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertyValueHistoryResponse> getPropertyValueHistory(
            GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPropertyValueHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertyValueHistoryResponse> getPropertyValueHistory(
            Consumer<GetPropertyValueHistoryRequest.Builder> getPropertyValueHistoryRequest) {
        return getPropertyValueHistory(GetPropertyValueHistoryRequest.builder().applyMutation(getPropertyValueHistoryRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryPublisher publisher = client.getPropertyValueHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryPublisher publisher = client.getPropertyValueHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertyValueHistoryPublisher getPropertyValueHistoryPaginator(
            GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) {
        return new GetPropertyValueHistoryPublisher(this, getPropertyValueHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryPublisher publisher = client.getPropertyValueHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryPublisher publisher = client.getPropertyValueHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValueHistory(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertyValueHistoryPublisher getPropertyValueHistoryPaginator(
            Consumer<GetPropertyValueHistoryRequest.Builder> getPropertyValueHistoryRequest) {
        return getPropertyValueHistoryPaginator(GetPropertyValueHistoryRequest.builder()
                .applyMutation(getPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValuePublisher publisher = client.getPropertyValuePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValuePublisher publisher = client.getPropertyValuePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPropertyValueRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPropertyValuePublisher getPropertyValuePaginator(GetPropertyValueRequest getPropertyValueRequest) {
        return new GetPropertyValuePublisher(this, getPropertyValueRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValuePublisher publisher = client.getPropertyValuePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValuePublisher publisher = client.getPropertyValuePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPropertyValue(software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertyValueRequest.Builder} avoiding the need
     * to create one manually via {@link GetPropertyValueRequest#builder()}
     * </p>
     *
     * @param getPropertyValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPropertyValuePublisher getPropertyValuePaginator(Consumer<GetPropertyValueRequest.Builder> getPropertyValueRequest) {
        return getPropertyValuePaginator(GetPropertyValueRequest.builder().applyMutation(getPropertyValueRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a scene.
     * </p>
     *
     * @param getSceneRequest
     * @return A Java Future containing the result of the GetScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSceneResponse> getScene(GetSceneRequest getSceneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSceneRequest.Builder} avoiding the need to
     * create one manually via {@link GetSceneRequest#builder()}
     * </p>
     *
     * @param getSceneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSceneResponse> getScene(Consumer<GetSceneRequest.Builder> getSceneRequest) {
        return getScene(GetSceneRequest.builder().applyMutation(getSceneRequest).build());
    }

    /**
     * <p>
     * Gets the SyncJob.
     * </p>
     *
     * @param getSyncJobRequest
     * @return A Java Future containing the result of the GetSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSyncJobResponse> getSyncJob(GetSyncJobRequest getSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the SyncJob.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSyncJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetSyncJobRequest#builder()}
     * </p>
     *
     * @param getSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSyncJobResponse> getSyncJob(Consumer<GetSyncJobRequest.Builder> getSyncJobRequest) {
        return getSyncJob(GetSyncJobRequest.builder().applyMutation(getSyncJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a workspace.
     * </p>
     *
     * @param getWorkspaceRequest
     * @return A Java Future containing the result of the GetWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkspaceResponse> getWorkspace(GetWorkspaceRequest getWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkspaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkspaceRequest#builder()}
     * </p>
     *
     * @param getWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkspaceResponse> getWorkspace(Consumer<GetWorkspaceRequest.Builder> getWorkspaceRequest) {
        return getWorkspace(GetWorkspaceRequest.builder().applyMutation(getWorkspaceRequest).build());
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     *
     * @param listComponentTypesRequest
     * @return A Java Future containing the result of the ListComponentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentTypesResponse> listComponentTypes(ListComponentTypesRequest listComponentTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentTypesRequest#builder()}
     * </p>
     *
     * @param listComponentTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComponentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentTypesResponse> listComponentTypes(
            Consumer<ListComponentTypesRequest.Builder> listComponentTypesRequest) {
        return listComponentTypes(ListComponentTypesRequest.builder().applyMutation(listComponentTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesPublisher publisher = client.listComponentTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesPublisher publisher = client.listComponentTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentTypesPublisher listComponentTypesPaginator(ListComponentTypesRequest listComponentTypesRequest) {
        return new ListComponentTypesPublisher(this, listComponentTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesPublisher publisher = client.listComponentTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesPublisher publisher = client.listComponentTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentTypes(software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentTypesRequest#builder()}
     * </p>
     *
     * @param listComponentTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentTypesPublisher listComponentTypesPaginator(
            Consumer<ListComponentTypesRequest.Builder> listComponentTypesRequest) {
        return listComponentTypesPaginator(ListComponentTypesRequest.builder().applyMutation(listComponentTypesRequest).build());
    }

    /**
     * <p>
     * This API lists the components of an entity.
     * </p>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API lists the components of an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(ListComponentsRequest listComponentsRequest) {
        return new ListComponentsPublisher(this, listComponentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     *
     * @param listEntitiesRequest
     * @return A Java Future containing the result of the ListEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntitiesResponse> listEntities(ListEntitiesRequest listEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntitiesResponse> listEntities(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest) {
        return listEntities(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation.</b>
     * </p>
     *
     * @param listEntitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesPublisher listEntitiesPaginator(ListEntitiesRequest listEntitiesRequest) {
        return new ListEntitiesPublisher(this, listEntitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesPublisher listEntitiesPaginator(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest) {
        return listEntitiesPaginator(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists the metadata transfer jobs.
     * </p>
     *
     * @param listMetadataTransferJobsRequest
     * @return A Java Future containing the result of the ListMetadataTransferJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListMetadataTransferJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListMetadataTransferJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMetadataTransferJobsResponse> listMetadataTransferJobs(
            ListMetadataTransferJobsRequest listMetadataTransferJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the metadata transfer jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataTransferJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataTransferJobsRequest#builder()}
     * </p>
     *
     * @param listMetadataTransferJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMetadataTransferJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListMetadataTransferJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListMetadataTransferJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMetadataTransferJobsResponse> listMetadataTransferJobs(
            Consumer<ListMetadataTransferJobsRequest.Builder> listMetadataTransferJobsRequest) {
        return listMetadataTransferJobs(ListMetadataTransferJobsRequest.builder().applyMutation(listMetadataTransferJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataTransferJobs(software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListMetadataTransferJobsPublisher publisher = client.listMetadataTransferJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListMetadataTransferJobsPublisher publisher = client.listMetadataTransferJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataTransferJobs(software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMetadataTransferJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListMetadataTransferJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListMetadataTransferJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataTransferJobsPublisher listMetadataTransferJobsPaginator(
            ListMetadataTransferJobsRequest listMetadataTransferJobsRequest) {
        return new ListMetadataTransferJobsPublisher(this, listMetadataTransferJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataTransferJobs(software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListMetadataTransferJobsPublisher publisher = client.listMetadataTransferJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListMetadataTransferJobsPublisher publisher = client.listMetadataTransferJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataTransferJobs(software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataTransferJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataTransferJobsRequest#builder()}
     * </p>
     *
     * @param listMetadataTransferJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListMetadataTransferJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListMetadataTransferJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataTransferJobsPublisher listMetadataTransferJobsPaginator(
            Consumer<ListMetadataTransferJobsRequest.Builder> listMetadataTransferJobsRequest) {
        return listMetadataTransferJobsPaginator(ListMetadataTransferJobsRequest.builder()
                .applyMutation(listMetadataTransferJobsRequest).build());
    }

    /**
     * <p>
     * This API lists the properties of a component.
     * </p>
     *
     * @param listPropertiesRequest
     * @return A Java Future containing the result of the ListProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPropertiesResponse> listProperties(ListPropertiesRequest listPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API lists the properties of a component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPropertiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPropertiesRequest#builder()}
     * </p>
     *
     * @param listPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPropertiesResponse> listProperties(Consumer<ListPropertiesRequest.Builder> listPropertiesRequest) {
        return listProperties(ListPropertiesRequest.builder().applyMutation(listPropertiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProperties(software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListPropertiesPublisher publisher = client.listPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListPropertiesPublisher publisher = client.listPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProperties(software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest)} operation.</b>
     * </p>
     *
     * @param listPropertiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPropertiesPublisher listPropertiesPaginator(ListPropertiesRequest listPropertiesRequest) {
        return new ListPropertiesPublisher(this, listPropertiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProperties(software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListPropertiesPublisher publisher = client.listPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListPropertiesPublisher publisher = client.listPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProperties(software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPropertiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPropertiesRequest#builder()}
     * </p>
     *
     * @param listPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPropertiesPublisher listPropertiesPaginator(Consumer<ListPropertiesRequest.Builder> listPropertiesRequest) {
        return listPropertiesPaginator(ListPropertiesRequest.builder().applyMutation(listPropertiesRequest).build());
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     *
     * @param listScenesRequest
     * @return A Java Future containing the result of the ListScenes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListScenesResponse> listScenes(ListScenesRequest listScenesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScenesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScenesRequest#builder()}
     * </p>
     *
     * @param listScenesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListScenes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListScenesResponse> listScenes(Consumer<ListScenesRequest.Builder> listScenesRequest) {
        return listScenes(ListScenesRequest.builder().applyMutation(listScenesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesPublisher publisher = client.listScenesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesPublisher publisher = client.listScenesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)} operation.</b>
     * </p>
     *
     * @param listScenesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScenesPublisher listScenesPaginator(ListScenesRequest listScenesRequest) {
        return new ListScenesPublisher(this, listScenesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesPublisher publisher = client.listScenesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesPublisher publisher = client.listScenesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScenes(software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScenesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScenesRequest#builder()}
     * </p>
     *
     * @param listScenesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScenesPublisher listScenesPaginator(Consumer<ListScenesRequest.Builder> listScenesRequest) {
        return listScenesPaginator(ListScenesRequest.builder().applyMutation(listScenesRequest).build());
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     *
     * @param listSyncJobsRequest
     * @return A Java Future containing the result of the ListSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSyncJobsResponse> listSyncJobs(ListSyncJobsRequest listSyncJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSyncJobsRequest#builder()}
     * </p>
     *
     * @param listSyncJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSyncJobsResponse> listSyncJobs(Consumer<ListSyncJobsRequest.Builder> listSyncJobsRequest) {
        return listSyncJobs(ListSyncJobsRequest.builder().applyMutation(listSyncJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsPublisher publisher = client.listSyncJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsPublisher publisher = client.listSyncJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation.</b>
     * </p>
     *
     * @param listSyncJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSyncJobsPublisher listSyncJobsPaginator(ListSyncJobsRequest listSyncJobsRequest) {
        return new ListSyncJobsPublisher(this, listSyncJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsPublisher publisher = client.listSyncJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsPublisher publisher = client.listSyncJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncJobs(software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSyncJobsRequest#builder()}
     * </p>
     *
     * @param listSyncJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSyncJobsPublisher listSyncJobsPaginator(Consumer<ListSyncJobsRequest.Builder> listSyncJobsRequest) {
        return listSyncJobsPaginator(ListSyncJobsRequest.builder().applyMutation(listSyncJobsRequest).build());
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     *
     * @param listSyncResourcesRequest
     * @return A Java Future containing the result of the ListSyncResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSyncResourcesResponse> listSyncResources(ListSyncResourcesRequest listSyncResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListSyncResourcesRequest#builder()}
     * </p>
     *
     * @param listSyncResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSyncResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSyncResourcesResponse> listSyncResources(
            Consumer<ListSyncResourcesRequest.Builder> listSyncResourcesRequest) {
        return listSyncResources(ListSyncResourcesRequest.builder().applyMutation(listSyncResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesPublisher publisher = client.listSyncResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesPublisher publisher = client.listSyncResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSyncResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncResourcesPublisher listSyncResourcesPaginator(ListSyncResourcesRequest listSyncResourcesRequest) {
        return new ListSyncResourcesPublisher(this, listSyncResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesPublisher publisher = client.listSyncResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesPublisher publisher = client.listSyncResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncResources(software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListSyncResourcesRequest#builder()}
     * </p>
     *
     * @param listSyncResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncResourcesPublisher listSyncResourcesPaginator(
            Consumer<ListSyncResourcesRequest.Builder> listSyncResourcesRequest) {
        return listSyncResourcesPaginator(ListSyncResourcesRequest.builder().applyMutation(listSyncResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkspacesResponse> listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkspacesResponse> listWorkspaces(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest) {
        return listWorkspaces(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkspacesPublisher listWorkspacesPaginator(ListWorkspacesRequest listWorkspacesRequest) {
        return new ListWorkspacesPublisher(this, listWorkspacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkspacesPublisher listWorkspacesPaginator(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest) {
        return listWorkspacesPaginator(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagsException The number of tags exceeds the limit.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagsException The number of tags exceeds the limit.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates information in a component type.
     * </p>
     *
     * @param updateComponentTypeRequest
     * @return A Java Future containing the result of the UpdateComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateComponentTypeResponse> updateComponentType(
            UpdateComponentTypeRequest updateComponentTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information in a component type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentTypeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateComponentTypeRequest#builder()}
     * </p>
     *
     * @param updateComponentTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateComponentTypeResponse> updateComponentType(
            Consumer<UpdateComponentTypeRequest.Builder> updateComponentTypeRequest) {
        return updateComponentType(UpdateComponentTypeRequest.builder().applyMutation(updateComponentTypeRequest).build());
    }

    /**
     * <p>
     * Updates an entity.
     * </p>
     *
     * @param updateEntityRequest
     * @return A Java Future containing the result of the UpdateEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEntityResponse> updateEntity(UpdateEntityRequest updateEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEntityRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEntityRequest#builder()}
     * </p>
     *
     * @param updateEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEntityResponse> updateEntity(Consumer<UpdateEntityRequest.Builder> updateEntityRequest) {
        return updateEntity(UpdateEntityRequest.builder().applyMutation(updateEntityRequest).build());
    }

    /**
     * <p>
     * Update the pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return A Java Future containing the result of the UpdatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePricingPlanResponse> updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePricingPlanRequest#builder()}
     * </p>
     *
     * @param updatePricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePricingPlanResponse> updatePricingPlan(
            Consumer<UpdatePricingPlanRequest.Builder> updatePricingPlanRequest) {
        return updatePricingPlan(UpdatePricingPlanRequest.builder().applyMutation(updatePricingPlanRequest).build());
    }

    /**
     * <p>
     * Updates a scene.
     * </p>
     *
     * @param updateSceneRequest
     * @return A Java Future containing the result of the UpdateScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSceneResponse> updateScene(UpdateSceneRequest updateSceneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a scene.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSceneRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSceneRequest#builder()}
     * </p>
     *
     * @param updateSceneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSceneResponse> updateScene(Consumer<UpdateSceneRequest.Builder> updateSceneRequest) {
        return updateScene(UpdateSceneRequest.builder().applyMutation(updateSceneRequest).build());
    }

    /**
     * <p>
     * Updates a workspace.
     * </p>
     *
     * @param updateWorkspaceRequest
     * @return A Java Future containing the result of the UpdateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceResponse> updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkspaceRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceResponse> updateWorkspace(
            Consumer<UpdateWorkspaceRequest.Builder> updateWorkspaceRequest) {
        return updateWorkspace(UpdateWorkspaceRequest.builder().applyMutation(updateWorkspaceRequest).build());
    }

    @Override
    default IoTTwinMakerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IoTTwinMakerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTTwinMakerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTTwinMakerAsyncClient}.
     */
    static IoTTwinMakerAsyncClientBuilder builder() {
        return new DefaultIoTTwinMakerAsyncClientBuilder();
    }
}
