/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that uniquely identifies an entity property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityPropertyReference implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityPropertyReference.Builder, EntityPropertyReference> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(EntityPropertyReference::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentPath").getter(getter(EntityPropertyReference::componentPath))
            .setter(setter(Builder::componentPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentPath").build()).build();

    private static final SdkField<Map<String, String>> EXTERNAL_ID_PROPERTY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("externalIdProperty")
            .getter(getter(EntityPropertyReference::externalIdProperty))
            .setter(setter(Builder::externalIdProperty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdProperty").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(EntityPropertyReference::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyName").getter(getter(EntityPropertyReference::propertyName))
            .setter(setter(Builder::propertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_PATH_FIELD, EXTERNAL_ID_PROPERTY_FIELD, ENTITY_ID_FIELD, PROPERTY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String componentPath;

    private final Map<String, String> externalIdProperty;

    private final String entityId;

    private final String propertyName;

    private EntityPropertyReference(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentPath = builder.componentPath;
        this.externalIdProperty = builder.externalIdProperty;
        this.entityId = builder.entityId;
        this.propertyName = builder.propertyName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * This string specifies the path to the composite component, starting from the top-level component.
     * </p>
     * 
     * @return This string specifies the path to the composite component, starting from the top-level component.
     */
    public final String componentPath() {
        return componentPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalIdProperty property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalIdProperty() {
        return externalIdProperty != null && !(externalIdProperty instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalIdProperty} method.
     * </p>
     * 
     * @return A mapping of external IDs to property names. External IDs uniquely identify properties from external data
     *         stores.
     */
    public final Map<String, String> externalIdProperty() {
        return externalIdProperty;
    }

    /**
     * <p>
     * The ID of the entity.
     * </p>
     * 
     * @return The ID of the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The name of the property.
     * </p>
     * 
     * @return The name of the property.
     */
    public final String propertyName() {
        return propertyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalIdProperty() ? externalIdProperty() : null);
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityPropertyReference)) {
            return false;
        }
        EntityPropertyReference other = (EntityPropertyReference) obj;
        return Objects.equals(componentName(), other.componentName()) && Objects.equals(componentPath(), other.componentPath())
                && hasExternalIdProperty() == other.hasExternalIdProperty()
                && Objects.equals(externalIdProperty(), other.externalIdProperty())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(propertyName(), other.propertyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityPropertyReference").add("ComponentName", componentName())
                .add("ComponentPath", componentPath())
                .add("ExternalIdProperty", hasExternalIdProperty() ? externalIdProperty() : null).add("EntityId", entityId())
                .add("PropertyName", propertyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentPath":
            return Optional.ofNullable(clazz.cast(componentPath()));
        case "externalIdProperty":
            return Optional.ofNullable(clazz.cast(externalIdProperty()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "propertyName":
            return Optional.ofNullable(clazz.cast(propertyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityPropertyReference, T> g) {
        return obj -> g.apply((EntityPropertyReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityPropertyReference> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * This string specifies the path to the composite component, starting from the top-level component.
         * </p>
         * 
         * @param componentPath
         *        This string specifies the path to the composite component, starting from the top-level component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentPath(String componentPath);

        /**
         * <p>
         * A mapping of external IDs to property names. External IDs uniquely identify properties from external data
         * stores.
         * </p>
         * 
         * @param externalIdProperty
         *        A mapping of external IDs to property names. External IDs uniquely identify properties from external
         *        data stores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIdProperty(Map<String, String> externalIdProperty);

        /**
         * <p>
         * The ID of the entity.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The name of the property.
         * </p>
         * 
         * @param propertyName
         *        The name of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyName(String propertyName);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String componentPath;

        private Map<String, String> externalIdProperty = DefaultSdkAutoConstructMap.getInstance();

        private String entityId;

        private String propertyName;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityPropertyReference model) {
            componentName(model.componentName);
            componentPath(model.componentPath);
            externalIdProperty(model.externalIdProperty);
            entityId(model.entityId);
            propertyName(model.propertyName);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentPath() {
            return componentPath;
        }

        public final void setComponentPath(String componentPath) {
            this.componentPath = componentPath;
        }

        @Override
        public final Builder componentPath(String componentPath) {
            this.componentPath = componentPath;
            return this;
        }

        public final Map<String, String> getExternalIdProperty() {
            if (externalIdProperty instanceof SdkAutoConstructMap) {
                return null;
            }
            return externalIdProperty;
        }

        public final void setExternalIdProperty(Map<String, String> externalIdProperty) {
            this.externalIdProperty = ExternalIdPropertyCopier.copy(externalIdProperty);
        }

        @Override
        public final Builder externalIdProperty(Map<String, String> externalIdProperty) {
            this.externalIdProperty = ExternalIdPropertyCopier.copy(externalIdProperty);
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getPropertyName() {
            return propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        @Override
        public EntityPropertyReference build() {
            return new EntityPropertyReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
