/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentTypeResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetComponentTypeResponse.Builder, GetComponentTypeResponse> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetComponentTypeResponse::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSingleton").getter(getter(GetComponentTypeResponse::isSingleton)).setter(setter(Builder::isSingleton))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(GetComponentTypeResponse::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetComponentTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, PropertyDefinitionResponse>> PROPERTY_DEFINITIONS_FIELD = SdkField
            .<Map<String, PropertyDefinitionResponse>> builder(MarshallingType.MAP)
            .memberName("propertyDefinitions")
            .getter(getter(GetComponentTypeResponse::propertyDefinitions))
            .setter(setter(Builder::propertyDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyDefinitionResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyDefinitionResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("extendsFrom")
            .getter(getter(GetComponentTypeResponse::extendsFrom))
            .setter(setter(Builder::extendsFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FunctionResponse>> FUNCTIONS_FIELD = SdkField
            .<Map<String, FunctionResponse>> builder(MarshallingType.MAP)
            .memberName("functions")
            .getter(getter(GetComponentTypeResponse::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FunctionResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GetComponentTypeResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(GetComponentTypeResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetComponentTypeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Boolean> IS_ABSTRACT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAbstract").getter(getter(GetComponentTypeResponse::isAbstract)).setter(setter(Builder::isAbstract))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAbstract").build()).build();

    private static final SdkField<Boolean> IS_SCHEMA_INITIALIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSchemaInitialized").getter(getter(GetComponentTypeResponse::isSchemaInitialized))
            .setter(setter(Builder::isSchemaInitialized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSchemaInitialized").build())
            .build();

    private static final SdkField<Status> STATUS_FIELD = SdkField.<Status> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(GetComponentTypeResponse::status)).setter(setter(Builder::status)).constructor(Status::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, PropertyGroupResponse>> PROPERTY_GROUPS_FIELD = SdkField
            .<Map<String, PropertyGroupResponse>> builder(MarshallingType.MAP)
            .memberName("propertyGroups")
            .getter(getter(GetComponentTypeResponse::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyGroupResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyGroupResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSource").getter(getter(GetComponentTypeResponse::syncSource)).setter(setter(Builder::syncSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeName").getter(getter(GetComponentTypeResponse::componentTypeName))
            .setter(setter(Builder::componentTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeName").build()).build();

    private static final SdkField<Map<String, CompositeComponentTypeResponse>> COMPOSITE_COMPONENT_TYPES_FIELD = SdkField
            .<Map<String, CompositeComponentTypeResponse>> builder(MarshallingType.MAP)
            .memberName("compositeComponentTypes")
            .getter(getter(GetComponentTypeResponse::compositeComponentTypes))
            .setter(setter(Builder::compositeComponentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponentTypes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CompositeComponentTypeResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositeComponentTypeResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            IS_SINGLETON_FIELD, COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, PROPERTY_DEFINITIONS_FIELD, EXTENDS_FROM_FIELD,
            FUNCTIONS_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, ARN_FIELD, IS_ABSTRACT_FIELD,
            IS_SCHEMA_INITIALIZED_FIELD, STATUS_FIELD, PROPERTY_GROUPS_FIELD, SYNC_SOURCE_FIELD, COMPONENT_TYPE_NAME_FIELD,
            COMPOSITE_COMPONENT_TYPES_FIELD));

    private final String workspaceId;

    private final Boolean isSingleton;

    private final String componentTypeId;

    private final String description;

    private final Map<String, PropertyDefinitionResponse> propertyDefinitions;

    private final List<String> extendsFrom;

    private final Map<String, FunctionResponse> functions;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private final String arn;

    private final Boolean isAbstract;

    private final Boolean isSchemaInitialized;

    private final Status status;

    private final Map<String, PropertyGroupResponse> propertyGroups;

    private final String syncSource;

    private final String componentTypeName;

    private final Map<String, CompositeComponentTypeResponse> compositeComponentTypes;

    private GetComponentTypeResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.isSingleton = builder.isSingleton;
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.arn = builder.arn;
        this.isAbstract = builder.isAbstract;
        this.isSchemaInitialized = builder.isSchemaInitialized;
        this.status = builder.status;
        this.propertyGroups = builder.propertyGroups;
        this.syncSource = builder.syncSource;
        this.componentTypeName = builder.componentTypeName;
        this.compositeComponentTypes = builder.compositeComponentTypes;
    }

    /**
     * <p>
     * The ID of the workspace that contains the component type.
     * </p>
     * 
     * @return The ID of the workspace that contains the component type.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * A Boolean value that specifies whether an entity can have more than one component of this type.
     * </p>
     * 
     * @return A Boolean value that specifies whether an entity can have more than one component of this type.
     */
    public final Boolean isSingleton() {
        return isSingleton;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyDefinitions() {
        return propertyDefinitions != null && !(propertyDefinitions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the property definitions in the component type. Each string in the mapping must be
     * unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyDefinitions} method.
     * </p>
     * 
     * @return An object that maps strings to the property definitions in the component type. Each string in the mapping
     *         must be unique to this object.
     */
    public final Map<String, PropertyDefinitionResponse> propertyDefinitions() {
        return propertyDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtendsFrom property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtendsFrom() {
        return extendsFrom != null && !(extendsFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the parent component type that this component type extends.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtendsFrom} method.
     * </p>
     * 
     * @return The name of the parent component type that this component type extends.
     */
    public final List<String> extendsFrom() {
        return extendsFrom;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the functions in the component type. Each string in the mapping must be unique to
     * this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return An object that maps strings to the functions in the component type. Each string in the mapping must be
     *         unique to this object.
     */
    public final Map<String, FunctionResponse> functions() {
        return functions;
    }

    /**
     * <p>
     * The date and time when the component type was created.
     * </p>
     * 
     * @return The date and time when the component type was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time when the component was last updated.
     * </p>
     * 
     * @return The date and time when the component was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The ARN of the component type.
     * </p>
     * 
     * @return The ARN of the component type.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the component type is abstract.
     * </p>
     * 
     * @return A Boolean value that specifies whether the component type is abstract.
     */
    public final Boolean isAbstract() {
        return isAbstract;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the component type has a schema initializer and that the schema
     * initializer has run.
     * </p>
     * 
     * @return A Boolean value that specifies whether the component type has a schema initializer and that the schema
     *         initializer has run.
     */
    public final Boolean isSchemaInitialized() {
        return isSchemaInitialized;
    }

    /**
     * <p>
     * The current status of the component type.
     * </p>
     * 
     * @return The current status of the component type.
     */
    public final Status status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * <p>
     * Valid Range: Minimum value of 1. Maximum value of 250.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.</p>
     *         <p>
     *         Valid Range: Minimum value of 1. Maximum value of 250.
     */
    public final Map<String, PropertyGroupResponse> propertyGroups() {
        return propertyGroups;
    }

    /**
     * <p>
     * The syncSource of the SyncJob, if this entity was created by a SyncJob.
     * </p>
     * 
     * @return The syncSource of the SyncJob, if this entity was created by a SyncJob.
     */
    public final String syncSource() {
        return syncSource;
    }

    /**
     * <p>
     * The component type name.
     * </p>
     * 
     * @return The component type name.
     */
    public final String componentTypeName() {
        return componentTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeComponentTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompositeComponentTypes() {
        return compositeComponentTypes != null && !(compositeComponentTypes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>.
     * <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeComponentTypes} method.
     * </p>
     * 
     * @return This is an object that maps strings to <code>compositeComponentTypes</code> of the
     *         <code>componentType</code>. <code>CompositeComponentType</code> is referenced by
     *         <code>componentTypeId</code>.
     */
    public final Map<String, CompositeComponentTypeResponse> compositeComponentTypes() {
        return compositeComponentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyDefinitions() ? propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExtendsFrom() ? extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(isAbstract());
        hashCode = 31 * hashCode + Objects.hashCode(isSchemaInitialized());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeComponentTypes() ? compositeComponentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentTypeResponse)) {
            return false;
        }
        GetComponentTypeResponse other = (GetComponentTypeResponse) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(isSingleton(), other.isSingleton())
                && Objects.equals(componentTypeId(), other.componentTypeId())
                && Objects.equals(description(), other.description())
                && hasPropertyDefinitions() == other.hasPropertyDefinitions()
                && Objects.equals(propertyDefinitions(), other.propertyDefinitions())
                && hasExtendsFrom() == other.hasExtendsFrom() && Objects.equals(extendsFrom(), other.extendsFrom())
                && hasFunctions() == other.hasFunctions() && Objects.equals(functions(), other.functions())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(arn(), other.arn())
                && Objects.equals(isAbstract(), other.isAbstract())
                && Objects.equals(isSchemaInitialized(), other.isSchemaInitialized()) && Objects.equals(status(), other.status())
                && hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(propertyGroups(), other.propertyGroups())
                && Objects.equals(syncSource(), other.syncSource())
                && Objects.equals(componentTypeName(), other.componentTypeName())
                && hasCompositeComponentTypes() == other.hasCompositeComponentTypes()
                && Objects.equals(compositeComponentTypes(), other.compositeComponentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComponentTypeResponse").add("WorkspaceId", workspaceId()).add("IsSingleton", isSingleton())
                .add("ComponentTypeId", componentTypeId()).add("Description", description())
                .add("PropertyDefinitions", hasPropertyDefinitions() ? propertyDefinitions() : null)
                .add("ExtendsFrom", hasExtendsFrom() ? extendsFrom() : null)
                .add("Functions", hasFunctions() ? functions() : null).add("CreationDateTime", creationDateTime())
                .add("UpdateDateTime", updateDateTime()).add("Arn", arn()).add("IsAbstract", isAbstract())
                .add("IsSchemaInitialized", isSchemaInitialized()).add("Status", status())
                .add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null).add("SyncSource", syncSource())
                .add("ComponentTypeName", componentTypeName())
                .add("CompositeComponentTypes", hasCompositeComponentTypes() ? compositeComponentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "isSingleton":
            return Optional.ofNullable(clazz.cast(isSingleton()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "propertyDefinitions":
            return Optional.ofNullable(clazz.cast(propertyDefinitions()));
        case "extendsFrom":
            return Optional.ofNullable(clazz.cast(extendsFrom()));
        case "functions":
            return Optional.ofNullable(clazz.cast(functions()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "isAbstract":
            return Optional.ofNullable(clazz.cast(isAbstract()));
        case "isSchemaInitialized":
            return Optional.ofNullable(clazz.cast(isSchemaInitialized()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "propertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        case "syncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        case "componentTypeName":
            return Optional.ofNullable(clazz.cast(componentTypeName()));
        case "compositeComponentTypes":
            return Optional.ofNullable(clazz.cast(compositeComponentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentTypeResponse, T> g) {
        return obj -> g.apply((GetComponentTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetComponentTypeResponse> {
        /**
         * <p>
         * The ID of the workspace that contains the component type.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * A Boolean value that specifies whether an entity can have more than one component of this type.
         * </p>
         * 
         * @param isSingleton
         *        A Boolean value that specifies whether an entity can have more than one component of this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSingleton(Boolean isSingleton);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object that maps strings to the property definitions in the component type. Each string in the mapping
         * must be unique to this object.
         * </p>
         * 
         * @param propertyDefinitions
         *        An object that maps strings to the property definitions in the component type. Each string in the
         *        mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyDefinitions(Map<String, PropertyDefinitionResponse> propertyDefinitions);

        /**
         * <p>
         * The name of the parent component type that this component type extends.
         * </p>
         * 
         * @param extendsFrom
         *        The name of the parent component type that this component type extends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(Collection<String> extendsFrom);

        /**
         * <p>
         * The name of the parent component type that this component type extends.
         * </p>
         * 
         * @param extendsFrom
         *        The name of the parent component type that this component type extends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(String... extendsFrom);

        /**
         * <p>
         * An object that maps strings to the functions in the component type. Each string in the mapping must be unique
         * to this object.
         * </p>
         * 
         * @param functions
         *        An object that maps strings to the functions in the component type. Each string in the mapping must be
         *        unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Map<String, FunctionResponse> functions);

        /**
         * <p>
         * The date and time when the component type was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the component type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time when the component was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the component was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The ARN of the component type.
         * </p>
         * 
         * @param arn
         *        The ARN of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A Boolean value that specifies whether the component type is abstract.
         * </p>
         * 
         * @param isAbstract
         *        A Boolean value that specifies whether the component type is abstract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAbstract(Boolean isAbstract);

        /**
         * <p>
         * A Boolean value that specifies whether the component type has a schema initializer and that the schema
         * initializer has run.
         * </p>
         * 
         * @param isSchemaInitialized
         *        A Boolean value that specifies whether the component type has a schema initializer and that the schema
         *        initializer has run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSchemaInitialized(Boolean isSchemaInitialized);

        /**
         * <p>
         * The current status of the component type.
         * </p>
         * 
         * @param status
         *        The current status of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Status status);

        /**
         * <p>
         * The current status of the component type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Status.Builder} avoiding the need to
         * create one manually via {@link Status#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Status.Builder#build()} is called immediately and its result is
         * passed to {@link #status(Status)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link Status.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(Status)
         */
        default Builder status(Consumer<Status.Builder> status) {
            return status(Status.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 250.
         * </p>
         * 
         * @param propertyGroups
         *        The maximum number of results to return at one time. The default is 25.</p>
         *        <p>
         *        Valid Range: Minimum value of 1. Maximum value of 250.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Map<String, PropertyGroupResponse> propertyGroups);

        /**
         * <p>
         * The syncSource of the SyncJob, if this entity was created by a SyncJob.
         * </p>
         * 
         * @param syncSource
         *        The syncSource of the SyncJob, if this entity was created by a SyncJob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(String syncSource);

        /**
         * <p>
         * The component type name.
         * </p>
         * 
         * @param componentTypeName
         *        The component type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeName(String componentTypeName);

        /**
         * <p>
         * This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>. <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.
         * </p>
         * 
         * @param compositeComponentTypes
         *        This is an object that maps strings to <code>compositeComponentTypes</code> of the
         *        <code>componentType</code>. <code>CompositeComponentType</code> is referenced by
         *        <code>componentTypeId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeComponentTypes(Map<String, CompositeComponentTypeResponse> compositeComponentTypes);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String workspaceId;

        private Boolean isSingleton;

        private String componentTypeId;

        private String description;

        private Map<String, PropertyDefinitionResponse> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FunctionResponse> functions = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationDateTime;

        private Instant updateDateTime;

        private String arn;

        private Boolean isAbstract;

        private Boolean isSchemaInitialized;

        private Status status;

        private Map<String, PropertyGroupResponse> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private String syncSource;

        private String componentTypeName;

        private Map<String, CompositeComponentTypeResponse> compositeComponentTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentTypeResponse model) {
            super(model);
            workspaceId(model.workspaceId);
            isSingleton(model.isSingleton);
            componentTypeId(model.componentTypeId);
            description(model.description);
            propertyDefinitions(model.propertyDefinitions);
            extendsFrom(model.extendsFrom);
            functions(model.functions);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
            arn(model.arn);
            isAbstract(model.isAbstract);
            isSchemaInitialized(model.isSchemaInitialized);
            status(model.status);
            propertyGroups(model.propertyGroups);
            syncSource(model.syncSource);
            componentTypeName(model.componentTypeName);
            compositeComponentTypes(model.compositeComponentTypes);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Boolean getIsSingleton() {
            return isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyDefinitionResponse.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionResponse.Builder> result = PropertyDefinitionsResponseCopier
                    .copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionResponse.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsResponseCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionResponse> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsResponseCopier.copy(propertyDefinitions);
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendsFrom(String... extendsFrom) {
            extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionResponse.Builder> getFunctions() {
            Map<String, FunctionResponse.Builder> result = FunctionsResponseCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionResponse.BuilderImpl> functions) {
            this.functions = FunctionsResponseCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Map<String, FunctionResponse> functions) {
            this.functions = FunctionsResponseCopier.copy(functions);
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getIsAbstract() {
            return isAbstract;
        }

        public final void setIsAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
        }

        @Override
        public final Builder isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public final Boolean getIsSchemaInitialized() {
            return isSchemaInitialized;
        }

        public final void setIsSchemaInitialized(Boolean isSchemaInitialized) {
            this.isSchemaInitialized = isSchemaInitialized;
        }

        @Override
        public final Builder isSchemaInitialized(Boolean isSchemaInitialized) {
            this.isSchemaInitialized = isSchemaInitialized;
            return this;
        }

        public final Status.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final Map<String, PropertyGroupResponse.Builder> getPropertyGroups() {
            Map<String, PropertyGroupResponse.Builder> result = PropertyGroupsResponseCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, PropertyGroupResponse.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsResponseCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, PropertyGroupResponse> propertyGroups) {
            this.propertyGroups = PropertyGroupsResponseCopier.copy(propertyGroups);
            return this;
        }

        public final String getSyncSource() {
            return syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getComponentTypeName() {
            return componentTypeName;
        }

        public final void setComponentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final Builder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            return this;
        }

        public final Map<String, CompositeComponentTypeResponse.Builder> getCompositeComponentTypes() {
            Map<String, CompositeComponentTypeResponse.Builder> result = CompositeComponentTypesResponseCopier
                    .copyToBuilder(this.compositeComponentTypes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponentTypes(
                Map<String, CompositeComponentTypeResponse.BuilderImpl> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesResponseCopier.copyFromBuilder(compositeComponentTypes);
        }

        @Override
        public final Builder compositeComponentTypes(Map<String, CompositeComponentTypeResponse> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesResponseCopier.copy(compositeComponentTypes);
            return this;
        }

        @Override
        public GetComponentTypeResponse build() {
            return new GetComponentTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
