/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that returns information about a component type create or update request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentResponse.Builder, ComponentResponse> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(ComponentResponse::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ComponentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(ComponentResponse::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<Status> STATUS_FIELD = SdkField.<Status> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(ComponentResponse::status)).setter(setter(Builder::status)).constructor(Status::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DEFINED_IN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definedIn").getter(getter(ComponentResponse::definedIn)).setter(setter(Builder::definedIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definedIn").build()).build();

    private static final SdkField<Map<String, PropertyResponse>> PROPERTIES_FIELD = SdkField
            .<Map<String, PropertyResponse>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(ComponentResponse::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentPropertyGroupResponse>> PROPERTY_GROUPS_FIELD = SdkField
            .<Map<String, ComponentPropertyGroupResponse>> builder(MarshallingType.MAP)
            .memberName("propertyGroups")
            .getter(getter(ComponentResponse::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentPropertyGroupResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentPropertyGroupResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSource").getter(getter(ComponentResponse::syncSource)).setter(setter(Builder::syncSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()).build();

    private static final SdkField<Boolean> ARE_ALL_PROPERTIES_RETURNED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("areAllPropertiesReturned")
            .getter(getter(ComponentResponse::areAllPropertiesReturned)).setter(setter(Builder::areAllPropertiesReturned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllPropertiesReturned").build())
            .build();

    private static final SdkField<Map<String, ComponentSummary>> COMPOSITE_COMPONENTS_FIELD = SdkField
            .<Map<String, ComponentSummary>> builder(MarshallingType.MAP)
            .memberName("compositeComponents")
            .getter(getter(ComponentResponse::compositeComponents))
            .setter(setter(Builder::compositeComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponents").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ARE_ALL_COMPOSITE_COMPONENTS_RETURNED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("areAllCompositeComponentsReturned")
            .getter(getter(ComponentResponse::areAllCompositeComponentsReturned))
            .setter(setter(Builder::areAllCompositeComponentsReturned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllCompositeComponentsReturned")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            DESCRIPTION_FIELD, COMPONENT_TYPE_ID_FIELD, STATUS_FIELD, DEFINED_IN_FIELD, PROPERTIES_FIELD, PROPERTY_GROUPS_FIELD,
            SYNC_SOURCE_FIELD, ARE_ALL_PROPERTIES_RETURNED_FIELD, COMPOSITE_COMPONENTS_FIELD,
            ARE_ALL_COMPOSITE_COMPONENTS_RETURNED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String description;

    private final String componentTypeId;

    private final Status status;

    private final String definedIn;

    private final Map<String, PropertyResponse> properties;

    private final Map<String, ComponentPropertyGroupResponse> propertyGroups;

    private final String syncSource;

    private final Boolean areAllPropertiesReturned;

    private final Map<String, ComponentSummary> compositeComponents;

    private final Boolean areAllCompositeComponentsReturned;

    private ComponentResponse(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.description = builder.description;
        this.componentTypeId = builder.componentTypeId;
        this.status = builder.status;
        this.definedIn = builder.definedIn;
        this.properties = builder.properties;
        this.propertyGroups = builder.propertyGroups;
        this.syncSource = builder.syncSource;
        this.areAllPropertiesReturned = builder.areAllPropertiesReturned;
        this.compositeComponents = builder.compositeComponents;
        this.areAllCompositeComponentsReturned = builder.areAllCompositeComponentsReturned;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The status of the component type.
     * </p>
     * 
     * @return The status of the component type.
     */
    public final Status status() {
        return status;
    }

    /**
     * <p>
     * The name of the property definition set in the request.
     * </p>
     * 
     * @return The name of the property definition set in the request.
     */
    public final String definedIn() {
        return definedIn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the properties to set in the component type. Each string in the mapping must be
     * unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return An object that maps strings to the properties to set in the component type. Each string in the mapping
     *         must be unique to this object.
     */
    public final Map<String, PropertyResponse> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The property groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return The property groups.
     */
    public final Map<String, ComponentPropertyGroupResponse> propertyGroups() {
        return propertyGroups;
    }

    /**
     * <p>
     * The syncSource of the sync job, if this entity was created by a sync job.
     * </p>
     * 
     * @return The syncSource of the sync job, if this entity was created by a sync job.
     */
    public final String syncSource() {
        return syncSource;
    }

    /**
     * <p>
     * This flag notes whether all properties of the component are returned in the API response. The maximum number of
     * properties returned is 800.
     * </p>
     * 
     * @return This flag notes whether all properties of the component are returned in the API response. The maximum
     *         number of properties returned is 800.
     */
    public final Boolean areAllPropertiesReturned() {
        return areAllPropertiesReturned;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeComponents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompositeComponents() {
        return compositeComponents != null && !(compositeComponents instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This lists objects that contain information about the <code>compositeComponents</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeComponents} method.
     * </p>
     * 
     * @return This lists objects that contain information about the <code>compositeComponents</code>.
     */
    public final Map<String, ComponentSummary> compositeComponents() {
        return compositeComponents;
    }

    /**
     * <p>
     * This flag notes whether all <code>compositeComponents</code> are returned in the API response.
     * </p>
     * 
     * @return This flag notes whether all <code>compositeComponents</code> are returned in the API response.
     */
    public final Boolean areAllCompositeComponentsReturned() {
        return areAllCompositeComponentsReturned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(definedIn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(areAllPropertiesReturned());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeComponents() ? compositeComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(areAllCompositeComponentsReturned());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentResponse)) {
            return false;
        }
        ComponentResponse other = (ComponentResponse) obj;
        return Objects.equals(componentName(), other.componentName()) && Objects.equals(description(), other.description())
                && Objects.equals(componentTypeId(), other.componentTypeId()) && Objects.equals(status(), other.status())
                && Objects.equals(definedIn(), other.definedIn()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && hasPropertyGroups() == other.hasPropertyGroups()
                && Objects.equals(propertyGroups(), other.propertyGroups()) && Objects.equals(syncSource(), other.syncSource())
                && Objects.equals(areAllPropertiesReturned(), other.areAllPropertiesReturned())
                && hasCompositeComponents() == other.hasCompositeComponents()
                && Objects.equals(compositeComponents(), other.compositeComponents())
                && Objects.equals(areAllCompositeComponentsReturned(), other.areAllCompositeComponentsReturned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentResponse").add("ComponentName", componentName()).add("Description", description())
                .add("ComponentTypeId", componentTypeId()).add("Status", status()).add("DefinedIn", definedIn())
                .add("Properties", hasProperties() ? properties() : null)
                .add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null).add("SyncSource", syncSource())
                .add("AreAllPropertiesReturned", areAllPropertiesReturned())
                .add("CompositeComponents", hasCompositeComponents() ? compositeComponents() : null)
                .add("AreAllCompositeComponentsReturned", areAllCompositeComponentsReturned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "definedIn":
            return Optional.ofNullable(clazz.cast(definedIn()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "propertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        case "syncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        case "areAllPropertiesReturned":
            return Optional.ofNullable(clazz.cast(areAllPropertiesReturned()));
        case "compositeComponents":
            return Optional.ofNullable(clazz.cast(compositeComponents()));
        case "areAllCompositeComponentsReturned":
            return Optional.ofNullable(clazz.cast(areAllCompositeComponentsReturned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentResponse, T> g) {
        return obj -> g.apply((ComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentResponse> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The status of the component type.
         * </p>
         * 
         * @param status
         *        The status of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Status status);

        /**
         * <p>
         * The status of the component type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Status.Builder} avoiding the need to
         * create one manually via {@link Status#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Status.Builder#build()} is called immediately and its result is
         * passed to {@link #status(Status)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link Status.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(Status)
         */
        default Builder status(Consumer<Status.Builder> status) {
            return status(Status.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The name of the property definition set in the request.
         * </p>
         * 
         * @param definedIn
         *        The name of the property definition set in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definedIn(String definedIn);

        /**
         * <p>
         * An object that maps strings to the properties to set in the component type. Each string in the mapping must
         * be unique to this object.
         * </p>
         * 
         * @param properties
         *        An object that maps strings to the properties to set in the component type. Each string in the mapping
         *        must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, PropertyResponse> properties);

        /**
         * <p>
         * The property groups.
         * </p>
         * 
         * @param propertyGroups
         *        The property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups);

        /**
         * <p>
         * The syncSource of the sync job, if this entity was created by a sync job.
         * </p>
         * 
         * @param syncSource
         *        The syncSource of the sync job, if this entity was created by a sync job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(String syncSource);

        /**
         * <p>
         * This flag notes whether all properties of the component are returned in the API response. The maximum number
         * of properties returned is 800.
         * </p>
         * 
         * @param areAllPropertiesReturned
         *        This flag notes whether all properties of the component are returned in the API response. The maximum
         *        number of properties returned is 800.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areAllPropertiesReturned(Boolean areAllPropertiesReturned);

        /**
         * <p>
         * This lists objects that contain information about the <code>compositeComponents</code>.
         * </p>
         * 
         * @param compositeComponents
         *        This lists objects that contain information about the <code>compositeComponents</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeComponents(Map<String, ComponentSummary> compositeComponents);

        /**
         * <p>
         * This flag notes whether all <code>compositeComponents</code> are returned in the API response.
         * </p>
         * 
         * @param areAllCompositeComponentsReturned
         *        This flag notes whether all <code>compositeComponents</code> are returned in the API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areAllCompositeComponentsReturned(Boolean areAllCompositeComponentsReturned);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String description;

        private String componentTypeId;

        private Status status;

        private String definedIn;

        private Map<String, PropertyResponse> properties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ComponentPropertyGroupResponse> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private String syncSource;

        private Boolean areAllPropertiesReturned;

        private Map<String, ComponentSummary> compositeComponents = DefaultSdkAutoConstructMap.getInstance();

        private Boolean areAllCompositeComponentsReturned;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentResponse model) {
            componentName(model.componentName);
            description(model.description);
            componentTypeId(model.componentTypeId);
            status(model.status);
            definedIn(model.definedIn);
            properties(model.properties);
            propertyGroups(model.propertyGroups);
            syncSource(model.syncSource);
            areAllPropertiesReturned(model.areAllPropertiesReturned);
            compositeComponents(model.compositeComponents);
            areAllCompositeComponentsReturned(model.areAllCompositeComponentsReturned);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Status.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getDefinedIn() {
            return definedIn;
        }

        public final void setDefinedIn(String definedIn) {
            this.definedIn = definedIn;
        }

        @Override
        public final Builder definedIn(String definedIn) {
            this.definedIn = definedIn;
            return this;
        }

        public final Map<String, PropertyResponse.Builder> getProperties() {
            Map<String, PropertyResponse.Builder> result = PropertyResponsesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, PropertyResponse.BuilderImpl> properties) {
            this.properties = PropertyResponsesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, PropertyResponse> properties) {
            this.properties = PropertyResponsesCopier.copy(properties);
            return this;
        }

        public final Map<String, ComponentPropertyGroupResponse.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupResponse.Builder> result = ComponentPropertyGroupResponsesCopier
                    .copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupResponse.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copy(propertyGroups);
            return this;
        }

        public final String getSyncSource() {
            return syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final Boolean getAreAllPropertiesReturned() {
            return areAllPropertiesReturned;
        }

        public final void setAreAllPropertiesReturned(Boolean areAllPropertiesReturned) {
            this.areAllPropertiesReturned = areAllPropertiesReturned;
        }

        @Override
        public final Builder areAllPropertiesReturned(Boolean areAllPropertiesReturned) {
            this.areAllPropertiesReturned = areAllPropertiesReturned;
            return this;
        }

        public final Map<String, ComponentSummary.Builder> getCompositeComponents() {
            Map<String, ComponentSummary.Builder> result = CompositeComponentResponseCopier
                    .copyToBuilder(this.compositeComponents);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponents(Map<String, ComponentSummary.BuilderImpl> compositeComponents) {
            this.compositeComponents = CompositeComponentResponseCopier.copyFromBuilder(compositeComponents);
        }

        @Override
        public final Builder compositeComponents(Map<String, ComponentSummary> compositeComponents) {
            this.compositeComponents = CompositeComponentResponseCopier.copy(compositeComponents);
            return this;
        }

        public final Boolean getAreAllCompositeComponentsReturned() {
            return areAllCompositeComponentsReturned;
        }

        public final void setAreAllCompositeComponentsReturned(Boolean areAllCompositeComponentsReturned) {
            this.areAllCompositeComponentsReturned = areAllCompositeComponentsReturned;
        }

        @Override
        public final Builder areAllCompositeComponentsReturned(Boolean areAllCompositeComponentsReturned) {
            this.areAllCompositeComponentsReturned = areAllCompositeComponentsReturned;
            return this;
        }

        @Override
        public ComponentResponse build() {
            return new ComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
