/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is an object that contains the information of a property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertySummary implements SdkPojo, Serializable, ToCopyableBuilder<PropertySummary.Builder, PropertySummary> {
    private static final SdkField<PropertyDefinitionResponse> DEFINITION_FIELD = SdkField
            .<PropertyDefinitionResponse> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(PropertySummary::definition)).setter(setter(Builder::definition))
            .constructor(PropertyDefinitionResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyName").getter(getter(PropertySummary::propertyName)).setter(setter(Builder::propertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyName").build()).build();

    private static final SdkField<DataValue> VALUE_FIELD = SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(PropertySummary::value)).setter(setter(Builder::value))
            .constructor(DataValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<Boolean> ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("areAllPropertyValuesReturned")
            .getter(getter(PropertySummary::areAllPropertyValuesReturned))
            .setter(setter(Builder::areAllPropertyValuesReturned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllPropertyValuesReturned")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            PROPERTY_NAME_FIELD, VALUE_FIELD, ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD));

    private static final long serialVersionUID = 1L;

    private final PropertyDefinitionResponse definition;

    private final String propertyName;

    private final DataValue value;

    private final Boolean areAllPropertyValuesReturned;

    private PropertySummary(BuilderImpl builder) {
        this.definition = builder.definition;
        this.propertyName = builder.propertyName;
        this.value = builder.value;
        this.areAllPropertyValuesReturned = builder.areAllPropertyValuesReturned;
    }

    /**
     * <p>
     * This is the schema for the property.
     * </p>
     * 
     * @return This is the schema for the property.
     */
    public final PropertyDefinitionResponse definition() {
        return definition;
    }

    /**
     * <p>
     * This is the name of the property.
     * </p>
     * 
     * @return This is the name of the property.
     */
    public final String propertyName() {
        return propertyName;
    }

    /**
     * <p>
     * This is the value for the property.
     * </p>
     * 
     * @return This is the value for the property.
     */
    public final DataValue value() {
        return value;
    }

    /**
     * <p>
     * This flag notes whether all values of a list or map type property are returned in the API response. The maximum
     * number of values per property returned is 50.
     * </p>
     * 
     * @return This flag notes whether all values of a list or map type property are returned in the API response. The
     *         maximum number of values per property returned is 50.
     */
    public final Boolean areAllPropertyValuesReturned() {
        return areAllPropertyValuesReturned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(areAllPropertyValuesReturned());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertySummary)) {
            return false;
        }
        PropertySummary other = (PropertySummary) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(propertyName(), other.propertyName())
                && Objects.equals(value(), other.value())
                && Objects.equals(areAllPropertyValuesReturned(), other.areAllPropertyValuesReturned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertySummary").add("Definition", definition()).add("PropertyName", propertyName())
                .add("Value", value()).add("AreAllPropertyValuesReturned", areAllPropertyValuesReturned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "propertyName":
            return Optional.ofNullable(clazz.cast(propertyName()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "areAllPropertyValuesReturned":
            return Optional.ofNullable(clazz.cast(areAllPropertyValuesReturned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertySummary, T> g) {
        return obj -> g.apply((PropertySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertySummary> {
        /**
         * <p>
         * This is the schema for the property.
         * </p>
         * 
         * @param definition
         *        This is the schema for the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(PropertyDefinitionResponse definition);

        /**
         * <p>
         * This is the schema for the property.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyDefinitionResponse.Builder}
         * avoiding the need to create one manually via {@link PropertyDefinitionResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyDefinitionResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(PropertyDefinitionResponse)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link PropertyDefinitionResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(PropertyDefinitionResponse)
         */
        default Builder definition(Consumer<PropertyDefinitionResponse.Builder> definition) {
            return definition(PropertyDefinitionResponse.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * This is the name of the property.
         * </p>
         * 
         * @param propertyName
         *        This is the name of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyName(String propertyName);

        /**
         * <p>
         * This is the value for the property.
         * </p>
         * 
         * @param value
         *        This is the value for the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DataValue value);

        /**
         * <p>
         * This is the value for the property.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataValue.Builder} avoiding the need to
         * create one manually via {@link DataValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(DataValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DataValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DataValue)
         */
        default Builder value(Consumer<DataValue.Builder> value) {
            return value(DataValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * This flag notes whether all values of a list or map type property are returned in the API response. The
         * maximum number of values per property returned is 50.
         * </p>
         * 
         * @param areAllPropertyValuesReturned
         *        This flag notes whether all values of a list or map type property are returned in the API response.
         *        The maximum number of values per property returned is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned);
    }

    static final class BuilderImpl implements Builder {
        private PropertyDefinitionResponse definition;

        private String propertyName;

        private DataValue value;

        private Boolean areAllPropertyValuesReturned;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertySummary model) {
            definition(model.definition);
            propertyName(model.propertyName);
            value(model.value);
            areAllPropertyValuesReturned(model.areAllPropertyValuesReturned);
        }

        public final PropertyDefinitionResponse.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(PropertyDefinitionResponse.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PropertyDefinitionResponse definition) {
            this.definition = definition;
            return this;
        }

        public final String getPropertyName() {
            return propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final DataValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        public final Boolean getAreAllPropertyValuesReturned() {
            return areAllPropertyValuesReturned;
        }

        public final void setAreAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned) {
            this.areAllPropertyValuesReturned = areAllPropertyValuesReturned;
        }

        @Override
        public final Builder areAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned) {
            this.areAllPropertyValuesReturned = areAllPropertyValuesReturned;
            return this;
        }

        @Override
        public PropertySummary build() {
            return new PropertySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
