/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConfiguration.Builder, SourceConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SourceConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<S3SourceConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Configuration")
            .getter(getter(SourceConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()).build();

    private static final SdkField<IotSiteWiseSourceConfiguration> IOT_SITE_WISE_CONFIGURATION_FIELD = SdkField
            .<IotSiteWiseSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("iotSiteWiseConfiguration")
            .getter(getter(SourceConfiguration::iotSiteWiseConfiguration)).setter(setter(Builder::iotSiteWiseConfiguration))
            .constructor(IotSiteWiseSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseConfiguration").build())
            .build();

    private static final SdkField<IotTwinMakerSourceConfiguration> IOT_TWIN_MAKER_CONFIGURATION_FIELD = SdkField
            .<IotTwinMakerSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("iotTwinMakerConfiguration")
            .getter(getter(SourceConfiguration::iotTwinMakerConfiguration)).setter(setter(Builder::iotTwinMakerConfiguration))
            .constructor(IotTwinMakerSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotTwinMakerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            S3_CONFIGURATION_FIELD, IOT_SITE_WISE_CONFIGURATION_FIELD, IOT_TWIN_MAKER_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final S3SourceConfiguration s3Configuration;

    private final IotSiteWiseSourceConfiguration iotSiteWiseConfiguration;

    private final IotTwinMakerSourceConfiguration iotTwinMakerConfiguration;

    private SourceConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Configuration = builder.s3Configuration;
        this.iotSiteWiseConfiguration = builder.iotSiteWiseConfiguration;
        this.iotTwinMakerConfiguration = builder.iotTwinMakerConfiguration;
    }

    /**
     * <p>
     * The source configuration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The source configuration type.
     * @see SourceType
     */
    public final SourceType type() {
        return SourceType.fromValue(type);
    }

    /**
     * <p>
     * The source configuration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The source configuration type.
     * @see SourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The source configuration S3 configuration.
     * </p>
     * 
     * @return The source configuration S3 configuration.
     */
    public final S3SourceConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The source configuration IoT SiteWise configuration.
     * </p>
     * 
     * @return The source configuration IoT SiteWise configuration.
     */
    public final IotSiteWiseSourceConfiguration iotSiteWiseConfiguration() {
        return iotSiteWiseConfiguration;
    }

    /**
     * <p>
     * The source configuration IoT TwinMaker configuration.
     * </p>
     * 
     * @return The source configuration IoT TwinMaker configuration.
     */
    public final IotTwinMakerSourceConfiguration iotTwinMakerConfiguration() {
        return iotTwinMakerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWiseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(iotTwinMakerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfiguration)) {
            return false;
        }
        SourceConfiguration other = (SourceConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(iotSiteWiseConfiguration(), other.iotSiteWiseConfiguration())
                && Objects.equals(iotTwinMakerConfiguration(), other.iotTwinMakerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConfiguration").add("Type", typeAsString()).add("S3Configuration", s3Configuration())
                .add("IotSiteWiseConfiguration", iotSiteWiseConfiguration())
                .add("IotTwinMakerConfiguration", iotTwinMakerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "s3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "iotSiteWiseConfiguration":
            return Optional.ofNullable(clazz.cast(iotSiteWiseConfiguration()));
        case "iotTwinMakerConfiguration":
            return Optional.ofNullable(clazz.cast(iotTwinMakerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceConfiguration, T> g) {
        return obj -> g.apply((SourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConfiguration> {
        /**
         * <p>
         * The source configuration type.
         * </p>
         * 
         * @param type
         *        The source configuration type.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The source configuration type.
         * </p>
         * 
         * @param type
         *        The source configuration type.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder type(SourceType type);

        /**
         * <p>
         * The source configuration S3 configuration.
         * </p>
         * 
         * @param s3Configuration
         *        The source configuration S3 configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3SourceConfiguration s3Configuration);

        /**
         * <p>
         * The source configuration S3 configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3SourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Configuration(S3SourceConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3SourceConfiguration)
         */
        default Builder s3Configuration(Consumer<S3SourceConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3SourceConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * The source configuration IoT SiteWise configuration.
         * </p>
         * 
         * @param iotSiteWiseConfiguration
         *        The source configuration IoT SiteWise configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration iotSiteWiseConfiguration);

        /**
         * <p>
         * The source configuration IoT SiteWise configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IotSiteWiseSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link IotSiteWiseSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotSiteWiseSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration)}.
         * 
         * @param iotSiteWiseConfiguration
         *        a consumer that will call methods on {@link IotSiteWiseSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration)
         */
        default Builder iotSiteWiseConfiguration(Consumer<IotSiteWiseSourceConfiguration.Builder> iotSiteWiseConfiguration) {
            return iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration.builder().applyMutation(iotSiteWiseConfiguration)
                    .build());
        }

        /**
         * <p>
         * The source configuration IoT TwinMaker configuration.
         * </p>
         * 
         * @param iotTwinMakerConfiguration
         *        The source configuration IoT TwinMaker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration iotTwinMakerConfiguration);

        /**
         * <p>
         * The source configuration IoT TwinMaker configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IotTwinMakerSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link IotTwinMakerSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotTwinMakerSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration)}.
         * 
         * @param iotTwinMakerConfiguration
         *        a consumer that will call methods on {@link IotTwinMakerSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration)
         */
        default Builder iotTwinMakerConfiguration(Consumer<IotTwinMakerSourceConfiguration.Builder> iotTwinMakerConfiguration) {
            return iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration.builder().applyMutation(iotTwinMakerConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private S3SourceConfiguration s3Configuration;

        private IotSiteWiseSourceConfiguration iotSiteWiseConfiguration;

        private IotTwinMakerSourceConfiguration iotTwinMakerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConfiguration model) {
            type(model.type);
            s3Configuration(model.s3Configuration);
            iotSiteWiseConfiguration(model.iotSiteWiseConfiguration);
            iotTwinMakerConfiguration(model.iotTwinMakerConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3SourceConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3SourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3SourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final IotSiteWiseSourceConfiguration.Builder getIotSiteWiseConfiguration() {
            return iotSiteWiseConfiguration != null ? iotSiteWiseConfiguration.toBuilder() : null;
        }

        public final void setIotSiteWiseConfiguration(IotSiteWiseSourceConfiguration.BuilderImpl iotSiteWiseConfiguration) {
            this.iotSiteWiseConfiguration = iotSiteWiseConfiguration != null ? iotSiteWiseConfiguration.build() : null;
        }

        @Override
        public final Builder iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration iotSiteWiseConfiguration) {
            this.iotSiteWiseConfiguration = iotSiteWiseConfiguration;
            return this;
        }

        public final IotTwinMakerSourceConfiguration.Builder getIotTwinMakerConfiguration() {
            return iotTwinMakerConfiguration != null ? iotTwinMakerConfiguration.toBuilder() : null;
        }

        public final void setIotTwinMakerConfiguration(IotTwinMakerSourceConfiguration.BuilderImpl iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration != null ? iotTwinMakerConfiguration.build() : null;
        }

        @Override
        public final Builder iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration;
            return this;
        }

        @Override
        public SourceConfiguration build() {
            return new SourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
