/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.iottwinmaker.internal.IoTTwinMakerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iottwinmaker.model.AccessDeniedException;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CancelMetadataTransferJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CancelMetadataTransferJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ConflictException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorFailureException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateMetadataTransferJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateMetadataTransferJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetMetadataTransferJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetMetadataTransferJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.InternalServerException;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerException;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.QueryTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iottwinmaker.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ThrottlingException;
import software.amazon.awssdk.services.iottwinmaker.model.TooManyTagsException;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ValidationException;
import software.amazon.awssdk.services.iottwinmaker.transform.BatchPutPropertyValuesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CancelMetadataTransferJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateMetadataTransferJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ExecuteQueryRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetMetadataTransferJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPricingPlanRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListComponentTypesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListMetadataTransferJobsRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListPropertiesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListScenesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListSyncResourcesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateWorkspaceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IoTTwinMakerAsyncClient}.
 *
 * @see IoTTwinMakerAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTTwinMakerAsyncClient implements IoTTwinMakerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIoTTwinMakerAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTTwinMakerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Sets values for multiple time series properties.
     * </p>
     *
     * @param batchPutPropertyValuesRequest
     * @return A Java Future containing the result of the BatchPutPropertyValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.BatchPutPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchPutPropertyValuesResponse> batchPutPropertyValues(
            BatchPutPropertyValuesRequest batchPutPropertyValuesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutPropertyValuesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutPropertyValuesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutPropertyValues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchPutPropertyValuesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchPutPropertyValuesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<BatchPutPropertyValuesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchPutPropertyValuesRequest, BatchPutPropertyValuesResponse>()
                            .withOperationName("BatchPutPropertyValues").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchPutPropertyValuesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchPutPropertyValuesRequest));
            CompletableFuture<BatchPutPropertyValuesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the metadata transfer job.
     * </p>
     *
     * @param cancelMetadataTransferJobRequest
     * @return A Java Future containing the result of the CancelMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CancelMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CancelMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMetadataTransferJobResponse> cancelMetadataTransferJob(
            CancelMetadataTransferJobRequest cancelMetadataTransferJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMetadataTransferJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMetadataTransferJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMetadataTransferJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMetadataTransferJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMetadataTransferJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CancelMetadataTransferJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMetadataTransferJobRequest, CancelMetadataTransferJobResponse>()
                            .withOperationName("CancelMetadataTransferJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMetadataTransferJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(cancelMetadataTransferJobRequest));
            CompletableFuture<CancelMetadataTransferJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a component type.
     * </p>
     *
     * @param createComponentTypeRequest
     * @return A Java Future containing the result of the CreateComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateComponentTypeResponse> createComponentType(
            CreateComponentTypeRequest createComponentTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComponentTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponentType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateComponentTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateComponentTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateComponentTypeRequest, CreateComponentTypeResponse>()
                            .withOperationName("CreateComponentType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateComponentTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createComponentTypeRequest));
            CompletableFuture<CreateComponentTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an entity.
     * </p>
     *
     * @param createEntityRequest
     * @return A Java Future containing the result of the CreateEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEntityResponse> createEntity(CreateEntityRequest createEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateEntityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEntityRequest, CreateEntityResponse>()
                            .withOperationName("CreateEntity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEntityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createEntityRequest));
            CompletableFuture<CreateEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new metadata transfer job.
     * </p>
     *
     * @param createMetadataTransferJobRequest
     * @return A Java Future containing the result of the CreateMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMetadataTransferJobResponse> createMetadataTransferJob(
            CreateMetadataTransferJobRequest createMetadataTransferJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMetadataTransferJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMetadataTransferJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMetadataTransferJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMetadataTransferJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMetadataTransferJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateMetadataTransferJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMetadataTransferJobRequest, CreateMetadataTransferJobResponse>()
                            .withOperationName("CreateMetadataTransferJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMetadataTransferJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createMetadataTransferJobRequest));
            CompletableFuture<CreateMetadataTransferJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a scene.
     * </p>
     *
     * @param createSceneRequest
     * @return A Java Future containing the result of the CreateScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSceneResponse> createScene(CreateSceneRequest createSceneRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSceneRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScene");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSceneResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateSceneResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSceneRequest, CreateSceneResponse>()
                            .withOperationName("CreateScene").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSceneRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createSceneRequest));
            CompletableFuture<CreateSceneResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action creates a SyncJob.
     * </p>
     *
     * @param createSyncJobRequest
     * @return A Java Future containing the result of the CreateSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSyncJobResponse> createSyncJob(CreateSyncJobRequest createSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSyncJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSyncJobRequest, CreateSyncJobResponse>()
                            .withOperationName("CreateSyncJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createSyncJobRequest));
            CompletableFuture<CreateSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a workplace.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkspaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateWorkspaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkspaceRequest, CreateWorkspaceResponse>()
                            .withOperationName("CreateWorkspace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkspaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createWorkspaceRequest));
            CompletableFuture<CreateWorkspaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a component type.
     * </p>
     *
     * @param deleteComponentTypeRequest
     * @return A Java Future containing the result of the DeleteComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteComponentTypeResponse> deleteComponentType(
            DeleteComponentTypeRequest deleteComponentTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteComponentTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponentType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteComponentTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteComponentTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteComponentTypeRequest, DeleteComponentTypeResponse>()
                            .withOperationName("DeleteComponentType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteComponentTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteComponentTypeRequest));
            CompletableFuture<DeleteComponentTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an entity.
     * </p>
     *
     * @param deleteEntityRequest
     * @return A Java Future containing the result of the DeleteEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEntityResponse> deleteEntity(DeleteEntityRequest deleteEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteEntityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEntityRequest, DeleteEntityResponse>()
                            .withOperationName("DeleteEntity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEntityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteEntityRequest));
            CompletableFuture<DeleteEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a scene.
     * </p>
     *
     * @param deleteSceneRequest
     * @return A Java Future containing the result of the DeleteScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSceneResponse> deleteScene(DeleteSceneRequest deleteSceneRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSceneRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScene");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSceneResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteSceneResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSceneRequest, DeleteSceneResponse>()
                            .withOperationName("DeleteScene").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSceneRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteSceneRequest));
            CompletableFuture<DeleteSceneResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the SyncJob.
     * </p>
     *
     * @param deleteSyncJobRequest
     * @return A Java Future containing the result of the DeleteSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSyncJobResponse> deleteSyncJob(DeleteSyncJobRequest deleteSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSyncJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSyncJobRequest, DeleteSyncJobResponse>()
                            .withOperationName("DeleteSyncJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteSyncJobRequest));
            CompletableFuture<DeleteSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkspace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkspaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteWorkspaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkspaceRequest, DeleteWorkspaceResponse>()
                            .withOperationName("DeleteWorkspace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkspaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteWorkspaceRequest));
            CompletableFuture<DeleteWorkspaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     * <note>
     * <p>
     * The ExecuteQuery action only works with <a
     * href="https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/home.html">Amazon Web Services Java
     * SDK2</a>. ExecuteQuery will not work with any Amazon Web Services Java SDK version &lt; 2.x.
     * </p>
     * </note>
     *
     * @param executeQueryRequest
     * @return A Java Future containing the result of the ExecuteQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>QueryTimeoutException The query timeout exception.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteQueryResponse> executeQuery(ExecuteQueryRequest executeQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExecuteQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ExecuteQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ExecuteQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteQueryRequest, ExecuteQueryResponse>()
                            .withOperationName("ExecuteQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(executeQueryRequest));
            CompletableFuture<ExecuteQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a component type.
     * </p>
     *
     * @param getComponentTypeRequest
     * @return A Java Future containing the result of the GetComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComponentTypeResponse> getComponentType(GetComponentTypeRequest getComponentTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComponentTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponentType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetComponentTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetComponentTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComponentTypeRequest, GetComponentTypeResponse>()
                            .withOperationName("GetComponentType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetComponentTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getComponentTypeRequest));
            CompletableFuture<GetComponentTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an entity.
     * </p>
     *
     * @param getEntityRequest
     * @return A Java Future containing the result of the GetEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEntityResponse> getEntity(GetEntityRequest getEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEntityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEntityRequest, GetEntityResponse>().withOperationName("GetEntity")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEntityRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getEntityRequest));
            CompletableFuture<GetEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a nmetadata transfer job.
     * </p>
     *
     * @param getMetadataTransferJobRequest
     * @return A Java Future containing the result of the GetMetadataTransferJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetMetadataTransferJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetMetadataTransferJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMetadataTransferJobResponse> getMetadataTransferJob(
            GetMetadataTransferJobRequest getMetadataTransferJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMetadataTransferJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMetadataTransferJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMetadataTransferJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMetadataTransferJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMetadataTransferJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetMetadataTransferJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMetadataTransferJobRequest, GetMetadataTransferJobResponse>()
                            .withOperationName("GetMetadataTransferJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMetadataTransferJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getMetadataTransferJobRequest));
            CompletableFuture<GetMetadataTransferJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the pricing plan.
     * </p>
     *
     * @param getPricingPlanRequest
     * @return A Java Future containing the result of the GetPricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPricingPlanResponse> getPricingPlan(GetPricingPlanRequest getPricingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPricingPlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPricingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPricingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetPricingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPricingPlanRequest, GetPricingPlanResponse>()
                            .withOperationName("GetPricingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPricingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getPricingPlanRequest));
            CompletableFuture<GetPricingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     *
     * @param getPropertyValueRequest
     * @return A Java Future containing the result of the GetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPropertyValueResponse> getPropertyValue(GetPropertyValueRequest getPropertyValueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPropertyValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertyValue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPropertyValueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<GetPropertyValueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPropertyValueRequest, GetPropertyValueResponse>()
                            .withOperationName("GetPropertyValue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPropertyValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getPropertyValueRequest));
            CompletableFuture<GetPropertyValueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     * @return A Java Future containing the result of the GetPropertyValueHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ConnectorFailureException The connector failed.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConnectorTimeoutException The connector timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPropertyValueHistoryResponse> getPropertyValueHistory(
            GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPropertyValueHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertyValueHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertyValueHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPropertyValueHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPropertyValueHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<GetPropertyValueHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPropertyValueHistoryRequest, GetPropertyValueHistoryResponse>()
                            .withOperationName("GetPropertyValueHistory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPropertyValueHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getPropertyValueHistoryRequest));
            CompletableFuture<GetPropertyValueHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a scene.
     * </p>
     *
     * @param getSceneRequest
     * @return A Java Future containing the result of the GetScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSceneResponse> getScene(GetSceneRequest getSceneRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSceneRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetScene");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSceneResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetSceneResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSceneRequest, GetSceneResponse>().withOperationName("GetScene")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSceneRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getSceneRequest));
            CompletableFuture<GetSceneResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the SyncJob.
     * </p>
     *
     * @param getSyncJobRequest
     * @return A Java Future containing the result of the GetSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSyncJobResponse> getSyncJob(GetSyncJobRequest getSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSyncJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSyncJobRequest, GetSyncJobResponse>().withOperationName("GetSyncJob")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getSyncJobRequest));
            CompletableFuture<GetSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a workspace.
     * </p>
     *
     * @param getWorkspaceRequest
     * @return A Java Future containing the result of the GetWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.GetWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkspaceResponse> getWorkspace(GetWorkspaceRequest getWorkspaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkspaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkspace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetWorkspaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<GetWorkspaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkspaceRequest, GetWorkspaceResponse>()
                            .withOperationName("GetWorkspace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkspaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getWorkspaceRequest));
            CompletableFuture<GetWorkspaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     *
     * @param listComponentTypesRequest
     * @return A Java Future containing the result of the ListComponentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComponentTypesResponse> listComponentTypes(ListComponentTypesRequest listComponentTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComponentTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponentTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComponentTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComponentTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListComponentTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComponentTypesRequest, ListComponentTypesResponse>()
                            .withOperationName("ListComponentTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListComponentTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listComponentTypesRequest));
            CompletableFuture<ListComponentTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API lists the components of an entity.
     * </p>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComponentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComponentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListComponentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComponentsRequest, ListComponentsResponse>()
                            .withOperationName("ListComponents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListComponentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listComponentsRequest));
            CompletableFuture<ListComponentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     *
     * @param listEntitiesRequest
     * @return A Java Future containing the result of the ListEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntitiesResponse> listEntities(ListEntitiesRequest listEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntitiesRequest, ListEntitiesResponse>()
                            .withOperationName("ListEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listEntitiesRequest));
            CompletableFuture<ListEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the metadata transfer jobs.
     * </p>
     *
     * @param listMetadataTransferJobsRequest
     * @return A Java Future containing the result of the ListMetadataTransferJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListMetadataTransferJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListMetadataTransferJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMetadataTransferJobsResponse> listMetadataTransferJobs(
            ListMetadataTransferJobsRequest listMetadataTransferJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMetadataTransferJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMetadataTransferJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMetadataTransferJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMetadataTransferJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMetadataTransferJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListMetadataTransferJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMetadataTransferJobsRequest, ListMetadataTransferJobsResponse>()
                            .withOperationName("ListMetadataTransferJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMetadataTransferJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listMetadataTransferJobsRequest));
            CompletableFuture<ListMetadataTransferJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API lists the properties of a component.
     * </p>
     *
     * @param listPropertiesRequest
     * @return A Java Future containing the result of the ListProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListProperties" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPropertiesResponse> listProperties(ListPropertiesRequest listPropertiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPropertiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPropertiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPropertiesRequest, ListPropertiesResponse>()
                            .withOperationName("ListProperties").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listPropertiesRequest));
            CompletableFuture<ListPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     *
     * @param listScenesRequest
     * @return A Java Future containing the result of the ListScenes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListScenesResponse> listScenes(ListScenesRequest listScenesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listScenesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listScenesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListScenes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListScenesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListScenesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListScenesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListScenesRequest, ListScenesResponse>().withOperationName("ListScenes")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListScenesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listScenesRequest));
            CompletableFuture<ListScenesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     *
     * @param listSyncJobsRequest
     * @return A Java Future containing the result of the ListSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSyncJobsResponse> listSyncJobs(ListSyncJobsRequest listSyncJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSyncJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSyncJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSyncJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSyncJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSyncJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListSyncJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSyncJobsRequest, ListSyncJobsResponse>()
                            .withOperationName("ListSyncJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSyncJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSyncJobsRequest));
            CompletableFuture<ListSyncJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     *
     * @param listSyncResourcesRequest
     * @return A Java Future containing the result of the ListSyncResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSyncResourcesResponse> listSyncResources(ListSyncResourcesRequest listSyncResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSyncResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSyncResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSyncResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSyncResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSyncResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListSyncResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSyncResourcesRequest, ListSyncResourcesResponse>()
                            .withOperationName("ListSyncResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSyncResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSyncResourcesRequest));
            CompletableFuture<ListSyncResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkspacesResponse> listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkspacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkspaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkspacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListWorkspacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkspacesRequest, ListWorkspacesResponse>()
                            .withOperationName("ListWorkspaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkspacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listWorkspacesRequest));
            CompletableFuture<ListWorkspacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagsException The number of tags exceeds the limit.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information in a component type.
     * </p>
     *
     * @param updateComponentTypeRequest
     * @return A Java Future containing the result of the UpdateComponentType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateComponentTypeResponse> updateComponentType(
            UpdateComponentTypeRequest updateComponentTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateComponentTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateComponentType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateComponentTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateComponentTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateComponentTypeRequest, UpdateComponentTypeResponse>()
                            .withOperationName("UpdateComponentType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateComponentTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateComponentTypeRequest));
            CompletableFuture<UpdateComponentTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an entity.
     * </p>
     *
     * @param updateEntityRequest
     * @return A Java Future containing the result of the UpdateEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEntityResponse> updateEntity(UpdateEntityRequest updateEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateEntityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEntityRequest, UpdateEntityResponse>()
                            .withOperationName("UpdateEntity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEntityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateEntityRequest));
            CompletableFuture<UpdateEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return A Java Future containing the result of the UpdatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePricingPlanResponse> updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePricingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePricingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePricingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdatePricingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePricingPlanRequest, UpdatePricingPlanResponse>()
                            .withOperationName("UpdatePricingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePricingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updatePricingPlanRequest));
            CompletableFuture<UpdatePricingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a scene.
     * </p>
     *
     * @param updateSceneRequest
     * @return A Java Future containing the result of the UpdateScene operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSceneResponse> updateScene(UpdateSceneRequest updateSceneRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSceneRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateScene");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSceneResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateSceneResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSceneRequest, UpdateSceneResponse>()
                            .withOperationName("UpdateScene").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSceneRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateSceneRequest));
            CompletableFuture<UpdateSceneResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a workspace.
     * </p>
     *
     * @param updateWorkspaceRequest
     * @return A Java Future containing the result of the UpdateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error has occurred.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ValidationException Failed</li>
     *         <li>ServiceQuotaExceededException The service quota was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTTwinMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTTwinMakerAsyncClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkspaceResponse> updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkspace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkspaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateWorkspaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkspaceRequest, UpdateWorkspaceResponse>()
                            .withOperationName("UpdateWorkspace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkspaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateWorkspaceRequest));
            CompletableFuture<UpdateWorkspaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final IoTTwinMakerServiceClientConfiguration serviceClientConfiguration() {
        return new IoTTwinMakerServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTTwinMakerException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConnectorFailureException")
                                .exceptionBuilderSupplier(ConnectorFailureException::builder).httpStatusCode(424).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConnectorTimeoutException")
                                .exceptionBuilderSupplier(ConnectorTimeoutException::builder).httpStatusCode(424).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryTimeoutException")
                                .exceptionBuilderSupplier(QueryTimeoutException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        IoTTwinMakerServiceClientConfigurationBuilder serviceConfigBuilder = new IoTTwinMakerServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
