/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMetadataTransferJobRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<CreateMetadataTransferJobRequest.Builder, CreateMetadataTransferJobRequest> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataTransferJobId").getter(getter(CreateMetadataTransferJobRequest::metadataTransferJobId))
            .setter(setter(Builder::metadataTransferJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateMetadataTransferJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SourceConfiguration>> SOURCES_FIELD = SdkField
            .<List<SourceConfiguration>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(CreateMetadataTransferJobRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(CreateMetadataTransferJobRequest::destination)).setter(setter(Builder::destination))
            .constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METADATA_TRANSFER_JOB_ID_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD, DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metadataTransferJobId;

    private final String description;

    private final List<SourceConfiguration> sources;

    private final DestinationConfiguration destination;

    private CreateMetadataTransferJobRequest(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.description = builder.description;
        this.sources = builder.sources;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The metadata transfer job Id.
     * </p>
     * 
     * @return The metadata transfer job Id.
     */
    public final String metadataTransferJobId() {
        return metadataTransferJobId;
    }

    /**
     * <p>
     * The metadata transfer job description.
     * </p>
     * 
     * @return The metadata transfer job description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata transfer job sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The metadata transfer job sources.
     */
    public final List<SourceConfiguration> sources() {
        return sources;
    }

    /**
     * <p>
     * The metadata transfer job destination.
     * </p>
     * 
     * @return The metadata transfer job destination.
     */
    public final DestinationConfiguration destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetadataTransferJobRequest)) {
            return false;
        }
        CreateMetadataTransferJobRequest other = (CreateMetadataTransferJobRequest) obj;
        return Objects.equals(metadataTransferJobId(), other.metadataTransferJobId())
                && Objects.equals(description(), other.description()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMetadataTransferJobRequest").add("MetadataTransferJobId", metadataTransferJobId())
                .add("Description", description()).add("Sources", hasSources() ? sources() : null)
                .add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataTransferJobId":
            return Optional.ofNullable(clazz.cast(metadataTransferJobId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataTransferJobId", METADATA_TRANSFER_JOB_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("destination", DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMetadataTransferJobRequest, T> g) {
        return obj -> g.apply((CreateMetadataTransferJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMetadataTransferJobRequest> {
        /**
         * <p>
         * The metadata transfer job Id.
         * </p>
         * 
         * @param metadataTransferJobId
         *        The metadata transfer job Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobId(String metadataTransferJobId);

        /**
         * <p>
         * The metadata transfer job description.
         * </p>
         * 
         * @param description
         *        The metadata transfer job description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The metadata transfer job sources.
         * </p>
         * 
         * @param sources
         *        The metadata transfer job sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SourceConfiguration> sources);

        /**
         * <p>
         * The metadata transfer job sources.
         * </p>
         * 
         * @param sources
         *        The metadata transfer job sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SourceConfiguration... sources);

        /**
         * <p>
         * The metadata transfer job sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<SourceConfiguration>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<SourceConfiguration>)
         */
        Builder sources(Consumer<SourceConfiguration.Builder>... sources);

        /**
         * <p>
         * The metadata transfer job destination.
         * </p>
         * 
         * @param destination
         *        The metadata transfer job destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DestinationConfiguration destination);

        /**
         * <p>
         * The metadata transfer job destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destination(DestinationConfiguration)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DestinationConfiguration)
         */
        default Builder destination(Consumer<DestinationConfiguration.Builder> destination) {
            return destination(DestinationConfiguration.builder().applyMutation(destination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String metadataTransferJobId;

        private String description;

        private List<SourceConfiguration> sources = DefaultSdkAutoConstructList.getInstance();

        private DestinationConfiguration destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetadataTransferJobRequest model) {
            super(model);
            metadataTransferJobId(model.metadataTransferJobId);
            description(model.description);
            sources(model.sources);
            destination(model.destination);
        }

        public final String getMetadataTransferJobId() {
            return metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SourceConfiguration.Builder> getSources() {
            List<SourceConfiguration.Builder> result = SourceConfigurationsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SourceConfiguration.BuilderImpl> sources) {
            this.sources = SourceConfigurationsCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SourceConfiguration> sources) {
            this.sources = SourceConfigurationsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfiguration... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfiguration.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SourceConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DestinationConfiguration.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DestinationConfiguration.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DestinationConfiguration destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMetadataTransferJobRequest build() {
            return new CreateMetadataTransferJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
