/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSceneRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<DeleteSceneRequest.Builder, DeleteSceneRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(DeleteSceneRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> SCENE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sceneId").getter(getter(DeleteSceneRequest::sceneId)).setter(setter(Builder::sceneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sceneId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            SCENE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final String sceneId;

    private DeleteSceneRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.sceneId = builder.sceneId;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @return The ID of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The ID of the scene to delete.
     * </p>
     * 
     * @return The ID of the scene to delete.
     */
    public final String sceneId() {
        return sceneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sceneId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSceneRequest)) {
            return false;
        }
        DeleteSceneRequest other = (DeleteSceneRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(sceneId(), other.sceneId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSceneRequest").add("WorkspaceId", workspaceId()).add("SceneId", sceneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "sceneId":
            return Optional.ofNullable(clazz.cast(sceneId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("sceneId", SCENE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSceneRequest, T> g) {
        return obj -> g.apply((DeleteSceneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSceneRequest> {
        /**
         * <p>
         * The ID of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The ID of the scene to delete.
         * </p>
         * 
         * @param sceneId
         *        The ID of the scene to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneId(String sceneId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String sceneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSceneRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            sceneId(model.sceneId);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSceneId() {
            return sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSceneRequest build() {
            return new DeleteSceneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
