/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The [link to action] metadata transfer job destination configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfiguration.Builder, DestinationConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DestinationConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Configuration")
            .getter(getter(DestinationConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()).build();

    private static final SdkField<IotTwinMakerDestinationConfiguration> IOT_TWIN_MAKER_CONFIGURATION_FIELD = SdkField
            .<IotTwinMakerDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("iotTwinMakerConfiguration")
            .getter(getter(DestinationConfiguration::iotTwinMakerConfiguration))
            .setter(setter(Builder::iotTwinMakerConfiguration)).constructor(IotTwinMakerDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotTwinMakerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            S3_CONFIGURATION_FIELD, IOT_TWIN_MAKER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final S3DestinationConfiguration s3Configuration;

    private final IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration;

    private DestinationConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Configuration = builder.s3Configuration;
        this.iotTwinMakerConfiguration = builder.iotTwinMakerConfiguration;
    }

    /**
     * <p>
     * The destination type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The destination type.
     * @see DestinationType
     */
    public final DestinationType type() {
        return DestinationType.fromValue(type);
    }

    /**
     * <p>
     * The destination type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The destination type.
     * @see DestinationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The metadata transfer job S3 configuration. [need to add S3 entity]
     * </p>
     * 
     * @return The metadata transfer job S3 configuration. [need to add S3 entity]
     */
    public final S3DestinationConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The metadata transfer job Amazon Web Services IoT TwinMaker configuration.
     * </p>
     * 
     * @return The metadata transfer job Amazon Web Services IoT TwinMaker configuration.
     */
    public final IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration() {
        return iotTwinMakerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(iotTwinMakerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(iotTwinMakerConfiguration(), other.iotTwinMakerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfiguration").add("Type", typeAsString()).add("S3Configuration", s3Configuration())
                .add("IotTwinMakerConfiguration", iotTwinMakerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "s3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "iotTwinMakerConfiguration":
            return Optional.ofNullable(clazz.cast(iotTwinMakerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("s3Configuration", S3_CONFIGURATION_FIELD);
        map.put("iotTwinMakerConfiguration", IOT_TWIN_MAKER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfiguration> {
        /**
         * <p>
         * The destination type.
         * </p>
         * 
         * @param type
         *        The destination type.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder type(String type);

        /**
         * <p>
         * The destination type.
         * </p>
         * 
         * @param type
         *        The destination type.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder type(DestinationType type);

        /**
         * <p>
         * The metadata transfer job S3 configuration. [need to add S3 entity]
         * </p>
         * 
         * @param s3Configuration
         *        The metadata transfer job S3 configuration. [need to add S3 entity]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DestinationConfiguration s3Configuration);

        /**
         * <p>
         * The metadata transfer job S3 configuration. [need to add S3 entity]
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DestinationConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DestinationConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DestinationConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * The metadata transfer job Amazon Web Services IoT TwinMaker configuration.
         * </p>
         * 
         * @param iotTwinMakerConfiguration
         *        The metadata transfer job Amazon Web Services IoT TwinMaker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration);

        /**
         * <p>
         * The metadata transfer job Amazon Web Services IoT TwinMaker configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IotTwinMakerDestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link IotTwinMakerDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotTwinMakerDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration)}.
         * 
         * @param iotTwinMakerConfiguration
         *        a consumer that will call methods on {@link IotTwinMakerDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration)
         */
        default Builder iotTwinMakerConfiguration(Consumer<IotTwinMakerDestinationConfiguration.Builder> iotTwinMakerConfiguration) {
            return iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration.builder()
                    .applyMutation(iotTwinMakerConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private S3DestinationConfiguration s3Configuration;

        private IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            type(model.type);
            s3Configuration(model.s3Configuration);
            iotTwinMakerConfiguration(model.iotTwinMakerConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DestinationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final IotTwinMakerDestinationConfiguration.Builder getIotTwinMakerConfiguration() {
            return iotTwinMakerConfiguration != null ? iotTwinMakerConfiguration.toBuilder() : null;
        }

        public final void setIotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration.BuilderImpl iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration != null ? iotTwinMakerConfiguration.build() : null;
        }

        @Override
        public final Builder iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration;
            return this;
        }

        @Override
        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
