/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter by asset. [TwinMaker asset]
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterByAsset implements SdkPojo, Serializable, ToCopyableBuilder<FilterByAsset.Builder, FilterByAsset> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(FilterByAsset::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetExternalId").getter(getter(FilterByAsset::assetExternalId))
            .setter(setter(Builder::assetExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()).build();

    private static final SdkField<Boolean> INCLUDE_OFFSPRING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeOffspring").getter(getter(FilterByAsset::includeOffspring))
            .setter(setter(Builder::includeOffspring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOffspring").build()).build();

    private static final SdkField<Boolean> INCLUDE_ASSET_MODEL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeAssetModel").getter(getter(FilterByAsset::includeAssetModel))
            .setter(setter(Builder::includeAssetModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAssetModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_EXTERNAL_ID_FIELD, INCLUDE_OFFSPRING_FIELD, INCLUDE_ASSET_MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String assetExternalId;

    private final Boolean includeOffspring;

    private final Boolean includeAssetModel;

    private FilterByAsset(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetExternalId = builder.assetExternalId;
        this.includeOffspring = builder.includeOffspring;
        this.includeAssetModel = builder.includeAssetModel;
    }

    /**
     * <p>
     * Filter by asset Id.
     * </p>
     * 
     * @return Filter by asset Id.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The external-Id property of an asset.
     * </p>
     * 
     * @return The external-Id property of an asset.
     */
    public final String assetExternalId() {
        return assetExternalId;
    }

    /**
     * <p>
     * Includes sub-assets.[need description hekp for this]
     * </p>
     * 
     * @return Includes sub-assets.[need description hekp for this]
     */
    public final Boolean includeOffspring() {
        return includeOffspring;
    }

    /**
     * <p>
     * Boolean to include the asset model.
     * </p>
     * 
     * @return Boolean to include the asset model.
     */
    public final Boolean includeAssetModel() {
        return includeAssetModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(includeOffspring());
        hashCode = 31 * hashCode + Objects.hashCode(includeAssetModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterByAsset)) {
            return false;
        }
        FilterByAsset other = (FilterByAsset) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetExternalId(), other.assetExternalId())
                && Objects.equals(includeOffspring(), other.includeOffspring())
                && Objects.equals(includeAssetModel(), other.includeAssetModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterByAsset").add("AssetId", assetId()).add("AssetExternalId", assetExternalId())
                .add("IncludeOffspring", includeOffspring()).add("IncludeAssetModel", includeAssetModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetExternalId":
            return Optional.ofNullable(clazz.cast(assetExternalId()));
        case "includeOffspring":
            return Optional.ofNullable(clazz.cast(includeOffspring()));
        case "includeAssetModel":
            return Optional.ofNullable(clazz.cast(includeAssetModel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetExternalId", ASSET_EXTERNAL_ID_FIELD);
        map.put("includeOffspring", INCLUDE_OFFSPRING_FIELD);
        map.put("includeAssetModel", INCLUDE_ASSET_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterByAsset, T> g) {
        return obj -> g.apply((FilterByAsset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterByAsset> {
        /**
         * <p>
         * Filter by asset Id.
         * </p>
         * 
         * @param assetId
         *        Filter by asset Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The external-Id property of an asset.
         * </p>
         * 
         * @param assetExternalId
         *        The external-Id property of an asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetExternalId(String assetExternalId);

        /**
         * <p>
         * Includes sub-assets.[need description hekp for this]
         * </p>
         * 
         * @param includeOffspring
         *        Includes sub-assets.[need description hekp for this]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOffspring(Boolean includeOffspring);

        /**
         * <p>
         * Boolean to include the asset model.
         * </p>
         * 
         * @param includeAssetModel
         *        Boolean to include the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAssetModel(Boolean includeAssetModel);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String assetExternalId;

        private Boolean includeOffspring;

        private Boolean includeAssetModel;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterByAsset model) {
            assetId(model.assetId);
            assetExternalId(model.assetExternalId);
            includeOffspring(model.includeOffspring);
            includeAssetModel(model.includeAssetModel);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetExternalId() {
            return assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        public final Boolean getIncludeOffspring() {
            return includeOffspring;
        }

        public final void setIncludeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
        }

        @Override
        public final Builder includeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
            return this;
        }

        public final Boolean getIncludeAssetModel() {
            return includeAssetModel;
        }

        public final void setIncludeAssetModel(Boolean includeAssetModel) {
            this.includeAssetModel = includeAssetModel;
        }

        @Override
        public final Builder includeAssetModel(Boolean includeAssetModel) {
            this.includeAssetModel = includeAssetModel;
            return this;
        }

        @Override
        public FilterByAsset build() {
            return new FilterByAsset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
