/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPropertyValueResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetPropertyValueResponse.Builder, GetPropertyValueResponse> {
    private static final SdkField<Map<String, PropertyLatestValue>> PROPERTY_VALUES_FIELD = SdkField
            .<Map<String, PropertyLatestValue>> builder(MarshallingType.MAP)
            .memberName("propertyValues")
            .getter(getter(GetPropertyValueResponse::propertyValues))
            .setter(setter(Builder::propertyValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyLatestValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyLatestValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetPropertyValueResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<List<Map<String, DataValue>>>> TABULAR_PROPERTY_VALUES_FIELD = SdkField
            .<List<List<Map<String, DataValue>>>> builder(MarshallingType.LIST)
            .memberName("tabularPropertyValues")
            .getter(getter(GetPropertyValueResponse::tabularPropertyValues))
            .setter(setter(Builder::tabularPropertyValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tabularPropertyValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Map<String, DataValue>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Map<String, DataValue>> builder(MarshallingType.MAP)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    MapTrait.builder()
                                                                                            .keyLocationName("key")
                                                                                            .valueLocationName("value")
                                                                                            .valueFieldInfo(
                                                                                                    SdkField.<DataValue> builder(
                                                                                                            MarshallingType.SDK_POJO)
                                                                                                            .constructor(
                                                                                                                    DataValue::builder)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "value")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_VALUES_FIELD,
            NEXT_TOKEN_FIELD, TABULAR_PROPERTY_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, PropertyLatestValue> propertyValues;

    private final String nextToken;

    private final List<List<Map<String, DataValue>>> tabularPropertyValues;

    private GetPropertyValueResponse(BuilderImpl builder) {
        super(builder);
        this.propertyValues = builder.propertyValues;
        this.nextToken = builder.nextToken;
        this.tabularPropertyValues = builder.tabularPropertyValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyValues() {
        return propertyValues != null && !(propertyValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the properties and latest property values in the response. Each string in the
     * mapping must be unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyValues} method.
     * </p>
     * 
     * @return An object that maps strings to the properties and latest property values in the response. Each string in
     *         the mapping must be unique to this object.
     */
    public final Map<String, PropertyLatestValue> propertyValues() {
        return propertyValues;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TabularPropertyValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTabularPropertyValues() {
        return tabularPropertyValues != null && !(tabularPropertyValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A table of property values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTabularPropertyValues} method.
     * </p>
     * 
     * @return A table of property values.
     */
    public final List<List<Map<String, DataValue>>> tabularPropertyValues() {
        return tabularPropertyValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyValues() ? propertyValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTabularPropertyValues() ? tabularPropertyValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueResponse)) {
            return false;
        }
        GetPropertyValueResponse other = (GetPropertyValueResponse) obj;
        return hasPropertyValues() == other.hasPropertyValues() && Objects.equals(propertyValues(), other.propertyValues())
                && Objects.equals(nextToken(), other.nextToken())
                && hasTabularPropertyValues() == other.hasTabularPropertyValues()
                && Objects.equals(tabularPropertyValues(), other.tabularPropertyValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPropertyValueResponse").add("PropertyValues", hasPropertyValues() ? propertyValues() : null)
                .add("NextToken", nextToken())
                .add("TabularPropertyValues", hasTabularPropertyValues() ? tabularPropertyValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "propertyValues":
            return Optional.ofNullable(clazz.cast(propertyValues()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "tabularPropertyValues":
            return Optional.ofNullable(clazz.cast(tabularPropertyValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("propertyValues", PROPERTY_VALUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("tabularPropertyValues", TABULAR_PROPERTY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueResponse, T> g) {
        return obj -> g.apply((GetPropertyValueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPropertyValueResponse> {
        /**
         * <p>
         * An object that maps strings to the properties and latest property values in the response. Each string in the
         * mapping must be unique to this object.
         * </p>
         * 
         * @param propertyValues
         *        An object that maps strings to the properties and latest property values in the response. Each string
         *        in the mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValues(Map<String, PropertyLatestValue> propertyValues);

        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A table of property values.
         * </p>
         * 
         * @param tabularPropertyValues
         *        A table of property values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tabularPropertyValues(Collection<? extends Collection<? extends Map<String, DataValue>>> tabularPropertyValues);

        /**
         * <p>
         * A table of property values.
         * </p>
         * 
         * @param tabularPropertyValues
         *        A table of property values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tabularPropertyValues(Collection<? extends Map<String, DataValue>>... tabularPropertyValues);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private Map<String, PropertyLatestValue> propertyValues = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private List<List<Map<String, DataValue>>> tabularPropertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueResponse model) {
            super(model);
            propertyValues(model.propertyValues);
            nextToken(model.nextToken);
            tabularPropertyValues(model.tabularPropertyValues);
        }

        public final Map<String, PropertyLatestValue.Builder> getPropertyValues() {
            Map<String, PropertyLatestValue.Builder> result = PropertyLatestValueMapCopier.copyToBuilder(this.propertyValues);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyValues(Map<String, PropertyLatestValue.BuilderImpl> propertyValues) {
            this.propertyValues = PropertyLatestValueMapCopier.copyFromBuilder(propertyValues);
        }

        @Override
        public final Builder propertyValues(Map<String, PropertyLatestValue> propertyValues) {
            this.propertyValues = PropertyLatestValueMapCopier.copy(propertyValues);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<List<Map<String, DataValue.Builder>>> getTabularPropertyValues() {
            List<List<Map<String, DataValue.Builder>>> result = TabularPropertyValuesCopier
                    .copyToBuilder(this.tabularPropertyValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTabularPropertyValues(
                Collection<? extends Collection<? extends Map<String, DataValue.BuilderImpl>>> tabularPropertyValues) {
            this.tabularPropertyValues = TabularPropertyValuesCopier.copyFromBuilder(tabularPropertyValues);
        }

        @Override
        public final Builder tabularPropertyValues(
                Collection<? extends Collection<? extends Map<String, DataValue>>> tabularPropertyValues) {
            this.tabularPropertyValues = TabularPropertyValuesCopier.copy(tabularPropertyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tabularPropertyValues(Collection<? extends Map<String, DataValue>>... tabularPropertyValues) {
            tabularPropertyValues(Arrays.asList(tabularPropertyValues));
            return this;
        }

        @Override
        public GetPropertyValueResponse build() {
            return new GetPropertyValueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
