/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSceneResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetSceneResponse.Builder, GetSceneResponse> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetSceneResponse::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final SdkField<String> SCENE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sceneId").getter(getter(GetSceneResponse::sceneId)).setter(setter(Builder::sceneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()).build();

    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentLocation").getter(getter(GetSceneResponse::contentLocation))
            .setter(setter(Builder::contentLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSceneResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GetSceneResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(GetSceneResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetSceneResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(GetSceneResponse::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SCENE_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sceneMetadata")
            .getter(getter(GetSceneResponse::sceneMetadata))
            .setter(setter(Builder::sceneMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> GENERATED_SCENE_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("generatedSceneMetadata")
            .getter(getter(GetSceneResponse::generatedSceneMetadata))
            .setter(setter(Builder::generatedSceneMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedSceneMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SceneError> ERROR_FIELD = SdkField.<SceneError> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetSceneResponse::error)).setter(setter(Builder::error))
            .constructor(SceneError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            SCENE_ID_FIELD, CONTENT_LOCATION_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD,
            DESCRIPTION_FIELD, CAPABILITIES_FIELD, SCENE_METADATA_FIELD, GENERATED_SCENE_METADATA_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final String sceneId;

    private final String contentLocation;

    private final String arn;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private final String description;

    private final List<String> capabilities;

    private final Map<String, String> sceneMetadata;

    private final Map<String, String> generatedSceneMetadata;

    private final SceneError error;

    private GetSceneResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.sceneId = builder.sceneId;
        this.contentLocation = builder.contentLocation;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.sceneMetadata = builder.sceneMetadata;
        this.generatedSceneMetadata = builder.generatedSceneMetadata;
        this.error = builder.error;
    }

    /**
     * <p>
     * The ID of the workspace that contains the scene.
     * </p>
     * 
     * @return The ID of the workspace that contains the scene.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The ID of the scene.
     * </p>
     * 
     * @return The ID of the scene.
     */
    public final String sceneId() {
        return sceneId;
    }

    /**
     * <p>
     * The relative path that specifies the location of the content definition file.
     * </p>
     * 
     * @return The relative path that specifies the location of the content definition file.
     */
    public final String contentLocation() {
        return contentLocation;
    }

    /**
     * <p>
     * The ARN of the scene.
     * </p>
     * 
     * @return The ARN of the scene.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the scene was created.
     * </p>
     * 
     * @return The date and time when the scene was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time when the scene was last updated.
     * </p>
     * 
     * @return The date and time when the scene was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The description of the scene.
     * </p>
     * 
     * @return The description of the scene.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of capabilities that the scene uses to render.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return A list of capabilities that the scene uses to render.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the SceneMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSceneMetadata() {
        return sceneMetadata != null && !(sceneMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The response metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSceneMetadata} method.
     * </p>
     * 
     * @return The response metadata.
     */
    public final Map<String, String> sceneMetadata() {
        return sceneMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratedSceneMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGeneratedSceneMetadata() {
        return generatedSceneMetadata != null && !(generatedSceneMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The generated scene metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratedSceneMetadata} method.
     * </p>
     * 
     * @return The generated scene metadata.
     */
    public final Map<String, String> generatedSceneMetadata() {
        return generatedSceneMetadata;
    }

    /**
     * <p>
     * The SceneResponse error.
     * </p>
     * 
     * @return The SceneResponse error.
     */
    public final SceneError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSceneMetadata() ? sceneMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedSceneMetadata() ? generatedSceneMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSceneResponse)) {
            return false;
        }
        GetSceneResponse other = (GetSceneResponse) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(sceneId(), other.sceneId())
                && Objects.equals(contentLocation(), other.contentLocation()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(description(), other.description())
                && hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && hasSceneMetadata() == other.hasSceneMetadata() && Objects.equals(sceneMetadata(), other.sceneMetadata())
                && hasGeneratedSceneMetadata() == other.hasGeneratedSceneMetadata()
                && Objects.equals(generatedSceneMetadata(), other.generatedSceneMetadata())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSceneResponse").add("WorkspaceId", workspaceId()).add("SceneId", sceneId())
                .add("ContentLocation", contentLocation()).add("Arn", arn()).add("CreationDateTime", creationDateTime())
                .add("UpdateDateTime", updateDateTime()).add("Description", description())
                .add("Capabilities", hasCapabilities() ? capabilities() : null)
                .add("SceneMetadata", hasSceneMetadata() ? sceneMetadata() : null)
                .add("GeneratedSceneMetadata", hasGeneratedSceneMetadata() ? generatedSceneMetadata() : null)
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "sceneId":
            return Optional.ofNullable(clazz.cast(sceneId()));
        case "contentLocation":
            return Optional.ofNullable(clazz.cast(contentLocation()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "sceneMetadata":
            return Optional.ofNullable(clazz.cast(sceneMetadata()));
        case "generatedSceneMetadata":
            return Optional.ofNullable(clazz.cast(generatedSceneMetadata()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("sceneId", SCENE_ID_FIELD);
        map.put("contentLocation", CONTENT_LOCATION_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("sceneMetadata", SCENE_METADATA_FIELD);
        map.put("generatedSceneMetadata", GENERATED_SCENE_METADATA_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSceneResponse, T> g) {
        return obj -> g.apply((GetSceneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSceneResponse> {
        /**
         * <p>
         * The ID of the workspace that contains the scene.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The ID of the scene.
         * </p>
         * 
         * @param sceneId
         *        The ID of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneId(String sceneId);

        /**
         * <p>
         * The relative path that specifies the location of the content definition file.
         * </p>
         * 
         * @param contentLocation
         *        The relative path that specifies the location of the content definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLocation(String contentLocation);

        /**
         * <p>
         * The ARN of the scene.
         * </p>
         * 
         * @param arn
         *        The ARN of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the scene was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the scene was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time when the scene was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the scene was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The description of the scene.
         * </p>
         * 
         * @param description
         *        The description of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of capabilities that the scene uses to render.
         * </p>
         * 
         * @param capabilities
         *        A list of capabilities that the scene uses to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * A list of capabilities that the scene uses to render.
         * </p>
         * 
         * @param capabilities
         *        A list of capabilities that the scene uses to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The response metadata.
         * </p>
         * 
         * @param sceneMetadata
         *        The response metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneMetadata(Map<String, String> sceneMetadata);

        /**
         * <p>
         * The generated scene metadata.
         * </p>
         * 
         * @param generatedSceneMetadata
         *        The generated scene metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedSceneMetadata(Map<String, String> generatedSceneMetadata);

        /**
         * <p>
         * The SceneResponse error.
         * </p>
         * 
         * @param error
         *        The SceneResponse error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(SceneError error);

        /**
         * <p>
         * The SceneResponse error.
         * </p>
         * This is a convenience method that creates an instance of the {@link SceneError.Builder} avoiding the need to
         * create one manually via {@link SceneError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SceneError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(SceneError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link SceneError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(SceneError)
         */
        default Builder error(Consumer<SceneError.Builder> error) {
            return error(SceneError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String workspaceId;

        private String sceneId;

        private String contentLocation;

        private String arn;

        private Instant creationDateTime;

        private Instant updateDateTime;

        private String description;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> sceneMetadata = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> generatedSceneMetadata = DefaultSdkAutoConstructMap.getInstance();

        private SceneError error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSceneResponse model) {
            super(model);
            workspaceId(model.workspaceId);
            sceneId(model.sceneId);
            contentLocation(model.contentLocation);
            arn(model.arn);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
            description(model.description);
            capabilities(model.capabilities);
            sceneMetadata(model.sceneMetadata);
            generatedSceneMetadata(model.generatedSceneMetadata);
            error(model.error);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSceneId() {
            return sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getContentLocation() {
            return contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Map<String, String> getSceneMetadata() {
            if (sceneMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return sceneMetadata;
        }

        public final void setSceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
        }

        @Override
        public final Builder sceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
            return this;
        }

        public final Map<String, String> getGeneratedSceneMetadata() {
            if (generatedSceneMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return generatedSceneMetadata;
        }

        public final void setGeneratedSceneMetadata(Map<String, String> generatedSceneMetadata) {
            this.generatedSceneMetadata = GeneratedSceneMetadataMapCopier.copy(generatedSceneMetadata);
        }

        @Override
        public final Builder generatedSceneMetadata(Map<String, String> generatedSceneMetadata) {
            this.generatedSceneMetadata = GeneratedSceneMetadataMapCopier.copy(generatedSceneMetadata);
            return this;
        }

        public final SceneError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(SceneError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(SceneError error) {
            this.error = error;
            return this;
        }

        @Override
        public GetSceneResponse build() {
            return new GetSceneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
