/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies how to interpolate data in a list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterpolationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<InterpolationParameters.Builder, InterpolationParameters> {
    private static final SdkField<String> INTERPOLATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interpolationType").getter(getter(InterpolationParameters::interpolationTypeAsString))
            .setter(setter(Builder::interpolationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpolationType").build()).build();

    private static final SdkField<Long> INTERVAL_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("intervalInSeconds").getter(getter(InterpolationParameters::intervalInSeconds))
            .setter(setter(Builder::intervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERPOLATION_TYPE_FIELD,
            INTERVAL_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interpolationType;

    private final Long intervalInSeconds;

    private InterpolationParameters(BuilderImpl builder) {
        this.interpolationType = builder.interpolationType;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    /**
     * <p>
     * The interpolation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interpolationType}
     * will return {@link InterpolationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interpolationTypeAsString}.
     * </p>
     * 
     * @return The interpolation type.
     * @see InterpolationType
     */
    public final InterpolationType interpolationType() {
        return InterpolationType.fromValue(interpolationType);
    }

    /**
     * <p>
     * The interpolation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interpolationType}
     * will return {@link InterpolationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interpolationTypeAsString}.
     * </p>
     * 
     * @return The interpolation type.
     * @see InterpolationType
     */
    public final String interpolationTypeAsString() {
        return interpolationType;
    }

    /**
     * <p>
     * The interpolation time interval in seconds.
     * </p>
     * 
     * @return The interpolation time interval in seconds.
     */
    public final Long intervalInSeconds() {
        return intervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interpolationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(intervalInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterpolationParameters)) {
            return false;
        }
        InterpolationParameters other = (InterpolationParameters) obj;
        return Objects.equals(interpolationTypeAsString(), other.interpolationTypeAsString())
                && Objects.equals(intervalInSeconds(), other.intervalInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterpolationParameters").add("InterpolationType", interpolationTypeAsString())
                .add("IntervalInSeconds", intervalInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interpolationType":
            return Optional.ofNullable(clazz.cast(interpolationTypeAsString()));
        case "intervalInSeconds":
            return Optional.ofNullable(clazz.cast(intervalInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interpolationType", INTERPOLATION_TYPE_FIELD);
        map.put("intervalInSeconds", INTERVAL_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterpolationParameters, T> g) {
        return obj -> g.apply((InterpolationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterpolationParameters> {
        /**
         * <p>
         * The interpolation type.
         * </p>
         * 
         * @param interpolationType
         *        The interpolation type.
         * @see InterpolationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterpolationType
         */
        Builder interpolationType(String interpolationType);

        /**
         * <p>
         * The interpolation type.
         * </p>
         * 
         * @param interpolationType
         *        The interpolation type.
         * @see InterpolationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterpolationType
         */
        Builder interpolationType(InterpolationType interpolationType);

        /**
         * <p>
         * The interpolation time interval in seconds.
         * </p>
         * 
         * @param intervalInSeconds
         *        The interpolation time interval in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalInSeconds(Long intervalInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String interpolationType;

        private Long intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InterpolationParameters model) {
            interpolationType(model.interpolationType);
            intervalInSeconds(model.intervalInSeconds);
        }

        public final String getInterpolationType() {
            return interpolationType;
        }

        public final void setInterpolationType(String interpolationType) {
            this.interpolationType = interpolationType;
        }

        @Override
        public final Builder interpolationType(String interpolationType) {
            this.interpolationType = interpolationType;
            return this;
        }

        @Override
        public final Builder interpolationType(InterpolationType interpolationType) {
            this.interpolationType(interpolationType == null ? null : interpolationType.toString());
            return this;
        }

        public final Long getIntervalInSeconds() {
            return intervalInSeconds;
        }

        public final void setIntervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        @Override
        public InterpolationParameters build() {
            return new InterpolationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
