/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata transfer job AWS IoT SiteWise source configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotSiteWiseSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IotSiteWiseSourceConfiguration.Builder, IotSiteWiseSourceConfiguration> {
    private static final SdkField<List<IotSiteWiseSourceConfigurationFilter>> FILTERS_FIELD = SdkField
            .<List<IotSiteWiseSourceConfigurationFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(IotSiteWiseSourceConfiguration::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IotSiteWiseSourceConfigurationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IotSiteWiseSourceConfigurationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<IotSiteWiseSourceConfigurationFilter> filters;

    private IotSiteWiseSourceConfiguration(BuilderImpl builder) {
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS IoT SiteWise soucre configuration filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The AWS IoT SiteWise soucre configuration filters.
     */
    public final List<IotSiteWiseSourceConfigurationFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseSourceConfiguration)) {
            return false;
        }
        IotSiteWiseSourceConfiguration other = (IotSiteWiseSourceConfiguration) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotSiteWiseSourceConfiguration").add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseSourceConfiguration, T> g) {
        return obj -> g.apply((IotSiteWiseSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotSiteWiseSourceConfiguration> {
        /**
         * <p>
         * The AWS IoT SiteWise soucre configuration filters.
         * </p>
         * 
         * @param filters
         *        The AWS IoT SiteWise soucre configuration filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IotSiteWiseSourceConfigurationFilter> filters);

        /**
         * <p>
         * The AWS IoT SiteWise soucre configuration filters.
         * </p>
         * 
         * @param filters
         *        The AWS IoT SiteWise soucre configuration filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IotSiteWiseSourceConfigurationFilter... filters);

        /**
         * <p>
         * The AWS IoT SiteWise soucre configuration filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.IotSiteWiseSourceConfigurationFilter.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iottwinmaker.model.IotSiteWiseSourceConfigurationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.IotSiteWiseSourceConfigurationFilter.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #filters(List<IotSiteWiseSourceConfigurationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.IotSiteWiseSourceConfigurationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<IotSiteWiseSourceConfigurationFilter>)
         */
        Builder filters(Consumer<IotSiteWiseSourceConfigurationFilter.Builder>... filters);
    }

    static final class BuilderImpl implements Builder {
        private List<IotSiteWiseSourceConfigurationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseSourceConfiguration model) {
            filters(model.filters);
        }

        public final List<IotSiteWiseSourceConfigurationFilter.Builder> getFilters() {
            List<IotSiteWiseSourceConfigurationFilter.Builder> result = IotSiteWiseSourceConfigurationFiltersCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IotSiteWiseSourceConfigurationFilter.BuilderImpl> filters) {
            this.filters = IotSiteWiseSourceConfigurationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IotSiteWiseSourceConfigurationFilter> filters) {
            this.filters = IotSiteWiseSourceConfigurationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IotSiteWiseSourceConfigurationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IotSiteWiseSourceConfigurationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IotSiteWiseSourceConfigurationFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public IotSiteWiseSourceConfiguration build() {
            return new IotSiteWiseSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
