/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata transfer job AWS IoT TwinMaker source configuration filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotTwinMakerSourceConfigurationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<IotTwinMakerSourceConfigurationFilter.Builder, IotTwinMakerSourceConfigurationFilter> {
    private static final SdkField<FilterByComponentType> FILTER_BY_COMPONENT_TYPE_FIELD = SdkField
            .<FilterByComponentType> builder(MarshallingType.SDK_POJO).memberName("filterByComponentType")
            .getter(getter(IotTwinMakerSourceConfigurationFilter::filterByComponentType))
            .setter(setter(Builder::filterByComponentType)).constructor(FilterByComponentType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByComponentType").build())
            .build();

    private static final SdkField<FilterByEntity> FILTER_BY_ENTITY_FIELD = SdkField
            .<FilterByEntity> builder(MarshallingType.SDK_POJO).memberName("filterByEntity")
            .getter(getter(IotTwinMakerSourceConfigurationFilter::filterByEntity)).setter(setter(Builder::filterByEntity))
            .constructor(FilterByEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByEntity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILTER_BY_COMPONENT_TYPE_FIELD, FILTER_BY_ENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FilterByComponentType filterByComponentType;

    private final FilterByEntity filterByEntity;

    private final Type type;

    private IotTwinMakerSourceConfigurationFilter(BuilderImpl builder) {
        this.filterByComponentType = builder.filterByComponentType;
        this.filterByEntity = builder.filterByEntity;
        this.type = builder.type;
    }

    /**
     * <p>
     * Filter by component type.
     * </p>
     * 
     * @return Filter by component type.
     */
    public final FilterByComponentType filterByComponentType() {
        return filterByComponentType;
    }

    /**
     * <p>
     * Filter by entity.
     * </p>
     * 
     * @return Filter by entity.
     */
    public final FilterByEntity filterByEntity() {
        return filterByEntity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterByComponentType());
        hashCode = 31 * hashCode + Objects.hashCode(filterByEntity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotTwinMakerSourceConfigurationFilter)) {
            return false;
        }
        IotTwinMakerSourceConfigurationFilter other = (IotTwinMakerSourceConfigurationFilter) obj;
        return Objects.equals(filterByComponentType(), other.filterByComponentType())
                && Objects.equals(filterByEntity(), other.filterByEntity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotTwinMakerSourceConfigurationFilter").add("FilterByComponentType", filterByComponentType())
                .add("FilterByEntity", filterByEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterByComponentType":
            return Optional.ofNullable(clazz.cast(filterByComponentType()));
        case "filterByEntity":
            return Optional.ofNullable(clazz.cast(filterByEntity()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #filterByComponentType()} initialized to the given value.
     *
     * <p>
     * Filter by component type.
     * </p>
     * 
     * @param filterByComponentType
     *        Filter by component type.
     */
    public static IotTwinMakerSourceConfigurationFilter fromFilterByComponentType(FilterByComponentType filterByComponentType) {
        return builder().filterByComponentType(filterByComponentType).build();
    }

    /**
     * Create an instance of this class with {@link #filterByComponentType()} initialized to the given value.
     *
     * <p>
     * Filter by component type.
     * </p>
     * 
     * @param filterByComponentType
     *        Filter by component type.
     */
    public static IotTwinMakerSourceConfigurationFilter fromFilterByComponentType(
            Consumer<FilterByComponentType.Builder> filterByComponentType) {
        FilterByComponentType.Builder builder = FilterByComponentType.builder();
        filterByComponentType.accept(builder);
        return fromFilterByComponentType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #filterByEntity()} initialized to the given value.
     *
     * <p>
     * Filter by entity.
     * </p>
     * 
     * @param filterByEntity
     *        Filter by entity.
     */
    public static IotTwinMakerSourceConfigurationFilter fromFilterByEntity(FilterByEntity filterByEntity) {
        return builder().filterByEntity(filterByEntity).build();
    }

    /**
     * Create an instance of this class with {@link #filterByEntity()} initialized to the given value.
     *
     * <p>
     * Filter by entity.
     * </p>
     * 
     * @param filterByEntity
     *        Filter by entity.
     */
    public static IotTwinMakerSourceConfigurationFilter fromFilterByEntity(Consumer<FilterByEntity.Builder> filterByEntity) {
        FilterByEntity.Builder builder = FilterByEntity.builder();
        filterByEntity.accept(builder);
        return fromFilterByEntity(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterByComponentType", FILTER_BY_COMPONENT_TYPE_FIELD);
        map.put("filterByEntity", FILTER_BY_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IotTwinMakerSourceConfigurationFilter, T> g) {
        return obj -> g.apply((IotTwinMakerSourceConfigurationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotTwinMakerSourceConfigurationFilter> {
        /**
         * <p>
         * Filter by component type.
         * </p>
         * 
         * @param filterByComponentType
         *        Filter by component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByComponentType(FilterByComponentType filterByComponentType);

        /**
         * <p>
         * Filter by component type.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterByComponentType.Builder} avoiding
         * the need to create one manually via {@link FilterByComponentType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterByComponentType.Builder#build()} is called immediately and
         * its result is passed to {@link #filterByComponentType(FilterByComponentType)}.
         * 
         * @param filterByComponentType
         *        a consumer that will call methods on {@link FilterByComponentType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterByComponentType(FilterByComponentType)
         */
        default Builder filterByComponentType(Consumer<FilterByComponentType.Builder> filterByComponentType) {
            return filterByComponentType(FilterByComponentType.builder().applyMutation(filterByComponentType).build());
        }

        /**
         * <p>
         * Filter by entity.
         * </p>
         * 
         * @param filterByEntity
         *        Filter by entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByEntity(FilterByEntity filterByEntity);

        /**
         * <p>
         * Filter by entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterByEntity.Builder} avoiding the need
         * to create one manually via {@link FilterByEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterByEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #filterByEntity(FilterByEntity)}.
         * 
         * @param filterByEntity
         *        a consumer that will call methods on {@link FilterByEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterByEntity(FilterByEntity)
         */
        default Builder filterByEntity(Consumer<FilterByEntity.Builder> filterByEntity) {
            return filterByEntity(FilterByEntity.builder().applyMutation(filterByEntity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterByComponentType filterByComponentType;

        private FilterByEntity filterByEntity;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IotTwinMakerSourceConfigurationFilter model) {
            filterByComponentType(model.filterByComponentType);
            filterByEntity(model.filterByEntity);
        }

        public final FilterByComponentType.Builder getFilterByComponentType() {
            return filterByComponentType != null ? filterByComponentType.toBuilder() : null;
        }

        public final void setFilterByComponentType(FilterByComponentType.BuilderImpl filterByComponentType) {
            Object oldValue = this.filterByComponentType;
            this.filterByComponentType = filterByComponentType != null ? filterByComponentType.build() : null;
            handleUnionValueChange(Type.FILTER_BY_COMPONENT_TYPE, oldValue, this.filterByComponentType);
        }

        @Override
        public final Builder filterByComponentType(FilterByComponentType filterByComponentType) {
            Object oldValue = this.filterByComponentType;
            this.filterByComponentType = filterByComponentType;
            handleUnionValueChange(Type.FILTER_BY_COMPONENT_TYPE, oldValue, this.filterByComponentType);
            return this;
        }

        public final FilterByEntity.Builder getFilterByEntity() {
            return filterByEntity != null ? filterByEntity.toBuilder() : null;
        }

        public final void setFilterByEntity(FilterByEntity.BuilderImpl filterByEntity) {
            Object oldValue = this.filterByEntity;
            this.filterByEntity = filterByEntity != null ? filterByEntity.build() : null;
            handleUnionValueChange(Type.FILTER_BY_ENTITY, oldValue, this.filterByEntity);
        }

        @Override
        public final Builder filterByEntity(FilterByEntity filterByEntity) {
            Object oldValue = this.filterByEntity;
            this.filterByEntity = filterByEntity;
            handleUnionValueChange(Type.FILTER_BY_ENTITY, oldValue, this.filterByEntity);
            return this;
        }

        @Override
        public IotTwinMakerSourceConfigurationFilter build() {
            return new IotTwinMakerSourceConfigurationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IotTwinMakerSourceConfigurationFilter#type()
     */
    public enum Type {
        FILTER_BY_COMPONENT_TYPE,

        FILTER_BY_ENTITY,

        UNKNOWN_TO_SDK_VERSION
    }
}
