/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters items in a list of entities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitiesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListEntitiesFilter.Builder, ListEntitiesFilter> {
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(ListEntitiesFilter::parentEntityId))
            .setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(ListEntitiesFilter::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(ListEntitiesFilter::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_ENTITY_ID_FIELD,
            COMPONENT_TYPE_ID_FIELD, EXTERNAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parentEntityId;

    private final String componentTypeId;

    private final String externalId;

    private final Type type;

    private ListEntitiesFilter(BuilderImpl builder) {
        this.parentEntityId = builder.parentEntityId;
        this.componentTypeId = builder.componentTypeId;
        this.externalId = builder.externalId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The parent of the entities in the list.
     * </p>
     * 
     * @return The parent of the entities in the list.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    /**
     * <p>
     * The ID of the component type in the entities in the list.
     * </p>
     * 
     * @return The ID of the component type in the entities in the list.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The external-Id property of a component. The external-Id property is the primary key of an external storage
     * system.
     * </p>
     * 
     * @return The external-Id property of a component. The external-Id property is the primary key of an external
     *         storage system.
     */
    public final String externalId() {
        return externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesFilter)) {
            return false;
        }
        ListEntitiesFilter other = (ListEntitiesFilter) obj;
        return Objects.equals(parentEntityId(), other.parentEntityId())
                && Objects.equals(componentTypeId(), other.componentTypeId()) && Objects.equals(externalId(), other.externalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEntitiesFilter").add("ParentEntityId", parentEntityId())
                .add("ComponentTypeId", componentTypeId()).add("ExternalId", externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #parentEntityId()} initialized to the given value.
     *
     * <p>
     * The parent of the entities in the list.
     * </p>
     * 
     * @param parentEntityId
     *        The parent of the entities in the list.
     */
    public static ListEntitiesFilter fromParentEntityId(String parentEntityId) {
        return builder().parentEntityId(parentEntityId).build();
    }

    /**
     * Create an instance of this class with {@link #componentTypeId()} initialized to the given value.
     *
     * <p>
     * The ID of the component type in the entities in the list.
     * </p>
     * 
     * @param componentTypeId
     *        The ID of the component type in the entities in the list.
     */
    public static ListEntitiesFilter fromComponentTypeId(String componentTypeId) {
        return builder().componentTypeId(componentTypeId).build();
    }

    /**
     * Create an instance of this class with {@link #externalId()} initialized to the given value.
     *
     * <p>
     * The external-Id property of a component. The external-Id property is the primary key of an external storage
     * system.
     * </p>
     * 
     * @param externalId
     *        The external-Id property of a component. The external-Id property is the primary key of an external
     *        storage system.
     */
    public static ListEntitiesFilter fromExternalId(String externalId) {
        return builder().externalId(externalId).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("parentEntityId", PARENT_ENTITY_ID_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesFilter, T> g) {
        return obj -> g.apply((ListEntitiesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListEntitiesFilter> {
        /**
         * <p>
         * The parent of the entities in the list.
         * </p>
         * 
         * @param parentEntityId
         *        The parent of the entities in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);

        /**
         * <p>
         * The ID of the component type in the entities in the list.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type in the entities in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The external-Id property of a component. The external-Id property is the primary key of an external storage
         * system.
         * </p>
         * 
         * @param externalId
         *        The external-Id property of a component. The external-Id property is the primary key of an external
         *        storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);
    }

    static final class BuilderImpl implements Builder {
        private String parentEntityId;

        private String componentTypeId;

        private String externalId;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesFilter model) {
            parentEntityId(model.parentEntityId);
            componentTypeId(model.componentTypeId);
            externalId(model.externalId);
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            Object oldValue = this.parentEntityId;
            this.parentEntityId = parentEntityId;
            handleUnionValueChange(Type.PARENT_ENTITY_ID, oldValue, this.parentEntityId);
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            Object oldValue = this.parentEntityId;
            this.parentEntityId = parentEntityId;
            handleUnionValueChange(Type.PARENT_ENTITY_ID, oldValue, this.parentEntityId);
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            Object oldValue = this.componentTypeId;
            this.componentTypeId = componentTypeId;
            handleUnionValueChange(Type.COMPONENT_TYPE_ID, oldValue, this.componentTypeId);
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            Object oldValue = this.componentTypeId;
            this.componentTypeId = componentTypeId;
            handleUnionValueChange(Type.COMPONENT_TYPE_ID, oldValue, this.componentTypeId);
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            Object oldValue = this.externalId;
            this.externalId = externalId;
            handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
        }

        @Override
        public final Builder externalId(String externalId) {
            Object oldValue = this.externalId;
            this.externalId = externalId;
            handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
            return this;
        }

        @Override
        public ListEntitiesFilter build() {
            return new ListEntitiesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ListEntitiesFilter#type()
     */
    public enum Type {
        PARENT_ENTITY_ID,

        COMPONENT_TYPE_ID,

        EXTERNAL_ID,

        UNKNOWN_TO_SDK_VERSION
    }
}
