/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListMetadataTransferJobs filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetadataTransferJobsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListMetadataTransferJobsFilter.Builder, ListMetadataTransferJobsFilter> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(ListMetadataTransferJobsFilter::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ListMetadataTransferJobsFilter::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workspaceId;

    private final String state;

    private final Type type;

    private ListMetadataTransferJobsFilter(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.state = builder.state;
        this.type = builder.type;
    }

    /**
     * <p>
     * The workspace Id.
     * </p>
     * 
     * @return The workspace Id.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The filter state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MetadataTransferJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The filter state.
     * @see MetadataTransferJobState
     */
    public final MetadataTransferJobState state() {
        return MetadataTransferJobState.fromValue(state);
    }

    /**
     * <p>
     * The filter state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MetadataTransferJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The filter state.
     * @see MetadataTransferJobState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetadataTransferJobsFilter)) {
            return false;
        }
        ListMetadataTransferJobsFilter other = (ListMetadataTransferJobsFilter) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetadataTransferJobsFilter").add("WorkspaceId", workspaceId()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #workspaceId()} initialized to the given value.
     *
     * <p>
     * The workspace Id.
     * </p>
     * 
     * @param workspaceId
     *        The workspace Id.
     */
    public static ListMetadataTransferJobsFilter fromWorkspaceId(String workspaceId) {
        return builder().workspaceId(workspaceId).build();
    }

    /**
     * Create an instance of this class with {@link #stateAsString()} initialized to the given value.
     *
     * <p>
     * The filter state.
     * </p>
     * 
     * @param state
     *        The filter state.
     * @see MetadataTransferJobState
     */
    public static ListMetadataTransferJobsFilter fromState(String state) {
        return builder().state(state).build();
    }

    /**
     * Create an instance of this class with {@link #stateAsString()} initialized to the given value.
     *
     * <p>
     * The filter state.
     * </p>
     * 
     * @param state
     *        The filter state.
     * @see MetadataTransferJobState
     */
    public static ListMetadataTransferJobsFilter fromState(MetadataTransferJobState state) {
        return builder().state(state).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetadataTransferJobsFilter, T> g) {
        return obj -> g.apply((ListMetadataTransferJobsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListMetadataTransferJobsFilter> {
        /**
         * <p>
         * The workspace Id.
         * </p>
         * 
         * @param workspaceId
         *        The workspace Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The filter state.
         * </p>
         * 
         * @param state
         *        The filter state.
         * @see MetadataTransferJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataTransferJobState
         */
        Builder state(String state);

        /**
         * <p>
         * The filter state.
         * </p>
         * 
         * @param state
         *        The filter state.
         * @see MetadataTransferJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataTransferJobState
         */
        Builder state(MetadataTransferJobState state);
    }

    static final class BuilderImpl implements Builder {
        private String workspaceId;

        private String state;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetadataTransferJobsFilter model) {
            workspaceId(model.workspaceId);
            state(model.state);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            Object oldValue = this.workspaceId;
            this.workspaceId = workspaceId;
            handleUnionValueChange(Type.WORKSPACE_ID, oldValue, this.workspaceId);
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            Object oldValue = this.workspaceId;
            this.workspaceId = workspaceId;
            handleUnionValueChange(Type.WORKSPACE_ID, oldValue, this.workspaceId);
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            Object oldValue = this.state;
            this.state = state;
            handleUnionValueChange(Type.STATE, oldValue, this.state);
        }

        @Override
        public final Builder state(String state) {
            Object oldValue = this.state;
            this.state = state;
            handleUnionValueChange(Type.STATE, oldValue, this.state);
            return this;
        }

        @Override
        public final Builder state(MetadataTransferJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public ListMetadataTransferJobsFilter build() {
            return new ListMetadataTransferJobsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ListMetadataTransferJobsFilter#type()
     */
    public enum Type {
        WORKSPACE_ID,

        STATE,

        UNKNOWN_TO_SDK_VERSION
    }
}
