/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetadataTransferJobsResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<ListMetadataTransferJobsResponse.Builder, ListMetadataTransferJobsResponse> {
    private static final SdkField<List<MetadataTransferJobSummary>> METADATA_TRANSFER_JOB_SUMMARIES_FIELD = SdkField
            .<List<MetadataTransferJobSummary>> builder(MarshallingType.LIST)
            .memberName("metadataTransferJobSummaries")
            .getter(getter(ListMetadataTransferJobsResponse::metadataTransferJobSummaries))
            .setter(setter(Builder::metadataTransferJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataTransferJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataTransferJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMetadataTransferJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METADATA_TRANSFER_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MetadataTransferJobSummary> metadataTransferJobSummaries;

    private final String nextToken;

    private ListMetadataTransferJobsResponse(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobSummaries = builder.metadataTransferJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataTransferJobSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetadataTransferJobSummaries() {
        return metadataTransferJobSummaries != null && !(metadataTransferJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata transfer job summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataTransferJobSummaries} method.
     * </p>
     * 
     * @return The metadata transfer job summaries.
     */
    public final List<MetadataTransferJobSummary> metadataTransferJobSummaries() {
        return metadataTransferJobSummaries;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataTransferJobSummaries() ? metadataTransferJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetadataTransferJobsResponse)) {
            return false;
        }
        ListMetadataTransferJobsResponse other = (ListMetadataTransferJobsResponse) obj;
        return hasMetadataTransferJobSummaries() == other.hasMetadataTransferJobSummaries()
                && Objects.equals(metadataTransferJobSummaries(), other.metadataTransferJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetadataTransferJobsResponse")
                .add("MetadataTransferJobSummaries", hasMetadataTransferJobSummaries() ? metadataTransferJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataTransferJobSummaries":
            return Optional.ofNullable(clazz.cast(metadataTransferJobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataTransferJobSummaries", METADATA_TRANSFER_JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetadataTransferJobsResponse, T> g) {
        return obj -> g.apply((ListMetadataTransferJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMetadataTransferJobsResponse> {
        /**
         * <p>
         * The metadata transfer job summaries.
         * </p>
         * 
         * @param metadataTransferJobSummaries
         *        The metadata transfer job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobSummaries(Collection<MetadataTransferJobSummary> metadataTransferJobSummaries);

        /**
         * <p>
         * The metadata transfer job summaries.
         * </p>
         * 
         * @param metadataTransferJobSummaries
         *        The metadata transfer job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobSummaries(MetadataTransferJobSummary... metadataTransferJobSummaries);

        /**
         * <p>
         * The metadata transfer job summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #metadataTransferJobSummaries(List<MetadataTransferJobSummary>)}.
         * 
         * @param metadataTransferJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataTransferJobSummaries(java.util.Collection<MetadataTransferJobSummary>)
         */
        Builder metadataTransferJobSummaries(Consumer<MetadataTransferJobSummary.Builder>... metadataTransferJobSummaries);

        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private List<MetadataTransferJobSummary> metadataTransferJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetadataTransferJobsResponse model) {
            super(model);
            metadataTransferJobSummaries(model.metadataTransferJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<MetadataTransferJobSummary.Builder> getMetadataTransferJobSummaries() {
            List<MetadataTransferJobSummary.Builder> result = MetadataTransferJobSummariesCopier
                    .copyToBuilder(this.metadataTransferJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataTransferJobSummaries(
                Collection<MetadataTransferJobSummary.BuilderImpl> metadataTransferJobSummaries) {
            this.metadataTransferJobSummaries = MetadataTransferJobSummariesCopier.copyFromBuilder(metadataTransferJobSummaries);
        }

        @Override
        public final Builder metadataTransferJobSummaries(Collection<MetadataTransferJobSummary> metadataTransferJobSummaries) {
            this.metadataTransferJobSummaries = MetadataTransferJobSummariesCopier.copy(metadataTransferJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataTransferJobSummaries(MetadataTransferJobSummary... metadataTransferJobSummaries) {
            metadataTransferJobSummaries(Arrays.asList(metadataTransferJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataTransferJobSummaries(
                Consumer<MetadataTransferJobSummary.Builder>... metadataTransferJobSummaries) {
            metadataTransferJobSummaries(Stream.of(metadataTransferJobSummaries)
                    .map(c -> MetadataTransferJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMetadataTransferJobsResponse build() {
            return new ListMetadataTransferJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
