/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSyncJobsResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<ListSyncJobsResponse.Builder, ListSyncJobsResponse> {
    private static final SdkField<List<SyncJobSummary>> SYNC_JOB_SUMMARIES_FIELD = SdkField
            .<List<SyncJobSummary>> builder(MarshallingType.LIST)
            .memberName("syncJobSummaries")
            .getter(getter(ListSyncJobsResponse::syncJobSummaries))
            .setter(setter(Builder::syncJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SyncJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyncJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSyncJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SyncJobSummary> syncJobSummaries;

    private final String nextToken;

    private ListSyncJobsResponse(BuilderImpl builder) {
        super(builder);
        this.syncJobSummaries = builder.syncJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SyncJobSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSyncJobSummaries() {
        return syncJobSummaries != null && !(syncJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listed SyncJob summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSyncJobSummaries} method.
     * </p>
     * 
     * @return The listed SyncJob summaries.
     */
    public final List<SyncJobSummary> syncJobSummaries() {
        return syncJobSummaries;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSyncJobSummaries() ? syncJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSyncJobsResponse)) {
            return false;
        }
        ListSyncJobsResponse other = (ListSyncJobsResponse) obj;
        return hasSyncJobSummaries() == other.hasSyncJobSummaries()
                && Objects.equals(syncJobSummaries(), other.syncJobSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSyncJobsResponse")
                .add("SyncJobSummaries", hasSyncJobSummaries() ? syncJobSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "syncJobSummaries":
            return Optional.ofNullable(clazz.cast(syncJobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("syncJobSummaries", SYNC_JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSyncJobsResponse, T> g) {
        return obj -> g.apply((ListSyncJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSyncJobsResponse> {
        /**
         * <p>
         * The listed SyncJob summaries.
         * </p>
         * 
         * @param syncJobSummaries
         *        The listed SyncJob summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncJobSummaries(Collection<SyncJobSummary> syncJobSummaries);

        /**
         * <p>
         * The listed SyncJob summaries.
         * </p>
         * 
         * @param syncJobSummaries
         *        The listed SyncJob summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncJobSummaries(SyncJobSummary... syncJobSummaries);

        /**
         * <p>
         * The listed SyncJob summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #syncJobSummaries(List<SyncJobSummary>)}.
         * 
         * @param syncJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncJobSummaries(java.util.Collection<SyncJobSummary>)
         */
        Builder syncJobSummaries(Consumer<SyncJobSummary.Builder>... syncJobSummaries);

        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private List<SyncJobSummary> syncJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSyncJobsResponse model) {
            super(model);
            syncJobSummaries(model.syncJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<SyncJobSummary.Builder> getSyncJobSummaries() {
            List<SyncJobSummary.Builder> result = SyncJobSummariesCopier.copyToBuilder(this.syncJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSyncJobSummaries(Collection<SyncJobSummary.BuilderImpl> syncJobSummaries) {
            this.syncJobSummaries = SyncJobSummariesCopier.copyFromBuilder(syncJobSummaries);
        }

        @Override
        public final Builder syncJobSummaries(Collection<SyncJobSummary> syncJobSummaries) {
            this.syncJobSummaries = SyncJobSummariesCopier.copy(syncJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncJobSummaries(SyncJobSummary... syncJobSummaries) {
            syncJobSummaries(Arrays.asList(syncJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncJobSummaries(Consumer<SyncJobSummary.Builder>... syncJobSummaries) {
            syncJobSummaries(Stream.of(syncJobSummaries).map(c -> SyncJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSyncJobsResponse build() {
            return new ListSyncJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
