/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The latest value of the property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyLatestValue implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyLatestValue.Builder, PropertyLatestValue> {
    private static final SdkField<EntityPropertyReference> PROPERTY_REFERENCE_FIELD = SdkField
            .<EntityPropertyReference> builder(MarshallingType.SDK_POJO).memberName("propertyReference")
            .getter(getter(PropertyLatestValue::propertyReference)).setter(setter(Builder::propertyReference))
            .constructor(EntityPropertyReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyReference").build()).build();

    private static final SdkField<DataValue> PROPERTY_VALUE_FIELD = SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
            .memberName("propertyValue").getter(getter(PropertyLatestValue::propertyValue))
            .setter(setter(Builder::propertyValue)).constructor(DataValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_REFERENCE_FIELD,
            PROPERTY_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EntityPropertyReference propertyReference;

    private final DataValue propertyValue;

    private PropertyLatestValue(BuilderImpl builder) {
        this.propertyReference = builder.propertyReference;
        this.propertyValue = builder.propertyValue;
    }

    /**
     * <p>
     * An object that specifies information about a property.
     * </p>
     * 
     * @return An object that specifies information about a property.
     */
    public final EntityPropertyReference propertyReference() {
        return propertyReference;
    }

    /**
     * <p>
     * The value of the property.
     * </p>
     * 
     * @return The value of the property.
     */
    public final DataValue propertyValue() {
        return propertyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyReference());
        hashCode = 31 * hashCode + Objects.hashCode(propertyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyLatestValue)) {
            return false;
        }
        PropertyLatestValue other = (PropertyLatestValue) obj;
        return Objects.equals(propertyReference(), other.propertyReference())
                && Objects.equals(propertyValue(), other.propertyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyLatestValue").add("PropertyReference", propertyReference())
                .add("PropertyValue", propertyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "propertyReference":
            return Optional.ofNullable(clazz.cast(propertyReference()));
        case "propertyValue":
            return Optional.ofNullable(clazz.cast(propertyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("propertyReference", PROPERTY_REFERENCE_FIELD);
        map.put("propertyValue", PROPERTY_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyLatestValue, T> g) {
        return obj -> g.apply((PropertyLatestValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyLatestValue> {
        /**
         * <p>
         * An object that specifies information about a property.
         * </p>
         * 
         * @param propertyReference
         *        An object that specifies information about a property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyReference(EntityPropertyReference propertyReference);

        /**
         * <p>
         * An object that specifies information about a property.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityPropertyReference.Builder} avoiding
         * the need to create one manually via {@link EntityPropertyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityPropertyReference.Builder#build()} is called immediately
         * and its result is passed to {@link #propertyReference(EntityPropertyReference)}.
         * 
         * @param propertyReference
         *        a consumer that will call methods on {@link EntityPropertyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyReference(EntityPropertyReference)
         */
        default Builder propertyReference(Consumer<EntityPropertyReference.Builder> propertyReference) {
            return propertyReference(EntityPropertyReference.builder().applyMutation(propertyReference).build());
        }

        /**
         * <p>
         * The value of the property.
         * </p>
         * 
         * @param propertyValue
         *        The value of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValue(DataValue propertyValue);

        /**
         * <p>
         * The value of the property.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataValue.Builder} avoiding the need to
         * create one manually via {@link DataValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataValue.Builder#build()} is called immediately and its result
         * is passed to {@link #propertyValue(DataValue)}.
         * 
         * @param propertyValue
         *        a consumer that will call methods on {@link DataValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyValue(DataValue)
         */
        default Builder propertyValue(Consumer<DataValue.Builder> propertyValue) {
            return propertyValue(DataValue.builder().applyMutation(propertyValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EntityPropertyReference propertyReference;

        private DataValue propertyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyLatestValue model) {
            propertyReference(model.propertyReference);
            propertyValue(model.propertyValue);
        }

        public final EntityPropertyReference.Builder getPropertyReference() {
            return propertyReference != null ? propertyReference.toBuilder() : null;
        }

        public final void setPropertyReference(EntityPropertyReference.BuilderImpl propertyReference) {
            this.propertyReference = propertyReference != null ? propertyReference.build() : null;
        }

        @Override
        public final Builder propertyReference(EntityPropertyReference propertyReference) {
            this.propertyReference = propertyReference;
            return this;
        }

        public final DataValue.Builder getPropertyValue() {
            return propertyValue != null ? propertyValue.toBuilder() : null;
        }

        public final void setPropertyValue(DataValue.BuilderImpl propertyValue) {
            this.propertyValue = propertyValue != null ? propertyValue.build() : null;
        }

        @Override
        public final Builder propertyValue(DataValue propertyValue) {
            this.propertyValue = propertyValue;
            return this;
        }

        @Override
        public PropertyLatestValue build() {
            return new PropertyLatestValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
