/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that sets information about a property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyRequest implements SdkPojo, Serializable, ToCopyableBuilder<PropertyRequest.Builder, PropertyRequest> {
    private static final SdkField<PropertyDefinitionRequest> DEFINITION_FIELD = SdkField
            .<PropertyDefinitionRequest> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(PropertyRequest::definition)).setter(setter(Builder::definition))
            .constructor(PropertyDefinitionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<DataValue> VALUE_FIELD = SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(PropertyRequest::value)).setter(setter(Builder::value))
            .constructor(DataValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateType").getter(getter(PropertyRequest::updateTypeAsString)).setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, VALUE_FIELD,
            UPDATE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PropertyDefinitionRequest definition;

    private final DataValue value;

    private final String updateType;

    private PropertyRequest(BuilderImpl builder) {
        this.definition = builder.definition;
        this.value = builder.value;
        this.updateType = builder.updateType;
    }

    /**
     * <p>
     * An object that specifies information about a property.
     * </p>
     * 
     * @return An object that specifies information about a property.
     */
    public final PropertyDefinitionRequest definition() {
        return definition;
    }

    /**
     * <p>
     * The value of the property.
     * </p>
     * 
     * @return The value of the property.
     */
    public final DataValue value() {
        return value;
    }

    /**
     * <p>
     * The update type of the update property request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link PropertyUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The update type of the update property request.
     * @see PropertyUpdateType
     */
    public final PropertyUpdateType updateType() {
        return PropertyUpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The update type of the update property request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link PropertyUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The update type of the update property request.
     * @see PropertyUpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyRequest)) {
            return false;
        }
        PropertyRequest other = (PropertyRequest) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(value(), other.value())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyRequest").add("Definition", definition()).add("Value", value())
                .add("UpdateType", updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("definition", DEFINITION_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyRequest, T> g) {
        return obj -> g.apply((PropertyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyRequest> {
        /**
         * <p>
         * An object that specifies information about a property.
         * </p>
         * 
         * @param definition
         *        An object that specifies information about a property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(PropertyDefinitionRequest definition);

        /**
         * <p>
         * An object that specifies information about a property.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyDefinitionRequest.Builder}
         * avoiding the need to create one manually via {@link PropertyDefinitionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyDefinitionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(PropertyDefinitionRequest)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link PropertyDefinitionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(PropertyDefinitionRequest)
         */
        default Builder definition(Consumer<PropertyDefinitionRequest.Builder> definition) {
            return definition(PropertyDefinitionRequest.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The value of the property.
         * </p>
         * 
         * @param value
         *        The value of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DataValue value);

        /**
         * <p>
         * The value of the property.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataValue.Builder} avoiding the need to
         * create one manually via {@link DataValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(DataValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DataValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DataValue)
         */
        default Builder value(Consumer<DataValue.Builder> value) {
            return value(DataValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The update type of the update property request.
         * </p>
         * 
         * @param updateType
         *        The update type of the update property request.
         * @see PropertyUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyUpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The update type of the update property request.
         * </p>
         * 
         * @param updateType
         *        The update type of the update property request.
         * @see PropertyUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyUpdateType
         */
        Builder updateType(PropertyUpdateType updateType);
    }

    static final class BuilderImpl implements Builder {
        private PropertyDefinitionRequest definition;

        private DataValue value;

        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyRequest model) {
            definition(model.definition);
            value(model.value);
            updateType(model.updateType);
        }

        public final PropertyDefinitionRequest.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(PropertyDefinitionRequest.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PropertyDefinitionRequest definition) {
            this.definition = definition;
            return this;
        }

        public final DataValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(PropertyUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public PropertyRequest build() {
            return new PropertyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
