/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies a relationship with another component type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Relationship implements SdkPojo, Serializable, ToCopyableBuilder<Relationship.Builder, Relationship> {
    private static final SdkField<String> TARGET_COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetComponentTypeId").getter(getter(Relationship::targetComponentTypeId))
            .setter(setter(Builder::targetComponentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetComponentTypeId").build())
            .build();

    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationshipType").getter(getter(Relationship::relationshipType))
            .setter(setter(Builder::relationshipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TARGET_COMPONENT_TYPE_ID_FIELD, RELATIONSHIP_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetComponentTypeId;

    private final String relationshipType;

    private Relationship(BuilderImpl builder) {
        this.targetComponentTypeId = builder.targetComponentTypeId;
        this.relationshipType = builder.relationshipType;
    }

    /**
     * <p>
     * The ID of the target component type associated with this relationship.
     * </p>
     * 
     * @return The ID of the target component type associated with this relationship.
     */
    public final String targetComponentTypeId() {
        return targetComponentTypeId;
    }

    /**
     * <p>
     * The type of the relationship.
     * </p>
     * 
     * @return The type of the relationship.
     */
    public final String relationshipType() {
        return relationshipType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetComponentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship) obj;
        return Objects.equals(targetComponentTypeId(), other.targetComponentTypeId())
                && Objects.equals(relationshipType(), other.relationshipType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Relationship").add("TargetComponentTypeId", targetComponentTypeId())
                .add("RelationshipType", relationshipType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetComponentTypeId":
            return Optional.ofNullable(clazz.cast(targetComponentTypeId()));
        case "relationshipType":
            return Optional.ofNullable(clazz.cast(relationshipType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetComponentTypeId", TARGET_COMPONENT_TYPE_ID_FIELD);
        map.put("relationshipType", RELATIONSHIP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Relationship, T> g) {
        return obj -> g.apply((Relationship) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Relationship> {
        /**
         * <p>
         * The ID of the target component type associated with this relationship.
         * </p>
         * 
         * @param targetComponentTypeId
         *        The ID of the target component type associated with this relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetComponentTypeId(String targetComponentTypeId);

        /**
         * <p>
         * The type of the relationship.
         * </p>
         * 
         * @param relationshipType
         *        The type of the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipType(String relationshipType);
    }

    static final class BuilderImpl implements Builder {
        private String targetComponentTypeId;

        private String relationshipType;

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            targetComponentTypeId(model.targetComponentTypeId);
            relationshipType(model.relationshipType);
        }

        public final String getTargetComponentTypeId() {
            return targetComponentTypeId;
        }

        public final void setTargetComponentTypeId(String targetComponentTypeId) {
            this.targetComponentTypeId = targetComponentTypeId;
        }

        @Override
        public final Builder targetComponentTypeId(String targetComponentTypeId) {
            this.targetComponentTypeId = targetComponentTypeId;
            return this;
        }

        public final String getRelationshipType() {
            return relationshipType;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public Relationship build() {
            return new Relationship(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
