/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sync resource filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncResourceFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SyncResourceFilter.Builder, SyncResourceFilter> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(SyncResourceFilter::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(SyncResourceFilter::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(SyncResourceFilter::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(SyncResourceFilter::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, EXTERNAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String resourceType;

    private final String resourceId;

    private final String externalId;

    private final Type type;

    private SyncResourceFilter(BuilderImpl builder) {
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.externalId = builder.externalId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The sync resource filter's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SyncResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The sync resource filter's state.
     * @see SyncResourceState
     */
    public final SyncResourceState state() {
        return SyncResourceState.fromValue(state);
    }

    /**
     * <p>
     * The sync resource filter's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SyncResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The sync resource filter's state.
     * @see SyncResourceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The sync resource filter resource type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link SyncResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The sync resource filter resource type
     * @see SyncResourceType
     */
    public final SyncResourceType resourceType() {
        return SyncResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The sync resource filter resource type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link SyncResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The sync resource filter resource type
     * @see SyncResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The sync resource filter resource ID.
     * </p>
     * 
     * @return The sync resource filter resource ID.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The external ID.
     * </p>
     * 
     * @return The external ID.
     */
    public final String externalId() {
        return externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncResourceFilter)) {
            return false;
        }
        SyncResourceFilter other = (SyncResourceFilter) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(externalId(), other.externalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncResourceFilter").add("State", stateAsString()).add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).add("ExternalId", externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stateAsString()} initialized to the given value.
     *
     * <p>
     * The sync resource filter's state.
     * </p>
     * 
     * @param state
     *        The sync resource filter's state.
     * @see SyncResourceState
     */
    public static SyncResourceFilter fromState(String state) {
        return builder().state(state).build();
    }

    /**
     * Create an instance of this class with {@link #stateAsString()} initialized to the given value.
     *
     * <p>
     * The sync resource filter's state.
     * </p>
     * 
     * @param state
     *        The sync resource filter's state.
     * @see SyncResourceState
     */
    public static SyncResourceFilter fromState(SyncResourceState state) {
        return builder().state(state).build();
    }

    /**
     * Create an instance of this class with {@link #resourceTypeAsString()} initialized to the given value.
     *
     * <p>
     * The sync resource filter resource type
     * </p>
     * 
     * @param resourceType
     *        The sync resource filter resource type
     * @see SyncResourceType
     */
    public static SyncResourceFilter fromResourceType(String resourceType) {
        return builder().resourceType(resourceType).build();
    }

    /**
     * Create an instance of this class with {@link #resourceTypeAsString()} initialized to the given value.
     *
     * <p>
     * The sync resource filter resource type
     * </p>
     * 
     * @param resourceType
     *        The sync resource filter resource type
     * @see SyncResourceType
     */
    public static SyncResourceFilter fromResourceType(SyncResourceType resourceType) {
        return builder().resourceType(resourceType).build();
    }

    /**
     * Create an instance of this class with {@link #resourceId()} initialized to the given value.
     *
     * <p>
     * The sync resource filter resource ID.
     * </p>
     * 
     * @param resourceId
     *        The sync resource filter resource ID.
     */
    public static SyncResourceFilter fromResourceId(String resourceId) {
        return builder().resourceId(resourceId).build();
    }

    /**
     * Create an instance of this class with {@link #externalId()} initialized to the given value.
     *
     * <p>
     * The external ID.
     * </p>
     * 
     * @param externalId
     *        The external ID.
     */
    public static SyncResourceFilter fromExternalId(String externalId) {
        return builder().externalId(externalId).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("state", STATE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyncResourceFilter, T> g) {
        return obj -> g.apply((SyncResourceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncResourceFilter> {
        /**
         * <p>
         * The sync resource filter's state.
         * </p>
         * 
         * @param state
         *        The sync resource filter's state.
         * @see SyncResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncResourceState
         */
        Builder state(String state);

        /**
         * <p>
         * The sync resource filter's state.
         * </p>
         * 
         * @param state
         *        The sync resource filter's state.
         * @see SyncResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncResourceState
         */
        Builder state(SyncResourceState state);

        /**
         * <p>
         * The sync resource filter resource type
         * </p>
         * 
         * @param resourceType
         *        The sync resource filter resource type
         * @see SyncResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The sync resource filter resource type
         * </p>
         * 
         * @param resourceType
         *        The sync resource filter resource type
         * @see SyncResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncResourceType
         */
        Builder resourceType(SyncResourceType resourceType);

        /**
         * <p>
         * The sync resource filter resource ID.
         * </p>
         * 
         * @param resourceId
         *        The sync resource filter resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The external ID.
         * </p>
         * 
         * @param externalId
         *        The external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String resourceType;

        private String resourceId;

        private String externalId;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SyncResourceFilter model) {
            state(model.state);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            externalId(model.externalId);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            Object oldValue = this.state;
            this.state = state;
            handleUnionValueChange(Type.STATE, oldValue, this.state);
        }

        @Override
        public final Builder state(String state) {
            Object oldValue = this.state;
            this.state = state;
            handleUnionValueChange(Type.STATE, oldValue, this.state);
            return this;
        }

        @Override
        public final Builder state(SyncResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            Object oldValue = this.resourceType;
            this.resourceType = resourceType;
            handleUnionValueChange(Type.RESOURCE_TYPE, oldValue, this.resourceType);
        }

        @Override
        public final Builder resourceType(String resourceType) {
            Object oldValue = this.resourceType;
            this.resourceType = resourceType;
            handleUnionValueChange(Type.RESOURCE_TYPE, oldValue, this.resourceType);
            return this;
        }

        @Override
        public final Builder resourceType(SyncResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            Object oldValue = this.resourceId;
            this.resourceId = resourceId;
            handleUnionValueChange(Type.RESOURCE_ID, oldValue, this.resourceId);
        }

        @Override
        public final Builder resourceId(String resourceId) {
            Object oldValue = this.resourceId;
            this.resourceId = resourceId;
            handleUnionValueChange(Type.RESOURCE_ID, oldValue, this.resourceId);
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            Object oldValue = this.externalId;
            this.externalId = externalId;
            handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
        }

        @Override
        public final Builder externalId(String externalId) {
            Object oldValue = this.externalId;
            this.externalId = externalId;
            handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
            return this;
        }

        @Override
        public SyncResourceFilter build() {
            return new SyncResourceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SyncResourceFilter#type()
     */
    public enum Type {
        STATE,

        RESOURCE_TYPE,

        RESOURCE_ID,

        EXTERNAL_ID,

        UNKNOWN_TO_SDK_VERSION
    }
}
