/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupResponsesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentSummary> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ComponentSummary.getter(ComponentSummary::componentName)).setter(ComponentSummary.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(ComponentSummary.getter(ComponentSummary::componentTypeId)).setter(ComponentSummary.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> DEFINED_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definedIn").getter(ComponentSummary.getter(ComponentSummary::definedIn)).setter(ComponentSummary.setter(Builder::definedIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definedIn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentSummary.getter(ComponentSummary::description)).setter(ComponentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, ComponentPropertyGroupResponse>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroups").getter(ComponentSummary.getter(ComponentSummary::propertyGroups)).setter(ComponentSummary.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPropertyGroupResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Status> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ComponentSummary.getter(ComponentSummary::status)).setter(ComponentSummary.setter(Builder::status)).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(ComponentSummary.getter(ComponentSummary::syncSource)).setter(ComponentSummary.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()}).build();
    private static final SdkField<String> COMPONENT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentPath").getter(ComponentSummary.getter(ComponentSummary::componentPath)).setter(ComponentSummary.setter(Builder::componentPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_TYPE_ID_FIELD, DEFINED_IN_FIELD, DESCRIPTION_FIELD, PROPERTY_GROUPS_FIELD, STATUS_FIELD, SYNC_SOURCE_FIELD, COMPONENT_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String componentTypeId;
    private final String definedIn;
    private final String description;
    private final Map<String, ComponentPropertyGroupResponse> propertyGroups;
    private final Status status;
    private final String syncSource;
    private final String componentPath;

    private ComponentSummary(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentTypeId = builder.componentTypeId;
        this.definedIn = builder.definedIn;
        this.description = builder.description;
        this.propertyGroups = builder.propertyGroups;
        this.status = builder.status;
        this.syncSource = builder.syncSource;
        this.componentPath = builder.componentPath;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String definedIn() {
        return this.definedIn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentPropertyGroupResponse> propertyGroups() {
        return this.propertyGroups;
    }

    public final Status status() {
        return this.status;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    public final String componentPath() {
        return this.componentPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definedIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSummary)) {
            return false;
        }
        ComponentSummary other = (ComponentSummary)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.definedIn(), other.definedIn()) && Objects.equals(this.description(), other.description()) && this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.syncSource(), other.syncSource()) && Objects.equals(this.componentPath(), other.componentPath());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentSummary").add("ComponentName", (Object)this.componentName()).add("ComponentTypeId", (Object)this.componentTypeId()).add("DefinedIn", (Object)this.definedIn()).add("Description", (Object)this.description()).add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).add("Status", (Object)this.status()).add("SyncSource", (Object)this.syncSource()).add("ComponentPath", (Object)this.componentPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "definedIn": {
                return Optional.ofNullable(clazz.cast(this.definedIn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "propertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
            case "componentPath": {
                return Optional.ofNullable(clazz.cast(this.componentPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("definedIn", DEFINED_IN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("propertyGroups", PROPERTY_GROUPS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("syncSource", SYNC_SOURCE_FIELD);
        map.put("componentPath", COMPONENT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentSummary, T> g) {
        return obj -> g.apply((ComponentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String componentTypeId;
        private String definedIn;
        private String description;
        private Map<String, ComponentPropertyGroupResponse> propertyGroups = DefaultSdkAutoConstructMap.getInstance();
        private Status status;
        private String syncSource;
        private String componentPath;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentSummary model) {
            this.componentName(model.componentName);
            this.componentTypeId(model.componentTypeId);
            this.definedIn(model.definedIn);
            this.description(model.description);
            this.propertyGroups(model.propertyGroups);
            this.status(model.status);
            this.syncSource(model.syncSource);
            this.componentPath(model.componentPath);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDefinedIn() {
            return this.definedIn;
        }

        public final void setDefinedIn(String definedIn) {
            this.definedIn = definedIn;
        }

        @Override
        public final Builder definedIn(String definedIn) {
            this.definedIn = definedIn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ComponentPropertyGroupResponse.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupResponse.Builder> result = ComponentPropertyGroupResponsesCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupResponse.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copy(propertyGroups);
            return this;
        }

        public final Status.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getComponentPath() {
            return this.componentPath;
        }

        public final void setComponentPath(String componentPath) {
            this.componentPath = componentPath;
        }

        @Override
        public final Builder componentPath(String componentPath) {
            this.componentPath = componentPath;
            return this;
        }

        public ComponentSummary build() {
            return new ComponentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentSummary> {
        public Builder componentName(String var1);

        public Builder componentTypeId(String var1);

        public Builder definedIn(String var1);

        public Builder description(String var1);

        public Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> var1);

        public Builder status(Status var1);

        default public Builder status(Consumer<Status.Builder> status) {
            return this.status((Status)((Status.Builder)Status.builder().applyMutation(status)).build());
        }

        public Builder syncSource(String var1);

        public Builder componentPath(String var1);
    }
}

