/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The component property group response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentPropertyGroupResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentPropertyGroupResponse.Builder, ComponentPropertyGroupResponse> {
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupType").getter(getter(ComponentPropertyGroupResponse::groupTypeAsString))
            .setter(setter(Builder::groupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupType").build()).build();

    private static final SdkField<List<String>> PROPERTY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("propertyNames")
            .getter(getter(ComponentPropertyGroupResponse::propertyNames))
            .setter(setter(Builder::propertyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isInherited").getter(getter(ComponentPropertyGroupResponse::isInherited))
            .setter(setter(Builder::isInherited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_TYPE_FIELD,
            PROPERTY_NAMES_FIELD, IS_INHERITED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupType;

    private final List<String> propertyNames;

    private final Boolean isInherited;

    private ComponentPropertyGroupResponse(BuilderImpl builder) {
        this.groupType = builder.groupType;
        this.propertyNames = builder.propertyNames;
        this.isInherited = builder.isInherited;
    }

    /**
     * <p>
     * The group type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The group type.
     * @see GroupType
     */
    public final GroupType groupType() {
        return GroupType.fromValue(groupType);
    }

    /**
     * <p>
     * The group type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The group type.
     * @see GroupType
     */
    public final String groupTypeAsString() {
        return groupType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyNames() {
        return propertyNames != null && !(propertyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of properties
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyNames} method.
     * </p>
     * 
     * @return The names of properties
     */
    public final List<String> propertyNames() {
        return propertyNames;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property group is inherited from a parent entity
     * </p>
     * 
     * @return A Boolean value that specifies whether the property group is inherited from a parent entity
     */
    public final Boolean isInherited() {
        return isInherited;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyNames() ? propertyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isInherited());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentPropertyGroupResponse)) {
            return false;
        }
        ComponentPropertyGroupResponse other = (ComponentPropertyGroupResponse) obj;
        return Objects.equals(groupTypeAsString(), other.groupTypeAsString()) && hasPropertyNames() == other.hasPropertyNames()
                && Objects.equals(propertyNames(), other.propertyNames()) && Objects.equals(isInherited(), other.isInherited());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentPropertyGroupResponse").add("GroupType", groupTypeAsString())
                .add("PropertyNames", hasPropertyNames() ? propertyNames() : null).add("IsInherited", isInherited()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupType":
            return Optional.ofNullable(clazz.cast(groupTypeAsString()));
        case "propertyNames":
            return Optional.ofNullable(clazz.cast(propertyNames()));
        case "isInherited":
            return Optional.ofNullable(clazz.cast(isInherited()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("groupType", GROUP_TYPE_FIELD);
        map.put("propertyNames", PROPERTY_NAMES_FIELD);
        map.put("isInherited", IS_INHERITED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentPropertyGroupResponse, T> g) {
        return obj -> g.apply((ComponentPropertyGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentPropertyGroupResponse> {
        /**
         * <p>
         * The group type.
         * </p>
         * 
         * @param groupType
         *        The group type.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(String groupType);

        /**
         * <p>
         * The group type.
         * </p>
         * 
         * @param groupType
         *        The group type.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(GroupType groupType);

        /**
         * <p>
         * The names of properties
         * </p>
         * 
         * @param propertyNames
         *        The names of properties
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyNames(Collection<String> propertyNames);

        /**
         * <p>
         * The names of properties
         * </p>
         * 
         * @param propertyNames
         *        The names of properties
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyNames(String... propertyNames);

        /**
         * <p>
         * A Boolean value that specifies whether the property group is inherited from a parent entity
         * </p>
         * 
         * @param isInherited
         *        A Boolean value that specifies whether the property group is inherited from a parent entity
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isInherited(Boolean isInherited);
    }

    static final class BuilderImpl implements Builder {
        private String groupType;

        private List<String> propertyNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean isInherited;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentPropertyGroupResponse model) {
            groupType(model.groupType);
            propertyNames(model.propertyNames);
            isInherited(model.isInherited);
        }

        public final String getGroupType() {
            return groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Collection<String> getPropertyNames() {
            if (propertyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return propertyNames;
        }

        public final void setPropertyNames(Collection<String> propertyNames) {
            this.propertyNames = PropertyNamesCopier.copy(propertyNames);
        }

        @Override
        public final Builder propertyNames(Collection<String> propertyNames) {
            this.propertyNames = PropertyNamesCopier.copy(propertyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyNames(String... propertyNames) {
            propertyNames(Arrays.asList(propertyNames));
            return this;
        }

        public final Boolean getIsInherited() {
            return isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        @Override
        public ComponentPropertyGroupResponse build() {
            return new ComponentPropertyGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
