/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that returns information about the composite component types of a component type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositeComponentTypeResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositeComponentTypeResponse.Builder, CompositeComponentTypeResponse> {
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(CompositeComponentTypeResponse::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isInherited").getter(getter(CompositeComponentTypeResponse::isInherited))
            .setter(setter(Builder::isInherited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_ID_FIELD,
            IS_INHERITED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentTypeId;

    private final Boolean isInherited;

    private CompositeComponentTypeResponse(BuilderImpl builder) {
        this.componentTypeId = builder.componentTypeId;
        this.isInherited = builder.isInherited;
    }

    /**
     * <p>
     * This is the <code>componentTypeId</code> that this <code>compositeComponentType</code> refers to.
     * </p>
     * 
     * @return This is the <code>componentTypeId</code> that this <code>compositeComponentType</code> refers to.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * This boolean indicates whether this <code>compositeComponentType</code> is inherited from its parent.
     * </p>
     * 
     * @return This boolean indicates whether this <code>compositeComponentType</code> is inherited from its parent.
     */
    public final Boolean isInherited() {
        return isInherited;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(isInherited());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeComponentTypeResponse)) {
            return false;
        }
        CompositeComponentTypeResponse other = (CompositeComponentTypeResponse) obj;
        return Objects.equals(componentTypeId(), other.componentTypeId()) && Objects.equals(isInherited(), other.isInherited());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositeComponentTypeResponse").add("ComponentTypeId", componentTypeId())
                .add("IsInherited", isInherited()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "isInherited":
            return Optional.ofNullable(clazz.cast(isInherited()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("isInherited", IS_INHERITED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositeComponentTypeResponse, T> g) {
        return obj -> g.apply((CompositeComponentTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositeComponentTypeResponse> {
        /**
         * <p>
         * This is the <code>componentTypeId</code> that this <code>compositeComponentType</code> refers to.
         * </p>
         * 
         * @param componentTypeId
         *        This is the <code>componentTypeId</code> that this <code>compositeComponentType</code> refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * This boolean indicates whether this <code>compositeComponentType</code> is inherited from its parent.
         * </p>
         * 
         * @param isInherited
         *        This boolean indicates whether this <code>compositeComponentType</code> is inherited from its parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isInherited(Boolean isInherited);
    }

    static final class BuilderImpl implements Builder {
        private String componentTypeId;

        private Boolean isInherited;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeComponentTypeResponse model) {
            componentTypeId(model.componentTypeId);
            isInherited(model.isInherited);
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Boolean getIsInherited() {
            return isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        @Override
        public CompositeComponentTypeResponse build() {
            return new CompositeComponentTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
