/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetadataTransferJobResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetMetadataTransferJobResponse.Builder, GetMetadataTransferJobResponse> {
    private static final SdkField<String> METADATA_TRANSFER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataTransferJobId").getter(getter(GetMetadataTransferJobResponse::metadataTransferJobId))
            .setter(setter(Builder::metadataTransferJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobId").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetMetadataTransferJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetMetadataTransferJobResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SourceConfiguration>> SOURCES_FIELD = SdkField
            .<List<SourceConfiguration>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(GetMetadataTransferJobResponse::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(GetMetadataTransferJobResponse::destination)).setter(setter(Builder::destination))
            .constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> METADATA_TRANSFER_JOB_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataTransferJobRole").getter(getter(GetMetadataTransferJobResponse::metadataTransferJobRole))
            .setter(setter(Builder::metadataTransferJobRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobRole").build())
            .build();

    private static final SdkField<String> REPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportUrl").getter(getter(GetMetadataTransferJobResponse::reportUrl)).setter(setter(Builder::reportUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportUrl").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GetMetadataTransferJobResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(GetMetadataTransferJobResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<MetadataTransferJobStatus> STATUS_FIELD = SdkField
            .<MetadataTransferJobStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(GetMetadataTransferJobResponse::status)).setter(setter(Builder::status))
            .constructor(MetadataTransferJobStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<MetadataTransferJobProgress> PROGRESS_FIELD = SdkField
            .<MetadataTransferJobProgress> builder(MarshallingType.SDK_POJO).memberName("progress")
            .getter(getter(GetMetadataTransferJobResponse::progress)).setter(setter(Builder::progress))
            .constructor(MetadataTransferJobProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METADATA_TRANSFER_JOB_ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD, DESTINATION_FIELD,
            METADATA_TRANSFER_JOB_ROLE_FIELD, REPORT_URL_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, STATUS_FIELD,
            PROGRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metadataTransferJobId;

    private final String arn;

    private final String description;

    private final List<SourceConfiguration> sources;

    private final DestinationConfiguration destination;

    private final String metadataTransferJobRole;

    private final String reportUrl;

    private final Instant creationDateTime;

    private final Instant updateDateTime;

    private final MetadataTransferJobStatus status;

    private final MetadataTransferJobProgress progress;

    private GetMetadataTransferJobResponse(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobId = builder.metadataTransferJobId;
        this.arn = builder.arn;
        this.description = builder.description;
        this.sources = builder.sources;
        this.destination = builder.destination;
        this.metadataTransferJobRole = builder.metadataTransferJobRole;
        this.reportUrl = builder.reportUrl;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.status = builder.status;
        this.progress = builder.progress;
    }

    /**
     * <p>
     * The metadata transfer job Id.
     * </p>
     * 
     * @return The metadata transfer job Id.
     */
    public final String metadataTransferJobId() {
        return metadataTransferJobId;
    }

    /**
     * <p>
     * The metadata transfer job ARN.
     * </p>
     * 
     * @return The metadata transfer job ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The metadata transfer job description.
     * </p>
     * 
     * @return The metadata transfer job description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata transfer job's sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The metadata transfer job's sources.
     */
    public final List<SourceConfiguration> sources() {
        return sources;
    }

    /**
     * <p>
     * The metadata transfer job's destination.
     * </p>
     * 
     * @return The metadata transfer job's destination.
     */
    public final DestinationConfiguration destination() {
        return destination;
    }

    /**
     * <p>
     * The metadata transfer job's role.
     * </p>
     * 
     * @return The metadata transfer job's role.
     */
    public final String metadataTransferJobRole() {
        return metadataTransferJobRole;
    }

    /**
     * <p>
     * The metadata transfer job's report URL.
     * </p>
     * 
     * @return The metadata transfer job's report URL.
     */
    public final String reportUrl() {
        return reportUrl;
    }

    /**
     * <p>
     * The metadata transfer job's creation DateTime property.
     * </p>
     * 
     * @return The metadata transfer job's creation DateTime property.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The metadata transfer job's update DateTime property.
     * </p>
     * 
     * @return The metadata transfer job's update DateTime property.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The metadata transfer job's status.
     * </p>
     * 
     * @return The metadata transfer job's status.
     */
    public final MetadataTransferJobStatus status() {
        return status;
    }

    /**
     * <p>
     * The metadata transfer job's progress.
     * </p>
     * 
     * @return The metadata transfer job's progress.
     */
    public final MetadataTransferJobProgress progress() {
        return progress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadataTransferJobId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(metadataTransferJobRole());
        hashCode = 31 * hashCode + Objects.hashCode(reportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetadataTransferJobResponse)) {
            return false;
        }
        GetMetadataTransferJobResponse other = (GetMetadataTransferJobResponse) obj;
        return Objects.equals(metadataTransferJobId(), other.metadataTransferJobId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(destination(), other.destination())
                && Objects.equals(metadataTransferJobRole(), other.metadataTransferJobRole())
                && Objects.equals(reportUrl(), other.reportUrl()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(status(), other.status())
                && Objects.equals(progress(), other.progress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetadataTransferJobResponse").add("MetadataTransferJobId", metadataTransferJobId())
                .add("Arn", arn()).add("Description", description()).add("Sources", hasSources() ? sources() : null)
                .add("Destination", destination()).add("MetadataTransferJobRole", metadataTransferJobRole())
                .add("ReportUrl", reportUrl()).add("CreationDateTime", creationDateTime())
                .add("UpdateDateTime", updateDateTime()).add("Status", status()).add("Progress", progress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataTransferJobId":
            return Optional.ofNullable(clazz.cast(metadataTransferJobId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "metadataTransferJobRole":
            return Optional.ofNullable(clazz.cast(metadataTransferJobRole()));
        case "reportUrl":
            return Optional.ofNullable(clazz.cast(reportUrl()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "progress":
            return Optional.ofNullable(clazz.cast(progress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataTransferJobId", METADATA_TRANSFER_JOB_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("metadataTransferJobRole", METADATA_TRANSFER_JOB_ROLE_FIELD);
        map.put("reportUrl", REPORT_URL_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("progress", PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetadataTransferJobResponse, T> g) {
        return obj -> g.apply((GetMetadataTransferJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMetadataTransferJobResponse> {
        /**
         * <p>
         * The metadata transfer job Id.
         * </p>
         * 
         * @param metadataTransferJobId
         *        The metadata transfer job Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobId(String metadataTransferJobId);

        /**
         * <p>
         * The metadata transfer job ARN.
         * </p>
         * 
         * @param arn
         *        The metadata transfer job ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The metadata transfer job description.
         * </p>
         * 
         * @param description
         *        The metadata transfer job description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The metadata transfer job's sources.
         * </p>
         * 
         * @param sources
         *        The metadata transfer job's sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SourceConfiguration> sources);

        /**
         * <p>
         * The metadata transfer job's sources.
         * </p>
         * 
         * @param sources
         *        The metadata transfer job's sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SourceConfiguration... sources);

        /**
         * <p>
         * The metadata transfer job's sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<SourceConfiguration>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<SourceConfiguration>)
         */
        Builder sources(Consumer<SourceConfiguration.Builder>... sources);

        /**
         * <p>
         * The metadata transfer job's destination.
         * </p>
         * 
         * @param destination
         *        The metadata transfer job's destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DestinationConfiguration destination);

        /**
         * <p>
         * The metadata transfer job's destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destination(DestinationConfiguration)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DestinationConfiguration)
         */
        default Builder destination(Consumer<DestinationConfiguration.Builder> destination) {
            return destination(DestinationConfiguration.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The metadata transfer job's role.
         * </p>
         * 
         * @param metadataTransferJobRole
         *        The metadata transfer job's role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataTransferJobRole(String metadataTransferJobRole);

        /**
         * <p>
         * The metadata transfer job's report URL.
         * </p>
         * 
         * @param reportUrl
         *        The metadata transfer job's report URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportUrl(String reportUrl);

        /**
         * <p>
         * The metadata transfer job's creation DateTime property.
         * </p>
         * 
         * @param creationDateTime
         *        The metadata transfer job's creation DateTime property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The metadata transfer job's update DateTime property.
         * </p>
         * 
         * @param updateDateTime
         *        The metadata transfer job's update DateTime property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The metadata transfer job's status.
         * </p>
         * 
         * @param status
         *        The metadata transfer job's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(MetadataTransferJobStatus status);

        /**
         * <p>
         * The metadata transfer job's status.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataTransferJobStatus.Builder}
         * avoiding the need to create one manually via {@link MetadataTransferJobStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataTransferJobStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(MetadataTransferJobStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link MetadataTransferJobStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(MetadataTransferJobStatus)
         */
        default Builder status(Consumer<MetadataTransferJobStatus.Builder> status) {
            return status(MetadataTransferJobStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The metadata transfer job's progress.
         * </p>
         * 
         * @param progress
         *        The metadata transfer job's progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(MetadataTransferJobProgress progress);

        /**
         * <p>
         * The metadata transfer job's progress.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataTransferJobProgress.Builder}
         * avoiding the need to create one manually via {@link MetadataTransferJobProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataTransferJobProgress.Builder#build()} is called
         * immediately and its result is passed to {@link #progress(MetadataTransferJobProgress)}.
         * 
         * @param progress
         *        a consumer that will call methods on {@link MetadataTransferJobProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progress(MetadataTransferJobProgress)
         */
        default Builder progress(Consumer<MetadataTransferJobProgress.Builder> progress) {
            return progress(MetadataTransferJobProgress.builder().applyMutation(progress).build());
        }
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String metadataTransferJobId;

        private String arn;

        private String description;

        private List<SourceConfiguration> sources = DefaultSdkAutoConstructList.getInstance();

        private DestinationConfiguration destination;

        private String metadataTransferJobRole;

        private String reportUrl;

        private Instant creationDateTime;

        private Instant updateDateTime;

        private MetadataTransferJobStatus status;

        private MetadataTransferJobProgress progress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetadataTransferJobResponse model) {
            super(model);
            metadataTransferJobId(model.metadataTransferJobId);
            arn(model.arn);
            description(model.description);
            sources(model.sources);
            destination(model.destination);
            metadataTransferJobRole(model.metadataTransferJobRole);
            reportUrl(model.reportUrl);
            creationDateTime(model.creationDateTime);
            updateDateTime(model.updateDateTime);
            status(model.status);
            progress(model.progress);
        }

        public final String getMetadataTransferJobId() {
            return metadataTransferJobId;
        }

        public final void setMetadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
        }

        @Override
        public final Builder metadataTransferJobId(String metadataTransferJobId) {
            this.metadataTransferJobId = metadataTransferJobId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SourceConfiguration.Builder> getSources() {
            List<SourceConfiguration.Builder> result = SourceConfigurationsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SourceConfiguration.BuilderImpl> sources) {
            this.sources = SourceConfigurationsCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SourceConfiguration> sources) {
            this.sources = SourceConfigurationsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfiguration... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfiguration.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SourceConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DestinationConfiguration.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DestinationConfiguration.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DestinationConfiguration destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetadataTransferJobRole() {
            return metadataTransferJobRole;
        }

        public final void setMetadataTransferJobRole(String metadataTransferJobRole) {
            this.metadataTransferJobRole = metadataTransferJobRole;
        }

        @Override
        public final Builder metadataTransferJobRole(String metadataTransferJobRole) {
            this.metadataTransferJobRole = metadataTransferJobRole;
            return this;
        }

        public final String getReportUrl() {
            return reportUrl;
        }

        public final void setReportUrl(String reportUrl) {
            this.reportUrl = reportUrl;
        }

        @Override
        public final Builder reportUrl(String reportUrl) {
            this.reportUrl = reportUrl;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final MetadataTransferJobStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(MetadataTransferJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(MetadataTransferJobStatus status) {
            this.status = status;
            return this;
        }

        public final MetadataTransferJobProgress.Builder getProgress() {
            return progress != null ? progress.toBuilder() : null;
        }

        public final void setProgress(MetadataTransferJobProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(MetadataTransferJobProgress progress) {
            this.progress = progress;
            return this;
        }

        @Override
        public GetMetadataTransferJobResponse build() {
            return new GetMetadataTransferJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
