/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEntityRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<UpdateEntityRequest.Builder, UpdateEntityRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateEntityRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(UpdateEntityRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityName").getter(getter(UpdateEntityRequest::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateEntityRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, ComponentUpdateRequest>> COMPONENT_UPDATES_FIELD = SdkField
            .<Map<String, ComponentUpdateRequest>> builder(MarshallingType.MAP)
            .memberName("componentUpdates")
            .getter(getter(UpdateEntityRequest::componentUpdates))
            .setter(setter(Builder::componentUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentUpdateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentUpdateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, CompositeComponentUpdateRequest>> COMPOSITE_COMPONENT_UPDATES_FIELD = SdkField
            .<Map<String, CompositeComponentUpdateRequest>> builder(MarshallingType.MAP)
            .memberName("compositeComponentUpdates")
            .getter(getter(UpdateEntityRequest::compositeComponentUpdates))
            .setter(setter(Builder::compositeComponentUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponentUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CompositeComponentUpdateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositeComponentUpdateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ParentEntityUpdateRequest> PARENT_ENTITY_UPDATE_FIELD = SdkField
            .<ParentEntityUpdateRequest> builder(MarshallingType.SDK_POJO).memberName("parentEntityUpdate")
            .getter(getter(UpdateEntityRequest::parentEntityUpdate)).setter(setter(Builder::parentEntityUpdate))
            .constructor(ParentEntityUpdateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            ENTITY_ID_FIELD, ENTITY_NAME_FIELD, DESCRIPTION_FIELD, COMPONENT_UPDATES_FIELD, COMPOSITE_COMPONENT_UPDATES_FIELD,
            PARENT_ENTITY_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final String entityId;

    private final String entityName;

    private final String description;

    private final Map<String, ComponentUpdateRequest> componentUpdates;

    private final Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates;

    private final ParentEntityUpdateRequest parentEntityUpdate;

    private UpdateEntityRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.description = builder.description;
        this.componentUpdates = builder.componentUpdates;
        this.compositeComponentUpdates = builder.compositeComponentUpdates;
        this.parentEntityUpdate = builder.parentEntityUpdate;
    }

    /**
     * <p>
     * The ID of the workspace that contains the entity.
     * </p>
     * 
     * @return The ID of the workspace that contains the entity.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The ID of the entity.
     * </p>
     * 
     * @return The ID of the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * The description of the entity.
     * </p>
     * 
     * @return The description of the entity.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComponentUpdates() {
        return componentUpdates != null && !(componentUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the component updates in the request. Each string in the mapping must be unique to
     * this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentUpdates} method.
     * </p>
     * 
     * @return An object that maps strings to the component updates in the request. Each string in the mapping must be
     *         unique to this object.
     */
    public final Map<String, ComponentUpdateRequest> componentUpdates() {
        return componentUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeComponentUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompositeComponentUpdates() {
        return compositeComponentUpdates != null && !(compositeComponentUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is an object that maps strings to <code>compositeComponent</code> updates in the request. Each key of the
     * map represents the <code>componentPath</code> of the <code>compositeComponent</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeComponentUpdates} method.
     * </p>
     * 
     * @return This is an object that maps strings to <code>compositeComponent</code> updates in the request. Each key
     *         of the map represents the <code>componentPath</code> of the <code>compositeComponent</code>.
     */
    public final Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates() {
        return compositeComponentUpdates;
    }

    /**
     * <p>
     * An object that describes the update request for a parent entity.
     * </p>
     * 
     * @return An object that describes the update request for a parent entity.
     */
    public final ParentEntityUpdateRequest parentEntityUpdate() {
        return parentEntityUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentUpdates() ? componentUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeComponentUpdates() ? compositeComponentUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEntityRequest)) {
            return false;
        }
        UpdateEntityRequest other = (UpdateEntityRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityName(), other.entityName()) && Objects.equals(description(), other.description())
                && hasComponentUpdates() == other.hasComponentUpdates()
                && Objects.equals(componentUpdates(), other.componentUpdates())
                && hasCompositeComponentUpdates() == other.hasCompositeComponentUpdates()
                && Objects.equals(compositeComponentUpdates(), other.compositeComponentUpdates())
                && Objects.equals(parentEntityUpdate(), other.parentEntityUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEntityRequest").add("WorkspaceId", workspaceId()).add("EntityId", entityId())
                .add("EntityName", entityName()).add("Description", description())
                .add("ComponentUpdates", hasComponentUpdates() ? componentUpdates() : null)
                .add("CompositeComponentUpdates", hasCompositeComponentUpdates() ? compositeComponentUpdates() : null)
                .add("ParentEntityUpdate", parentEntityUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "componentUpdates":
            return Optional.ofNullable(clazz.cast(componentUpdates()));
        case "compositeComponentUpdates":
            return Optional.ofNullable(clazz.cast(compositeComponentUpdates()));
        case "parentEntityUpdate":
            return Optional.ofNullable(clazz.cast(parentEntityUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityName", ENTITY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("componentUpdates", COMPONENT_UPDATES_FIELD);
        map.put("compositeComponentUpdates", COMPOSITE_COMPONENT_UPDATES_FIELD);
        map.put("parentEntityUpdate", PARENT_ENTITY_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEntityRequest, T> g) {
        return obj -> g.apply((UpdateEntityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEntityRequest> {
        /**
         * <p>
         * The ID of the workspace that contains the entity.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The ID of the entity.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param entityName
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * The description of the entity.
         * </p>
         * 
         * @param description
         *        The description of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object that maps strings to the component updates in the request. Each string in the mapping must be
         * unique to this object.
         * </p>
         * 
         * @param componentUpdates
         *        An object that maps strings to the component updates in the request. Each string in the mapping must
         *        be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentUpdates(Map<String, ComponentUpdateRequest> componentUpdates);

        /**
         * <p>
         * This is an object that maps strings to <code>compositeComponent</code> updates in the request. Each key of
         * the map represents the <code>componentPath</code> of the <code>compositeComponent</code>.
         * </p>
         * 
         * @param compositeComponentUpdates
         *        This is an object that maps strings to <code>compositeComponent</code> updates in the request. Each
         *        key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeComponentUpdates(Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates);

        /**
         * <p>
         * An object that describes the update request for a parent entity.
         * </p>
         * 
         * @param parentEntityUpdate
         *        An object that describes the update request for a parent entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityUpdate(ParentEntityUpdateRequest parentEntityUpdate);

        /**
         * <p>
         * An object that describes the update request for a parent entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParentEntityUpdateRequest.Builder}
         * avoiding the need to create one manually via {@link ParentEntityUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParentEntityUpdateRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #parentEntityUpdate(ParentEntityUpdateRequest)}.
         * 
         * @param parentEntityUpdate
         *        a consumer that will call methods on {@link ParentEntityUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentEntityUpdate(ParentEntityUpdateRequest)
         */
        default Builder parentEntityUpdate(Consumer<ParentEntityUpdateRequest.Builder> parentEntityUpdate) {
            return parentEntityUpdate(ParentEntityUpdateRequest.builder().applyMutation(parentEntityUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String entityId;

        private String entityName;

        private String description;

        private Map<String, ComponentUpdateRequest> componentUpdates = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates = DefaultSdkAutoConstructMap.getInstance();

        private ParentEntityUpdateRequest parentEntityUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEntityRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            entityId(model.entityId);
            entityName(model.entityName);
            description(model.description);
            componentUpdates(model.componentUpdates);
            compositeComponentUpdates(model.compositeComponentUpdates);
            parentEntityUpdate(model.parentEntityUpdate);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ComponentUpdateRequest.Builder> getComponentUpdates() {
            Map<String, ComponentUpdateRequest.Builder> result = ComponentUpdatesMapRequestCopier
                    .copyToBuilder(this.componentUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponentUpdates(Map<String, ComponentUpdateRequest.BuilderImpl> componentUpdates) {
            this.componentUpdates = ComponentUpdatesMapRequestCopier.copyFromBuilder(componentUpdates);
        }

        @Override
        public final Builder componentUpdates(Map<String, ComponentUpdateRequest> componentUpdates) {
            this.componentUpdates = ComponentUpdatesMapRequestCopier.copy(componentUpdates);
            return this;
        }

        public final Map<String, CompositeComponentUpdateRequest.Builder> getCompositeComponentUpdates() {
            Map<String, CompositeComponentUpdateRequest.Builder> result = CompositeComponentUpdatesMapRequestCopier
                    .copyToBuilder(this.compositeComponentUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponentUpdates(
                Map<String, CompositeComponentUpdateRequest.BuilderImpl> compositeComponentUpdates) {
            this.compositeComponentUpdates = CompositeComponentUpdatesMapRequestCopier.copyFromBuilder(compositeComponentUpdates);
        }

        @Override
        public final Builder compositeComponentUpdates(Map<String, CompositeComponentUpdateRequest> compositeComponentUpdates) {
            this.compositeComponentUpdates = CompositeComponentUpdatesMapRequestCopier.copy(compositeComponentUpdates);
            return this;
        }

        public final ParentEntityUpdateRequest.Builder getParentEntityUpdate() {
            return parentEntityUpdate != null ? parentEntityUpdate.toBuilder() : null;
        }

        public final void setParentEntityUpdate(ParentEntityUpdateRequest.BuilderImpl parentEntityUpdate) {
            this.parentEntityUpdate = parentEntityUpdate != null ? parentEntityUpdate.build() : null;
        }

        @Override
        public final Builder parentEntityUpdate(ParentEntityUpdateRequest parentEntityUpdate) {
            this.parentEntityUpdate = parentEntityUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEntityRequest build() {
            return new UpdateEntityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
