/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The component update request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentUpdateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentUpdateRequest.Builder, ComponentUpdateRequest> {
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateType").getter(getter(ComponentUpdateRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ComponentUpdateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(ComponentUpdateRequest::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<Map<String, PropertyRequest>> PROPERTY_UPDATES_FIELD = SdkField
            .<Map<String, PropertyRequest>> builder(MarshallingType.MAP)
            .memberName("propertyUpdates")
            .getter(getter(ComponentUpdateRequest::propertyUpdates))
            .setter(setter(Builder::propertyUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentPropertyGroupRequest>> PROPERTY_GROUP_UPDATES_FIELD = SdkField
            .<Map<String, ComponentPropertyGroupRequest>> builder(MarshallingType.MAP)
            .memberName("propertyGroupUpdates")
            .getter(getter(ComponentUpdateRequest::propertyGroupUpdates))
            .setter(setter(Builder::propertyGroupUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroupUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentPropertyGroupRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentPropertyGroupRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TYPE_FIELD,
            DESCRIPTION_FIELD, COMPONENT_TYPE_ID_FIELD, PROPERTY_UPDATES_FIELD, PROPERTY_GROUP_UPDATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String updateType;

    private final String description;

    private final String componentTypeId;

    private final Map<String, PropertyRequest> propertyUpdates;

    private final Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates;

    private ComponentUpdateRequest(BuilderImpl builder) {
        this.updateType = builder.updateType;
        this.description = builder.description;
        this.componentTypeId = builder.componentTypeId;
        this.propertyUpdates = builder.propertyUpdates;
        this.propertyGroupUpdates = builder.propertyGroupUpdates;
    }

    /**
     * <p>
     * The update type of the component update request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link ComponentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The update type of the component update request.
     * @see ComponentUpdateType
     */
    public final ComponentUpdateType updateType() {
        return ComponentUpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The update type of the component update request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link ComponentUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The update type of the component update request.
     * @see ComponentUpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyUpdates() {
        return propertyUpdates != null && !(propertyUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the properties to set in the component type update. Each string in the mapping
     * must be unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyUpdates} method.
     * </p>
     * 
     * @return An object that maps strings to the properties to set in the component type update. Each string in the
     *         mapping must be unique to this object.
     */
    public final Map<String, PropertyRequest> propertyUpdates() {
        return propertyUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroupUpdates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroupUpdates() {
        return propertyGroupUpdates != null && !(propertyGroupUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The property group updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroupUpdates} method.
     * </p>
     * 
     * @return The property group updates.
     */
    public final Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates() {
        return propertyGroupUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyUpdates() ? propertyUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroupUpdates() ? propertyGroupUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentUpdateRequest)) {
            return false;
        }
        ComponentUpdateRequest other = (ComponentUpdateRequest) obj;
        return Objects.equals(updateTypeAsString(), other.updateTypeAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(componentTypeId(), other.componentTypeId())
                && hasPropertyUpdates() == other.hasPropertyUpdates()
                && Objects.equals(propertyUpdates(), other.propertyUpdates())
                && hasPropertyGroupUpdates() == other.hasPropertyGroupUpdates()
                && Objects.equals(propertyGroupUpdates(), other.propertyGroupUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentUpdateRequest").add("UpdateType", updateTypeAsString())
                .add("Description", description()).add("ComponentTypeId", componentTypeId())
                .add("PropertyUpdates", hasPropertyUpdates() ? propertyUpdates() : null)
                .add("PropertyGroupUpdates", hasPropertyGroupUpdates() ? propertyGroupUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "propertyUpdates":
            return Optional.ofNullable(clazz.cast(propertyUpdates()));
        case "propertyGroupUpdates":
            return Optional.ofNullable(clazz.cast(propertyGroupUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("updateType", UPDATE_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("propertyUpdates", PROPERTY_UPDATES_FIELD);
        map.put("propertyGroupUpdates", PROPERTY_GROUP_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentUpdateRequest, T> g) {
        return obj -> g.apply((ComponentUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentUpdateRequest> {
        /**
         * <p>
         * The update type of the component update request.
         * </p>
         * 
         * @param updateType
         *        The update type of the component update request.
         * @see ComponentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentUpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The update type of the component update request.
         * </p>
         * 
         * @param updateType
         *        The update type of the component update request.
         * @see ComponentUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentUpdateType
         */
        Builder updateType(ComponentUpdateType updateType);

        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * An object that maps strings to the properties to set in the component type update. Each string in the mapping
         * must be unique to this object.
         * </p>
         * 
         * @param propertyUpdates
         *        An object that maps strings to the properties to set in the component type update. Each string in the
         *        mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyUpdates(Map<String, PropertyRequest> propertyUpdates);

        /**
         * <p>
         * The property group updates.
         * </p>
         * 
         * @param propertyGroupUpdates
         *        The property group updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroupUpdates(Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates);
    }

    static final class BuilderImpl implements Builder {
        private String updateType;

        private String description;

        private String componentTypeId;

        private Map<String, PropertyRequest> propertyUpdates = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentUpdateRequest model) {
            updateType(model.updateType);
            description(model.description);
            componentTypeId(model.componentTypeId);
            propertyUpdates(model.propertyUpdates);
            propertyGroupUpdates(model.propertyGroupUpdates);
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(ComponentUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Map<String, PropertyRequest.Builder> getPropertyUpdates() {
            Map<String, PropertyRequest.Builder> result = PropertyRequestsCopier.copyToBuilder(this.propertyUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyUpdates(Map<String, PropertyRequest.BuilderImpl> propertyUpdates) {
            this.propertyUpdates = PropertyRequestsCopier.copyFromBuilder(propertyUpdates);
        }

        @Override
        public final Builder propertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
            this.propertyUpdates = PropertyRequestsCopier.copy(propertyUpdates);
            return this;
        }

        public final Map<String, ComponentPropertyGroupRequest.Builder> getPropertyGroupUpdates() {
            Map<String, ComponentPropertyGroupRequest.Builder> result = ComponentPropertyGroupRequestsCopier
                    .copyToBuilder(this.propertyGroupUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroupUpdates(Map<String, ComponentPropertyGroupRequest.BuilderImpl> propertyGroupUpdates) {
            this.propertyGroupUpdates = ComponentPropertyGroupRequestsCopier.copyFromBuilder(propertyGroupUpdates);
        }

        @Override
        public final Builder propertyGroupUpdates(Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates) {
            this.propertyGroupUpdates = ComponentPropertyGroupRequestsCopier.copy(propertyGroupUpdates);
            return this;
        }

        @Override
        public ComponentUpdateRequest build() {
            return new ComponentUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
