/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentTypeRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<CreateComponentTypeRequest.Builder, CreateComponentTypeRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateComponentTypeRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSingleton").getter(getter(CreateComponentTypeRequest::isSingleton))
            .setter(setter(Builder::isSingleton))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(CreateComponentTypeRequest::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("componentTypeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateComponentTypeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, PropertyDefinitionRequest>> PROPERTY_DEFINITIONS_FIELD = SdkField
            .<Map<String, PropertyDefinitionRequest>> builder(MarshallingType.MAP)
            .memberName("propertyDefinitions")
            .getter(getter(CreateComponentTypeRequest::propertyDefinitions))
            .setter(setter(Builder::propertyDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyDefinitionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyDefinitionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("extendsFrom")
            .getter(getter(CreateComponentTypeRequest::extendsFrom))
            .setter(setter(Builder::extendsFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FunctionRequest>> FUNCTIONS_FIELD = SdkField
            .<Map<String, FunctionRequest>> builder(MarshallingType.MAP)
            .memberName("functions")
            .getter(getter(CreateComponentTypeRequest::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FunctionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateComponentTypeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, PropertyGroupRequest>> PROPERTY_GROUPS_FIELD = SdkField
            .<Map<String, PropertyGroupRequest>> builder(MarshallingType.MAP)
            .memberName("propertyGroups")
            .getter(getter(CreateComponentTypeRequest::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyGroupRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyGroupRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> COMPONENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeName").getter(getter(CreateComponentTypeRequest::componentTypeName))
            .setter(setter(Builder::componentTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeName").build()).build();

    private static final SdkField<Map<String, CompositeComponentTypeRequest>> COMPOSITE_COMPONENT_TYPES_FIELD = SdkField
            .<Map<String, CompositeComponentTypeRequest>> builder(MarshallingType.MAP)
            .memberName("compositeComponentTypes")
            .getter(getter(CreateComponentTypeRequest::compositeComponentTypes))
            .setter(setter(Builder::compositeComponentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponentTypes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CompositeComponentTypeRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositeComponentTypeRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            IS_SINGLETON_FIELD, COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, PROPERTY_DEFINITIONS_FIELD, EXTENDS_FROM_FIELD,
            FUNCTIONS_FIELD, TAGS_FIELD, PROPERTY_GROUPS_FIELD, COMPONENT_TYPE_NAME_FIELD, COMPOSITE_COMPONENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final Boolean isSingleton;

    private final String componentTypeId;

    private final String description;

    private final Map<String, PropertyDefinitionRequest> propertyDefinitions;

    private final List<String> extendsFrom;

    private final Map<String, FunctionRequest> functions;

    private final Map<String, String> tags;

    private final Map<String, PropertyGroupRequest> propertyGroups;

    private final String componentTypeName;

    private final Map<String, CompositeComponentTypeRequest> compositeComponentTypes;

    private CreateComponentTypeRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.isSingleton = builder.isSingleton;
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.tags = builder.tags;
        this.propertyGroups = builder.propertyGroups;
        this.componentTypeName = builder.componentTypeName;
        this.compositeComponentTypes = builder.compositeComponentTypes;
    }

    /**
     * <p>
     * The ID of the workspace that contains the component type.
     * </p>
     * 
     * @return The ID of the workspace that contains the component type.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * A Boolean value that specifies whether an entity can have more than one component of this type.
     * </p>
     * 
     * @return A Boolean value that specifies whether an entity can have more than one component of this type.
     */
    public final Boolean isSingleton() {
        return isSingleton;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyDefinitions() {
        return propertyDefinitions != null && !(propertyDefinitions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the property definitions in the component type. Each string in the mapping must be
     * unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyDefinitions} method.
     * </p>
     * 
     * @return An object that maps strings to the property definitions in the component type. Each string in the mapping
     *         must be unique to this object.
     */
    public final Map<String, PropertyDefinitionRequest> propertyDefinitions() {
        return propertyDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtendsFrom property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtendsFrom() {
        return extendsFrom != null && !(extendsFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parent component type to extend.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtendsFrom} method.
     * </p>
     * 
     * @return Specifies the parent component type to extend.
     */
    public final List<String> extendsFrom() {
        return extendsFrom;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the functions in the component type. Each string in the mapping must be unique to
     * this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return An object that maps strings to the functions in the component type. Each string in the mapping must be
     *         unique to this object.
     */
    public final Map<String, FunctionRequest> functions() {
        return functions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that you can use to manage the component type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that you can use to manage the component type.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructMap);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return
     */
    public final Map<String, PropertyGroupRequest> propertyGroups() {
        return propertyGroups;
    }

    /**
     * <p>
     * A friendly name for the component type.
     * </p>
     * 
     * @return A friendly name for the component type.
     */
    public final String componentTypeName() {
        return componentTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeComponentTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompositeComponentTypes() {
        return compositeComponentTypes != null && !(compositeComponentTypes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>.
     * <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeComponentTypes} method.
     * </p>
     * 
     * @return This is an object that maps strings to <code>compositeComponentTypes</code> of the
     *         <code>componentType</code>. <code>CompositeComponentType</code> is referenced by
     *         <code>componentTypeId</code>.
     */
    public final Map<String, CompositeComponentTypeRequest> compositeComponentTypes() {
        return compositeComponentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyDefinitions() ? propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExtendsFrom() ? extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeComponentTypes() ? compositeComponentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentTypeRequest)) {
            return false;
        }
        CreateComponentTypeRequest other = (CreateComponentTypeRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(isSingleton(), other.isSingleton())
                && Objects.equals(componentTypeId(), other.componentTypeId())
                && Objects.equals(description(), other.description())
                && hasPropertyDefinitions() == other.hasPropertyDefinitions()
                && Objects.equals(propertyDefinitions(), other.propertyDefinitions())
                && hasExtendsFrom() == other.hasExtendsFrom() && Objects.equals(extendsFrom(), other.extendsFrom())
                && hasFunctions() == other.hasFunctions() && Objects.equals(functions(), other.functions())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(propertyGroups(), other.propertyGroups())
                && Objects.equals(componentTypeName(), other.componentTypeName())
                && hasCompositeComponentTypes() == other.hasCompositeComponentTypes()
                && Objects.equals(compositeComponentTypes(), other.compositeComponentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComponentTypeRequest").add("WorkspaceId", workspaceId()).add("IsSingleton", isSingleton())
                .add("ComponentTypeId", componentTypeId()).add("Description", description())
                .add("PropertyDefinitions", hasPropertyDefinitions() ? propertyDefinitions() : null)
                .add("ExtendsFrom", hasExtendsFrom() ? extendsFrom() : null)
                .add("Functions", hasFunctions() ? functions() : null).add("Tags", hasTags() ? tags() : null)
                .add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null)
                .add("ComponentTypeName", componentTypeName())
                .add("CompositeComponentTypes", hasCompositeComponentTypes() ? compositeComponentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "isSingleton":
            return Optional.ofNullable(clazz.cast(isSingleton()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "propertyDefinitions":
            return Optional.ofNullable(clazz.cast(propertyDefinitions()));
        case "extendsFrom":
            return Optional.ofNullable(clazz.cast(extendsFrom()));
        case "functions":
            return Optional.ofNullable(clazz.cast(functions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "propertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        case "componentTypeName":
            return Optional.ofNullable(clazz.cast(componentTypeName()));
        case "compositeComponentTypes":
            return Optional.ofNullable(clazz.cast(compositeComponentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("isSingleton", IS_SINGLETON_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("propertyDefinitions", PROPERTY_DEFINITIONS_FIELD);
        map.put("extendsFrom", EXTENDS_FROM_FIELD);
        map.put("functions", FUNCTIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("propertyGroups", PROPERTY_GROUPS_FIELD);
        map.put("componentTypeName", COMPONENT_TYPE_NAME_FIELD);
        map.put("compositeComponentTypes", COMPOSITE_COMPONENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentTypeRequest, T> g) {
        return obj -> g.apply((CreateComponentTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComponentTypeRequest> {
        /**
         * <p>
         * The ID of the workspace that contains the component type.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * A Boolean value that specifies whether an entity can have more than one component of this type.
         * </p>
         * 
         * @param isSingleton
         *        A Boolean value that specifies whether an entity can have more than one component of this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSingleton(Boolean isSingleton);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object that maps strings to the property definitions in the component type. Each string in the mapping
         * must be unique to this object.
         * </p>
         * 
         * @param propertyDefinitions
         *        An object that maps strings to the property definitions in the component type. Each string in the
         *        mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> propertyDefinitions);

        /**
         * <p>
         * Specifies the parent component type to extend.
         * </p>
         * 
         * @param extendsFrom
         *        Specifies the parent component type to extend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(Collection<String> extendsFrom);

        /**
         * <p>
         * Specifies the parent component type to extend.
         * </p>
         * 
         * @param extendsFrom
         *        Specifies the parent component type to extend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(String... extendsFrom);

        /**
         * <p>
         * An object that maps strings to the functions in the component type. Each string in the mapping must be unique
         * to this object.
         * </p>
         * 
         * @param functions
         *        An object that maps strings to the functions in the component type. Each string in the mapping must be
         *        unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Map<String, FunctionRequest> functions);

        /**
         * <p>
         * Metadata that you can use to manage the component type.
         * </p>
         * 
         * @param tags
         *        Metadata that you can use to manage the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p/>
         * 
         * @param propertyGroups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Map<String, PropertyGroupRequest> propertyGroups);

        /**
         * <p>
         * A friendly name for the component type.
         * </p>
         * 
         * @param componentTypeName
         *        A friendly name for the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeName(String componentTypeName);

        /**
         * <p>
         * This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>. <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.
         * </p>
         * 
         * @param compositeComponentTypes
         *        This is an object that maps strings to <code>compositeComponentTypes</code> of the
         *        <code>componentType</code>. <code>CompositeComponentType</code> is referenced by
         *        <code>componentTypeId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeComponentTypes(Map<String, CompositeComponentTypeRequest> compositeComponentTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private Boolean isSingleton;

        private String componentTypeId;

        private String description;

        private Map<String, PropertyDefinitionRequest> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FunctionRequest> functions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, PropertyGroupRequest> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private String componentTypeName;

        private Map<String, CompositeComponentTypeRequest> compositeComponentTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentTypeRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            isSingleton(model.isSingleton);
            componentTypeId(model.componentTypeId);
            description(model.description);
            propertyDefinitions(model.propertyDefinitions);
            extendsFrom(model.extendsFrom);
            functions(model.functions);
            tags(model.tags);
            propertyGroups(model.propertyGroups);
            componentTypeName(model.componentTypeName);
            compositeComponentTypes(model.compositeComponentTypes);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Boolean getIsSingleton() {
            return isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyDefinitionRequest.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionRequest.Builder> result = PropertyDefinitionsRequestCopier
                    .copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionRequest.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copy(propertyDefinitions);
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendsFrom(String... extendsFrom) {
            extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionRequest.Builder> getFunctions() {
            Map<String, FunctionRequest.Builder> result = FunctionsRequestCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionRequest.BuilderImpl> functions) {
            this.functions = FunctionsRequestCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Map<String, FunctionRequest> functions) {
            this.functions = FunctionsRequestCopier.copy(functions);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, PropertyGroupRequest.Builder> getPropertyGroups() {
            Map<String, PropertyGroupRequest.Builder> result = PropertyGroupsRequestCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, PropertyGroupRequest.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsRequestCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, PropertyGroupRequest> propertyGroups) {
            this.propertyGroups = PropertyGroupsRequestCopier.copy(propertyGroups);
            return this;
        }

        public final String getComponentTypeName() {
            return componentTypeName;
        }

        public final void setComponentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final Builder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            return this;
        }

        public final Map<String, CompositeComponentTypeRequest.Builder> getCompositeComponentTypes() {
            Map<String, CompositeComponentTypeRequest.Builder> result = CompositeComponentTypesRequestCopier
                    .copyToBuilder(this.compositeComponentTypes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponentTypes(
                Map<String, CompositeComponentTypeRequest.BuilderImpl> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesRequestCopier.copyFromBuilder(compositeComponentTypes);
        }

        @Override
        public final Builder compositeComponentTypes(Map<String, CompositeComponentTypeRequest> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesRequestCopier.copy(compositeComponentTypes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentTypeRequest build() {
            return new CreateComponentTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
