/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AWS IoT SiteWise soucre configuration filter.[need held with desc here]
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotSiteWiseSourceConfigurationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<IotSiteWiseSourceConfigurationFilter.Builder, IotSiteWiseSourceConfigurationFilter> {
    private static final SdkField<FilterByAssetModel> FILTER_BY_ASSET_MODEL_FIELD = SdkField
            .<FilterByAssetModel> builder(MarshallingType.SDK_POJO).memberName("filterByAssetModel")
            .getter(getter(IotSiteWiseSourceConfigurationFilter::filterByAssetModel)).setter(setter(Builder::filterByAssetModel))
            .constructor(FilterByAssetModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByAssetModel").build())
            .build();

    private static final SdkField<FilterByAsset> FILTER_BY_ASSET_FIELD = SdkField
            .<FilterByAsset> builder(MarshallingType.SDK_POJO).memberName("filterByAsset")
            .getter(getter(IotSiteWiseSourceConfigurationFilter::filterByAsset)).setter(setter(Builder::filterByAsset))
            .constructor(FilterByAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByAsset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_ASSET_MODEL_FIELD,
            FILTER_BY_ASSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FilterByAssetModel filterByAssetModel;

    private final FilterByAsset filterByAsset;

    private final Type type;

    private IotSiteWiseSourceConfigurationFilter(BuilderImpl builder) {
        this.filterByAssetModel = builder.filterByAssetModel;
        this.filterByAsset = builder.filterByAsset;
        this.type = builder.type;
    }

    /**
     * <p>
     * Filter by asset model.
     * </p>
     * 
     * @return Filter by asset model.
     */
    public final FilterByAssetModel filterByAssetModel() {
        return filterByAssetModel;
    }

    /**
     * <p>
     * Filter by asset.
     * </p>
     * 
     * @return Filter by asset.
     */
    public final FilterByAsset filterByAsset() {
        return filterByAsset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterByAssetModel());
        hashCode = 31 * hashCode + Objects.hashCode(filterByAsset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseSourceConfigurationFilter)) {
            return false;
        }
        IotSiteWiseSourceConfigurationFilter other = (IotSiteWiseSourceConfigurationFilter) obj;
        return Objects.equals(filterByAssetModel(), other.filterByAssetModel())
                && Objects.equals(filterByAsset(), other.filterByAsset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotSiteWiseSourceConfigurationFilter").add("FilterByAssetModel", filterByAssetModel())
                .add("FilterByAsset", filterByAsset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterByAssetModel":
            return Optional.ofNullable(clazz.cast(filterByAssetModel()));
        case "filterByAsset":
            return Optional.ofNullable(clazz.cast(filterByAsset()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #filterByAssetModel()} initialized to the given value.
     *
     * <p>
     * Filter by asset model.
     * </p>
     * 
     * @param filterByAssetModel
     *        Filter by asset model.
     */
    public static IotSiteWiseSourceConfigurationFilter fromFilterByAssetModel(FilterByAssetModel filterByAssetModel) {
        return builder().filterByAssetModel(filterByAssetModel).build();
    }

    /**
     * Create an instance of this class with {@link #filterByAssetModel()} initialized to the given value.
     *
     * <p>
     * Filter by asset model.
     * </p>
     * 
     * @param filterByAssetModel
     *        Filter by asset model.
     */
    public static IotSiteWiseSourceConfigurationFilter fromFilterByAssetModel(
            Consumer<FilterByAssetModel.Builder> filterByAssetModel) {
        FilterByAssetModel.Builder builder = FilterByAssetModel.builder();
        filterByAssetModel.accept(builder);
        return fromFilterByAssetModel(builder.build());
    }

    /**
     * Create an instance of this class with {@link #filterByAsset()} initialized to the given value.
     *
     * <p>
     * Filter by asset.
     * </p>
     * 
     * @param filterByAsset
     *        Filter by asset.
     */
    public static IotSiteWiseSourceConfigurationFilter fromFilterByAsset(FilterByAsset filterByAsset) {
        return builder().filterByAsset(filterByAsset).build();
    }

    /**
     * Create an instance of this class with {@link #filterByAsset()} initialized to the given value.
     *
     * <p>
     * Filter by asset.
     * </p>
     * 
     * @param filterByAsset
     *        Filter by asset.
     */
    public static IotSiteWiseSourceConfigurationFilter fromFilterByAsset(Consumer<FilterByAsset.Builder> filterByAsset) {
        FilterByAsset.Builder builder = FilterByAsset.builder();
        filterByAsset.accept(builder);
        return fromFilterByAsset(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterByAssetModel", FILTER_BY_ASSET_MODEL_FIELD);
        map.put("filterByAsset", FILTER_BY_ASSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseSourceConfigurationFilter, T> g) {
        return obj -> g.apply((IotSiteWiseSourceConfigurationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotSiteWiseSourceConfigurationFilter> {
        /**
         * <p>
         * Filter by asset model.
         * </p>
         * 
         * @param filterByAssetModel
         *        Filter by asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByAssetModel(FilterByAssetModel filterByAssetModel);

        /**
         * <p>
         * Filter by asset model.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterByAssetModel.Builder} avoiding the
         * need to create one manually via {@link FilterByAssetModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterByAssetModel.Builder#build()} is called immediately and its
         * result is passed to {@link #filterByAssetModel(FilterByAssetModel)}.
         * 
         * @param filterByAssetModel
         *        a consumer that will call methods on {@link FilterByAssetModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterByAssetModel(FilterByAssetModel)
         */
        default Builder filterByAssetModel(Consumer<FilterByAssetModel.Builder> filterByAssetModel) {
            return filterByAssetModel(FilterByAssetModel.builder().applyMutation(filterByAssetModel).build());
        }

        /**
         * <p>
         * Filter by asset.
         * </p>
         * 
         * @param filterByAsset
         *        Filter by asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterByAsset(FilterByAsset filterByAsset);

        /**
         * <p>
         * Filter by asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterByAsset.Builder} avoiding the need
         * to create one manually via {@link FilterByAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterByAsset.Builder#build()} is called immediately and its
         * result is passed to {@link #filterByAsset(FilterByAsset)}.
         * 
         * @param filterByAsset
         *        a consumer that will call methods on {@link FilterByAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterByAsset(FilterByAsset)
         */
        default Builder filterByAsset(Consumer<FilterByAsset.Builder> filterByAsset) {
            return filterByAsset(FilterByAsset.builder().applyMutation(filterByAsset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterByAssetModel filterByAssetModel;

        private FilterByAsset filterByAsset;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseSourceConfigurationFilter model) {
            filterByAssetModel(model.filterByAssetModel);
            filterByAsset(model.filterByAsset);
        }

        public final FilterByAssetModel.Builder getFilterByAssetModel() {
            return filterByAssetModel != null ? filterByAssetModel.toBuilder() : null;
        }

        public final void setFilterByAssetModel(FilterByAssetModel.BuilderImpl filterByAssetModel) {
            Object oldValue = this.filterByAssetModel;
            this.filterByAssetModel = filterByAssetModel != null ? filterByAssetModel.build() : null;
            handleUnionValueChange(Type.FILTER_BY_ASSET_MODEL, oldValue, this.filterByAssetModel);
        }

        @Override
        public final Builder filterByAssetModel(FilterByAssetModel filterByAssetModel) {
            Object oldValue = this.filterByAssetModel;
            this.filterByAssetModel = filterByAssetModel;
            handleUnionValueChange(Type.FILTER_BY_ASSET_MODEL, oldValue, this.filterByAssetModel);
            return this;
        }

        public final FilterByAsset.Builder getFilterByAsset() {
            return filterByAsset != null ? filterByAsset.toBuilder() : null;
        }

        public final void setFilterByAsset(FilterByAsset.BuilderImpl filterByAsset) {
            Object oldValue = this.filterByAsset;
            this.filterByAsset = filterByAsset != null ? filterByAsset.build() : null;
            handleUnionValueChange(Type.FILTER_BY_ASSET, oldValue, this.filterByAsset);
        }

        @Override
        public final Builder filterByAsset(FilterByAsset filterByAsset) {
            Object oldValue = this.filterByAsset;
            this.filterByAsset = filterByAsset;
            handleUnionValueChange(Type.FILTER_BY_ASSET, oldValue, this.filterByAsset);
            return this;
        }

        @Override
        public IotSiteWiseSourceConfigurationFilter build() {
            return new IotSiteWiseSourceConfigurationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IotSiteWiseSourceConfigurationFilter#type()
     */
    public enum Type {
        FILTER_BY_ASSET_MODEL,

        FILTER_BY_ASSET,

        UNKNOWN_TO_SDK_VERSION
    }
}
